import {
  ContainerComponent
} from "../controller.js";

/**
 * 数据表格组件
 * @param {[type]} dataModel [description]
 */
export default class Grid extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Grid", dataModel, parent);

    this.curPage = 1;
    this.pageCount = 0;
    this.rowsCount = 0;
    this.headerResizeStartX = 0;
    this.dataList = [];
    this.orders = [];
  }

  /*******************  数据绑定设置  *******************/

  get loadDataService() {
    return this.dataModel.loadDataService
  }
  set loadDataService(value) {
    this.dataModel.loadDataService = value
  }

  get dataBindingMember() {
    return this.dataModel.dataBindingMember
  }
  set dataBindingMember(value) {
    this.dataModel.dataBindingMember = value
  }

  get dataBindingKey() {
    return this.dataModel.dataBindingKey
  }
  set dataBindingKey(value) {
    this.dataModel.dataBindingKey = value
  }

  get delDataService() {
    return this.dataModel.delDataService
  }
  set delDataService(value) {
    this.dataModel.delDataService = value
  }

  /*******************  容器设置  *******************/

  get hasAttachedChilds() {
    return true
  }
  
  getContainerEl(cptId) {
    let cpt = tfp.get(cptId);
    let dataRow = this._jqObj.children(".tfp-grid-datalist").children(".tfp-grid-datarow").eq(0);
    let cellIndex = cpt.cellIndex;
    //if(this.showCheckbox) cellIndex++;
    //if(this.showRowNum) cellIndex++;
    return dataRow.children(".tfp-grid-datarow-cell").get(cellIndex);
  }

  /*******************  表头设置  *******************/

  get showHeader() {
    return this.dataModel.showHeader ? true : false;
  }
  set showHeader(value) {
    this.dataModel.showHeader = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get headerBold() {
    if (this.dataModel.headerBold == undefined || this.dataModel.headerBold == null) return true;
    return this.dataModel.headerBold ? true : false;
  }
  set headerBold(value) {
    this.dataModel.headerBold = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.headerBold) {
        this._jqObj.children(".tfp-grid-header").children("div").css("font-weight", "bold");
      } else {
        this._jqObj.children(".tfp-grid-header").children("div").css("font-weight", "normal");
      }
    }
  }

  get headerBgColor() {
    return this.dataModel.headerBgColor ? this.dataModel.headerBgColor : "#F9F9F9";
  }
  set headerBgColor(value) {
    this.dataModel.headerBgColor = value;
    if (this._jqObj) {
      this._jqObj.children(".tfp-grid-header").css("background-color", value);
      this._jqObj.children(".tfp-grid-header").children("div").css("background-color", value);
    }
  }

  get headerTextColor() {
    return this.dataModel.headerTextColor ? this.dataModel.headerTextColor : "#333333";
  }
  set headerTextColor(value) {
    this.dataModel.headerTextColor = value;
    if (this._jqObj) {
      this._jqObj.children(".tfp-grid-header").children("div").css("color", value);
    }
  }

  get headerHeight() {
    return this.dataModel.headerHeight ? this.dataModel.headerHeight : 40;
  }
  set headerHeight(value) {
    if (!value) return;
    let height = parseInt((value + "").replace("px", ""));
    this.dataModel.headerHeight = height;
    if (this._jqObj) {
      this._jqObj.children(".tfp-grid-header").css("height", height + "px");
      this._jqObj.children(".tfp-grid-header").children("div").css("height", height + "px");
      this.resetDataListPosition();
    }
  }

  /*******************  表体设置  *******************/

  get showRowNum() {
    return this.dataModel.showRowNum ? true : false;
  }
  set showRowNum(value) {
    this.dataModel.showRowNum = value ? true : false;
    this.reRender();
  }

  get showBorder() {
    return this.dataModel.showBorder ? true : false;
  }
  set showBorder(value) {
    this.dataModel.showBorder = value ? true : false;
    this.reRender();
  }

  get showCheckbox() {
    return this.dataModel.showCheckbox ? true : false;
  }
  set showCheckbox(value) {
    this.dataModel.showCheckbox = value ? true : false;
    this.reRender();
  }

  get borderColor() {
    return this.dataModel.borderColor ? this.dataModel.borderColor : "#E6E6E6";
  }
  set borderColor(value) {
    this.dataModel.borderColor = value;
    this.reRender();
  }

  get singleRowBgColor() {
    if (this.dataModel.singleColor) return this.dataModel.singleColor;
    return this.dataModel.singleRowBgColor;
  }
  set singleRowBgColor(value) {
    this.dataModel.singleRowBgColor = value;
    if (this._jqObj) {
      var that = this;
      this._jqObj.children(".tfp-grid-datalist").children("div").each(function (index) {
        if (index % 2 == 0) {
          let color = "";
          if (value) color = value;
          $(this).css("background-color", color);
          $(this).children("div").css("background-color", color);
        }
      });
    }
  }

  get doubleRowBgColor() {
    if (this.dataModel.doubleColor) return this.dataModel.doubleColor;
    return this.dataModel.doubleRowBgColor;
  }
  set doubleRowBgColor(value) {
    this.dataModel.doubleRowBgColor = value;
    if (this._jqObj) {
      var that = this;
      this._jqObj.children(".tfp-grid-datalist").children("div").each(function (index) {
        if (index % 2 == 1) {
          let color = "";
          if (value) color = value;
          $(this).css("background-color", color);
          $(this).children("div").css("background-color", color);
        }
      });
    }
  }

  get rowHeight() {
    return this.dataModel.rowHeight
  }
  set rowHeight(value) {
    this.dataModel.rowHeight = value;
    if (this._jqObj) {
      let rowHeight = value + "";
      if (!rowHeight) rowHeight = "40";
      if (rowHeight.indexOf("px") > 0) rowHeight = rowHeight.replace("px", "");
      let divDataList = this._jqObj.children(".tfp-grid-datalist");
      divDataList.children("div").css("height", rowHeight + "px");
      divDataList.children("div").children("div").css("height", rowHeight + "px");
    }
  }

  get disableMouseOverBg() {
    return this.dataModel.disableMouseOverBg
  }
  set disableMouseOverBg(value) {
    this.dataModel.disableMouseOverBg = value ? true : false;
  }
  

  /*******************  表尾设置  *******************/

  get showSumer() {
    return this.dataModel.showSumer
  }
  set showSumer(value) {
    this.dataModel.showSumer = value ? true : false;
    if (this._jqObj) {
      this.resetFooter();
    }
  }

  get allowPaging() {
    return this.dataModel.allowPaging ? true : false;
  }
  set allowPaging(value) {
    this.dataModel.allowPaging = value ? true : false;
    if (this._jqObj) {
      this.resetFooter();
    }
  }

  get pageSize() {
    return this.dataModel.pageSize ? this.dataModel.pageSize : 20
  }
  set pageSize(value) {
    this.dataModel.pageSize = value ? value : 20
  }

  get columns() {
    let columns = this.dataModel.columns;
    if (!columns) {
      columns = [];
      if (this._tfp.isDesigning) {
        //不能直接修改this.columns，以免保存到tfp文件中
        columns = [{
          name: "列标题1",
          width: "100px",
          align: "center"
        }, {
          name: "列标题2",
          width: "100px",
          align: "center"
        }];
      }
    }
    return columns;
  }
  set columns(value) {
    this.dataModel.columns = value;
    if (this._jqObj) {
      if(!this.dataModel.components) this.dataModel.components = [];
      let components = [];
      
      for(let i=0;i<this.dataModel.columns.length;i++) {
        let col = this.dataModel.columns[i];
        if(col.contentType=="custom") {
          let cellCdm = null;
          for(let j=0;j<this.dataModel.components.length;j++) {
            let cdm = this.dataModel.components[j];
            if(cdm.cellIndex == col.oldIndex) {
              cellCdm = cdm;
              cellCdm.cellIndex = i;
              break;
            }
          }
          //如果原来不是自定义的列，现在变成自定义了，或者新增的自定义列，则需要增加到子组件数组中
          if(!cellCdm) {
            let idIndex = 0;
            while(tfp.get(this.id+"_cell_"+idIndex)) {
              idIndex++;
            }
            cellCdm = {
              id: this.id+"_cell_"+idIndex,
              type: "GridCell",
              isAttached: true,
              cellIndex: i
            };
          }
          components.push(JSON.parse(JSON.stringify(cellCdm)));
        }
        delete col["oldIndex"];
      }
      //删除原有的子组件及DOM元素
      for(let i=0;i<this.dataModel.components.length;i++) {
        let cdmChild = this.dataModel.components[i];
        /*let cellIndex = cdmChild.cellIndex;
        //如果某个列的类型原来就是自定义，需要保留设置
        if(!(cellIndex>=this.dataModel.columns.length || this.dataModel.columns[i].contentType!="custom")) {
          components.push(JSON.parse(JSON.stringify(cdmChild)));
        }*/
        tfp.remove(cdmChild.id);
      }
      //重置子组件列表
      this.dataModel.components = [];

      //重新渲染数据表格组件（不包括子组件）
      this.reRender();

      //重新渲染子组件
      for(let i=0;i<components.length;i++) {
        let cdmChild = components[i];
        tfp.render(cdmChild, this);
      }
    }
  }

  get header() {
    return this._jqObj.children(".tfp-grid-header");
  }
  set header(value) {
    //
  }

  get body() {
    return this._jqObj.children(".tfp-grid-datalist");
  }
  set body(value) {
    //
  }

  get sumer() {
    return this._jqObj.children(".tfp-grid-sumer");
  }
  set sumer(value) {
    //
  }

  get footer() {
    return this._jqObj.children(".tfp-grid-footer");
  }
  set footer(value) {
    //
  }

  /*******************  树形显示设置  *******************/

  get showTree() {
    return this.dataModel.showTree ? true : false;
  }
  set showTree(value) {
    this.dataModel.showTree = value ? true : false;
  }

  get expandAllNode() {
    return this.dataModel.expandAllNode ? true : false;
  }
  set expandAllNode(value) {
    this.dataModel.expandAllNode = value ? true : false;
  }

  get treeColIndex() {
    return this.dataModel.treeColIndex
  }
  set treeColIndex(value) {
    this.dataModel.treeColIndex = parseInt(value);
  }

  get nodeIdField() {
    return this.dataModel.nodeIdField
  }
  set nodeIdField(value) {
    this.dataModel.nodeIdField = value;
  }

  get parentNodeIdField() {
    return this.dataModel.parentNodeIdField
  }
  set parentNodeIdField(value) {
    this.dataModel.parentNodeIdField = value;
  }

  get rootNodeId() {
    return this.dataModel.rootNodeId
  }
  set rootNodeId(value) {
    this.dataModel.rootNodeId = value;
  }

  resetFooter() {
    let divSumer = this._jqObj.children(".tfp-grid-sumer");
    if (divSumer.length > 0) divSumer.remove();
    let divFooter = this._jqObj.children(".tfp-grid-footer");
    if (divFooter.length > 0) divFooter.remove();
    if (this.showSumer) this._jqObj.append(this.getSumerHtml());
    if (this.allowPaging) this._jqObj.append(this.getFooterHtml());
    this.resetDataListPosition();
  }

  reRender() {
    this._jqObj.empty();
    let Render = this._tfp.renders[this.type];
    if (Render) {
      let render = new Render(this._tfp, this.dataModel, this.level);
      this._jqObj.html(render.getBodyHtml(false));
    }
    this.initDesigning();
  }

  getHeaderHtml() {
    let indent = this.getHtmlIndent();
    let htmlHeader = indent + "\t<div class=\"tfp-grid-header\" style=\""
      + "background-color:" + this.headerBgColor + ";border: 1px solid "
      + this.borderColor + ";height:" + this.headerHeight + ";\">\r\n";
    let heightStyle = "height:" + (this.headerHeight - 2) + "px;";
    this.rowWith = 0;
    let headerStyle = "";
    if (this.headerTextColor) headerStyle += "color:" + this.headerTextColor + ";";
    if (this.headerBold) headerStyle += "font-weight:bold;";
    if (this.dataModel.showCheckbox) {
      this.rowWith += 30;
      htmlHeader += indent + "\t\t\t\t<div class=\"tfp-grid-header-checkbox\" "
        + "style=\"flex-basis: 30px;background-color:" + this.headerBgColor + ";" + heightStyle;
      if (this.showBorder) {
        htmlHeader += "border-right:1px solid " + this.borderColor + ";";
        this.rowWith++;
      }
      htmlHeader += "\"><input type=\"checkbox\" onclick=\""
        + this.dataModel.id + ".checkAll(this)\" /></div>\r\n";
    }
    if (this.dataModel.showRowNum) {
      this.rowWith += 50;
      htmlHeader += indent + "\t\t\t\t<div class=\"tfp-grid-header-index\" "
        + " style=\"flex-basis: 50px;background-color:" + this.headerBgColor + ";" + heightStyle + headerStyle;
      if (this.showBorder) {
        htmlHeader += "border-right:1px solid " + this.borderColor + ";";
        this.rowWith++;
      }
      htmlHeader += "\">序号</div>\r\n";
    }
    let havePercentWidth = false;
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      htmlHeader += indent + "\t\t\t\t<div class=\"tfp-grid-header-col\"";
      let style = headerStyle;
      let colWidth = this.getColWidth(col, i, true);
      if (colWidth.indexOf("px") < 0 && colWidth.indexOf("%") < 0) colWidth += "px";
      htmlHeader += " style=\"flex-basis: " + colWidth + ";background-color:"
        + this.headerBgColor + ";" + heightStyle + style;
      //if (colWidth.indexOf("%") > 0) {
      //  havePercentWidth = true;
      //} else {
      //TODO 列宽暂不支持百分比的精确计算，只是简单的把%替换掉了
      //  this.rowWith += parseInt(colWidth.replace("px", "").replace("%", ""));
      //}
      //htmlHeader += " align=\"" + (col.headerAlign ? col.headerAlign : "center") + "\"";
      htmlHeader += "\"";
      htmlHeader += ">" + col.name;

      if (col.allowOrder && col.orderField) {
        let up = "";
        let down = "";
        if(col.orderType=="desc") up = "-blue";
        if(col.orderType=="asc") down = "-blue";
        htmlHeader += `<div class="tfp-grid-header-order" style="top:${(this.headerHeight - 26)/2}px;">
            <img title="倒序" src="${this._tfp.rootPath}/src/components/grid/images/icon-up${up}.png" onclick="${this.id}.order('${col.orderField}', 'desc', this)" />
            <img title="正序" src="${this._tfp.rootPath}/src/components/grid/images/icon-down${down}.png" onclick="${this.id}.order('${col.orderField}', 'asc', this)" />
          </div>`
      }

      htmlHeader += "</div>\r\n";
      //增加一个列宽拖拽调节大小的框
      if (i < (this.columns.length - 1) && this.showBorder) {
        htmlHeader += indent + "\t\t\t\t<div class=\"tfp-grid-header-resize\" style=\"flex-basis:3px;padding:0;" 
          + heightStyle+"\" onmousedown=\""+this.id+".headerResizeOnMouseDown(this, "+i+")\">"
          +"<span style=\"width:1px;cursor: col-resize;margin-left:0;background-color:"
          +this.borderColor+";"+heightStyle+"\"></span></div>\r\n";
        this.rowWith = this.rowWith + 3;
      }
    }
    if (!this._tfp.isDesigning) htmlHeader += indent + "\t\t\t\t<div style=\"background-color:"
      + this.headerBgColor + ";" + heightStyle + "\"></div>";
    htmlHeader += indent + "\t\t\t</div>\r\n";
    return htmlHeader;
  }

  headerResizeOnMouseDown(div, cellIndex) {
    var e = window.event;
    this.headerResizeStartX = e.clientX;
    this.headerResizeCellIndex = cellIndex;
    this.headerResizeDivWidth = $(div).prev().width();
  }

  /**
   * 获得列宽
   * @param  {[type]} width [description]
   * @return {[type]}       [description]
   */
  getColWidth(col, colIndex, isHeader) {
    //如果不是标题列，且显示标题，则列宽以标题列的宽度为准，因为
    //if(this.showHeader && !isHeader) {
    //  return this._jqObj.children(".tfp-grid-header").find(".tfp-grid-header-col").eq(colIndex).outerWidth()+"";
    //}
    if (!col.width || col.width == "px") return "80";
    return (col.width + "").replace("px", "");
  }

  resetDataListPosition() {
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    if (this.dataModel.showHeader) {
      divDataList.css("top", (this.headerHeight - 1) + "px");
    } else {
      divDataList.css("top", "0");
    }
    let dataListBottom = 0;
    if (this.dataModel.showSumer) dataListBottom += 39;
    if (this.dataModel.allowPaging) dataListBottom += 49;
    divDataList.css("bottom", dataListBottom + "px");
  };

  setCptDataFormat(cdm) {
    //let cpt = this._tfp.get(cdm.id);
    if(cdm.dataBindingFormat) {
      cdm.value = cdm.dataBindingFormat;
    }
    if(cdm.components && cdm.components.length>0) {
      for(var i=0;i<cdm.components.length;i++) {
        this.setCptDataFormat(cdm.components[i]);
      }
    }
  }

  replaceCustomCellCptId(cpt, html, rowIndex, cellIndex) {
    if(cpt.components) {
      for(let i=0;i<cpt.components.length;i++) {
        let childCpt = cpt.components[i];
        html = html.replace("\""+childCpt.id+"\"", "\""+childCpt.id+"_"+rowIndex+"_"+cellIndex+"\"");
        html = this.replaceCustomCellCptId(childCpt, html, rowIndex, cellIndex);
      }
    }
    return html;
  }

  /**
   * 获得行模板
   * @return {[type]}          [description]
   */
  getRowTemplate() {
    if (!this.columns) return;
    let indent = this.getHtmlIndent();
    let html = "";
    html += indent + `\t\t\t<div class="tfp-grid-datarow"`;
    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";
    rowHeight = rowHeight.replace("px", "");
    html += " style=\"height:" + rowHeight + ";\"";
    html += ">\r\n";

    if (this.dataModel.showCheckbox) {
      html += "\t\t\t\t<div class=\"tfp-grid-datarow-checkbox\" "
        + "style=\"flex-basis:30px;height:" + rowHeight + "px;border-bottom:1px solid " + this.borderColor + ";";
      if (this.showBorder) html += "border-right:1px solid " + this.borderColor + ";";
      html += "\"><input type=\"checkbox\"";
      if (this.dataModel.dataBindingKey) {
        if (this.dataModel.dataBindingKey.indexOf(",") < 0) {
          html += " value=\"{" + this.dataModel.dataBindingKey + "}\"";
        } else {
          let keys = this.dataModel.dataBindingKey.split(",");
          let keyVal = "";
          for (var i = 0; i < keys.length; i++) {
            if (i > 0) keyVal += "_";
            keyVal += "{" + keys[i] + "}";
          }
          html += " value=\"" + keyVal + "\"";
        }
      }
      html += " /></div>";
    }
    //如果显示行号
    if (this.dataModel.showRowNum) {
      html += indent + "\t\t\t\t<div class=\"tfp-grid-datarow-index\" "
        + "style=\"flex-basis:50px;height:" + rowHeight + "px;border-bottom:1px solid " + this.borderColor + ";";
      if (this.showBorder) html += "border-right:1px solid " + this.borderColor + ";";
      html += "\"></div>\r\n";
    }

    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      html += indent + "\t\t\t\t<div";
      html += ` class="tfp-grid-datarow-cell`;
      if (col.class) html += " "+col.class;
      html += "\"";

      let cellFormat = col.format;
      let colStyle = "border-bottom:1px solid " + this.borderColor + ";";
      if (col.contentType == "custom") colStyle += "position:relative;"
      if (col.bgColor) {
        if (col.contentType == "button") {
          //如果按钮设置了专门的按钮背景色，则bgColor就用来设置单元格背景色，否则bgColor用来设置按钮的背景色
          if (col.buttonBgColor) colStyle += "background-color:" + col.bgColor + ";"
        } else {
          colStyle += "background-color:" + col.bgColor + ";"
        }
      }
      let colWidth = this.getColWidth(col, i);
      if (colWidth.indexOf("px") < 0 && colWidth.indexOf("%") < 0) colWidth += "px";
      colStyle += "flex-basis:" + colWidth + ";height:" + rowHeight + "px;";
      if (col.align == "left") {
        colStyle += "justify-content: flex-start;text-align: left;";
      } else if (col.align == "right") {
        colStyle += "justify-content: flex-end;text-align: right;";
      }
      if (col.valign == "top") {
        colStyle += "align-items: flex-start;";
      } else if (col.valign == "bottom") {
        colStyle += "align-items: flex-end;";
      }
      //if (i < (this.columns.length - 1) && this.showBorder)
      //  colStyle += "border-right:1px solid " + this.borderColor + ";";
      if (col.style) colStyle += col.style;

      if (!col.contentType || col.contentType == "text") {
        if (col.color) colStyle += "color:" + col.color + ";"
        if (col.bold) colStyle += "font-weight: bold;"
        if (col.fontSize) colStyle += "font-size: " + col.fontSize + "px;"
        if (col.onClick) colStyle += "cursor: pointer;";
        if (col.nowrap) colStyle += "overflow: hidden;white-space: nowrap;text-overflow: ellipsis;";
        if (colStyle != "") html += " style=\"" + colStyle + "\"";
        if (col.onClick) html += " onclick=\"" + col.onClick + "\"";
        html += ">";
        if (cellFormat && col.dataFormat) {
          if (col.dataFormat == "int") {
            cellFormat = "#[parseInt(" + cellFormat + ")]";
          } else if (col.dataFormat == "decimal") {
            if (col.decimalLength || col.decimalLength == 0) {
              cellFormat = "#[tfp.formatDecimal(" + cellFormat + ", '" + col.decimalCalcReg + "', " + col.decimalLength + ")]";
            } else {
              cellFormat = "#[parseFloat(" + cellFormat + ")]";
            }
          } else if (col.dataFormat == "money|0.00") {
            cellFormat = "#[tfp.formatMoney(" + cellFormat + ", 2)]";
          } else if (col.dataFormat == "money|0,000.00") {
            cellFormat = "#[tfp.formatMoney(" + cellFormat + ", 2, true)]";
          } else if (col.dataFormat.startsWith("date|") || col.dataFormat.startsWith("time|") || col.dataFormat.startsWith("datetime|")) {
            cellFormat = "#[tfp.formatDate('" + cellFormat + "','" + col.dataFormat.substr(col.dataFormat.indexOf("|") + 1) + "')]";
          }
        }
        html += (cellFormat || cellFormat == 0) ? cellFormat : "";
      } else {
        html += " style=\"" + colStyle + "\">\r\n";
        html += indent + "\t\t\t\t";
        if (col.contentType == "link") {
          let linkStyle = "";
          if (col.linkFontColor) linkStyle += "color:" + col.linkFontColor + ";"
          if (col.linkFontBold) linkStyle += "font-weight: bold;"
          if (col.linkFontSize) linkStyle += "font-size: " + col.linkFontSize + "px;"
          if (col.onClick) linkStyle += "cursor: pointer;";
          if (linkStyle != "") linkStyle = " style=\"" + linkStyle + "\"";
          if (col.linkUrl) {
            if (col.linkType == "page") { //新页面
              html += `<a href="javascript:tfp.openPage('${col.targetTitle}', '${col.linkUrl}')" ${linkStyle}>${col.format}</a>`;
            } else if (col.linkType == "dialog") { //对话框
              html += `<a href="javascript:tfp.openDialog('${col.targetTitle}', '${col.linkUrl}', '${col.dialogWidth}px', '${col.dialogHeight}px')" ${linkStyle}>
                ${col.format}
                </a>`;
            } else if (col.linkType == "window") { //新窗口
              html += `<a href="javascript:window.open('${col.linkUrl}', '${col.targetTitle}') " ${linkStyle}>${col.format}</a>`;
            } else {  //当前页面
              html += `<a href="${col.linkUrl}" ${linkStyle}>${col.format}</a>`;
            }
          } else if (col.onClick) {
            html += "<a href=\"javascript:" + col.onClick + "\" " + linkStyle + ">" + col.format + "</a>";
          } else {
            html += "<a " + linkStyle + ">" + col.format + "</a>";
          }
        } else if (col.contentType == "button") {
          html += "<div class=\"tfp-grid-cell-btn\" style=\"";
          let textColor = col.buttonFontColor ? col.buttonFontColor : "#FFFFFF";
          html += "color:" + textColor + ";"
          let bgColor = col.buttonBgColor;
          //如果按钮没有设置专门的按钮背景色，但设置了单元格bgColor，则用这个单元格bgColor设置按钮的背景色
          if (!bgColor && col.bgColor) bgColor = col.bgColor;
          if (!bgColor) bgColor = "#006699";
          html += "background-color:" + bgColor + ";"
          if (col.buttonFontBold) html += "font-weight: bold;"
          if (col.buttonFontSize) html += "font-size: " + col.buttonFontSize + "px;"
          if (col.buttonTheme == "round") {
            html += "border-radius: 4px;";
          } else if (col.buttonTheme == "ellipse") {
            html += "border-radius: 12px;";
          }
          html += "\"";
          html += " onclick=\"" + col.onClick + "\"";
          html += "\">";
          if (cellFormat) html += cellFormat;
          html += "</div>";
        } else if (col.contentType == "image") {
          html += "<img style=\"";
          if (col.onClick) html += "cursor: pointer;";
          if (col.imgWidth) {
            var imgWidth = col.imgWidth;
            if (imgWidth.indexOf("px") < 0 && imgWidth.indexOf("%") < 0) imgWidth += "px";
            html += "width:" + imgWidth + ";";
          }
          if (col.imgHeight) {
            var imgHeight = col.imgHeight;
            if (imgHeight.indexOf("px") < 0 && imgHeight.indexOf("%") < 0) imgHeight += "px";
            html += "height:" + imgHeight + ";";
          }
          let imgSrc = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
          if (cellFormat) imgSrc = cellFormat;
          html += "\" src=\"" + imgSrc + "\"";
          html += " onclick=\"" + col.onClick + "\"";
          html += "/>";
        } else if (col.contentType == "switch") {
          html += "<div class=\"tfp-grid-cell-switch\"";
          html += " onclick=\"" + col.onClick + "\"";
          html += ">";
          let bgColor = "#999999";
          let divFloat = "left";
          if (cellFormat && cellFormat.indexOf("{") == 0 && col.selectedValue) {
            divFloat = "#[('" + cellFormat + "')=='" + col.selectedValue + "' ? 'right' : 'left']";
            let selectedBgColor = "#0099ff";
            //if (col.bgColor) selectedBgColor = col.bgColor;
            bgColor = "#[('" + cellFormat + "')=='" + col.selectedValue + "' ? '" + selectedBgColor + "' : '#999999']";
          }
          html += "<div class=\"tfp-grid-cell-switch-btn\" style=\"float: " + divFloat +
            "; background-color:" + bgColor + ";\"></div></div>";
        } else if (col.contentType == "progress") {
          html += "<div class=\"tfp-grid-cell-progress\">";
          let bgColor = "#0099ff";
          //if (col.bgColor) bgColor = col.bgColor;
          html += "<div class=\"tfp-grid-cell-progress-bar\" style=\"background-color:" + bgColor + ";\"></div></div>";
          html += "<div class=\"tfp-grid-cell-progress-label\"></div>"
        } else if (col.contentType == "custom") {
          //如果不是设计时，则在此直接生成子组件的html
          if(!this._tfp.isDesigning && this.customCells) {
            let cellCdm = null;
            for(let j=0;j<this.customCells.length;j++) {
              let cdm = this.customCells[j];
              if(cdm.cellIndex==i) {
                cellCdm = JSON.parse(JSON.stringify(cdm));
                break;
              }
            }
            if(cellCdm) {
              let cellHtml = this._jqObj.find("#"+cellCdm.id).get(0).outerHTML;
              cellHtml = cellHtml.replace("\""+cellCdm.id+"\"", "\""+this.id+"_cell_"+i+"_"+cellCdm.cellIndex+"\"");
              cellHtml = this.replaceCustomCellCptId(cellCdm, cellHtml, i, cellCdm.cellIndex);
              html += cellHtml;
            }
          }
        }
        html += "\r\n" + indent + "\t\t\t";
      }
      html += "</div>\r\n";
      
      if (i < (this.columns.length - 1) && this.showBorder) {
        html += indent + "\t\t\t\t<div style=\"flex-basis:3px;padding:0;border-bottom:1px solid " 
          + this.borderColor + "; height:" + rowHeight + "px;\"><span style=\"width:1px;margin-left:0;"
          +"background-color:"+this.borderColor+"; height:" + rowHeight + "px;\"></span></div>\r\n";
      }
    }
    //添加一个空列，当所有列宽度之和小于整个组件的宽度时，用该列来填充剩下的空白区域，防止最后一列宽度太宽
    if (!this._tfp.isDesigning) html += "<div class=\"tfp-grid-padding-col\" style=\"height:" 
      + rowHeight + "px;border-bottom:1px solid " + this.borderColor + ";\"></div>";
    html += indent + "\t\t</div>\r\n";
    return html;
  }

  getSumerHtml() {
    if (!this.showSumer) return "";
    let indent = this.getHtmlIndent();
    var html = indent + "\t<div class=\"tfp-grid-sumer\" style=\"height:40px;"
      + "border:1px solid " + this.borderColor + ";bottom:" + (this.allowPaging ? "49px" : "0") + ";\">\r\n";
    if (this.dataModel.showCheckbox) {
      html += indent + "\t\t<div style=\"border-right:1px solid #FFFFFF;flex-basis:30px;\"></div>";
    }
    if (this.dataModel.showRowNum) {
      html += indent + "\t\t<div class=\"tfp-grid-datarow-index\" "
        + "style=\"border-right:1px solid #FFFFFF;flex-basis:50px;\"></div>";
    }
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      html += indent + "\t\t<div class=\"tfp-grid-sumer-cell\"";
      let colWidth = this.getColWidth(col, i);
      let style = "flex-basis:" + colWidth + "px;";
      if (i == 0) {
        style += "font-weight:bold;";
      } else {
        if (col.align != "center") style += "text-align: " + col.align + ";";
      }
      //if (i < (this.columns.length - 1) && this.showBorder) style += "border-right:1px solid #FFFFFF;";
      if (style) html += " style=\"" + style + "\"";
      html += ">";
      if (i == 0) html += "合计";
      html += "</div>\r\n";
      if (i < (this.columns.length - 1) && this.showBorder) {
        html += indent + "\t\t\t\t<div style=\"flex-basis:3px;padding:0;\"></div>\r\n";
      }
    }
    if (!this._tfp.isDesigning) html += indent + "\t\t<div style=\""
      + "flex-grow: 1;flex-shrink: 1; flex-basis:auto;\"></div>";
    html += indent + "\t</div>";
    return html;
  }

  getFooterHtml() {
    if (!this.allowPaging) return "";
    let indent = this.getHtmlIndent();
    let html = indent + "\t\t<div class=\"tfp-grid-footer\" style=\"border:1px solid " + this.borderColor + ";\">\r\n" +
      indent + "\t\t\t<div class=\"tfp-grid-footer-left\">\r\n" +
      indent + "\t\t\t<div class=\"tfp-grid-btn-first\" title=\"首页\">&lt;&lt;</div>"
      + "<div class=\"tfp-grid-btn-prev\" title=\"上一页\">&lt;</div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-next\" title=\"下一页\">&gt;</div>"
      + "<div class=\"tfp-grid-btn-last\" title=\"最后一页\">&gt;&gt;</div>"
      + "<div class=\"tfp-grid-input-topage\">到第 <input type=\"text\" value=\"\"> 页</div>"
      +"</div>\r\n" +
      indent + "\t\t\t<div class=\"tfp-grid-footer-right\">\r\n" +
      indent + "\t\t\t共 <span class=\"tfp-grid-pagecount\">0</span> 页,\r\n" +
      indent + "\t\t\t<span class=\"tfp-grid-rowcount\">0</span> 条记录&nbsp;&nbsp;\r\n";
    html += indent + "\t\t\t<select>\r\n";
    let pageSizeOptions = [20, 30, 50, 100];
    for (var i = 0; i < pageSizeOptions.length; i++) {
      let pageSize = pageSizeOptions[i];
      html += indent + "\t\t\t\t<option value=\"" + pageSize + "\"";
      if (this.pageSize == (pageSize + "")) html += " selected";
      html += ">" + pageSize + "</option>\r\n";
    }
    html += indent + "\t\t\t</select>\r\n";
    html += indent + "\t</div></div>";
    return html;
  }

  hideChildNode(nodeId) {
    let node = this.nodes[nodeId];
    if(!node) return;
    let nodeDiv = this._jqObj.children(".tfp-grid-datalist").children("div[node-id="+node.id+"]");
    nodeDiv.children(".tfp-grid-tree-node-col").children(".tfp-grid-tree-node-icon").attr("src", "/node_modules/tfp/src/components/tree/images/expand-dark.png");
    for(let j=0;j<node.childs.length;j++) {
      this._jqObj.children(".tfp-grid-datalist").children("div[node-id="+node.childs[j]+"]").hide();
      this.hideChildNode(node.childs[j]);
    }
  }

  /**
   * 动态创建自定义单元格的组件
   * @param  {[type]} cdm [description]
   * @return {[type]}     [description]
   */
  createCellCpt(parent, cdm, rowIndex, cellIndex, newCptId) {

    if(!newCptId) cdm.id = cdm.id+"_"+rowIndex+"_"+cellIndex;

    var cptClass = this._tfp.controllers[cdm.type];
    if (!cptClass) {
      console.log("未找到名为[" + cdm.type + "]的组件控制器！");
      return;
    }
    
    var cpt = new cptClass(this._tfp, cdm, parent);
    window[cpt.id] = cpt;
    cpt._jqObj = $("#"+cpt.id);
    cpt.isRendered = true;
    if(cpt._jqObj.length>0) cpt.el = cpt._jqObj[0];

    if(!cdm.components || cdm.components.length==0) return;

    for(var i=0;i<cdm.components.length;i++) {
      this.createCellCpt(cpt, cdm.components[i], rowIndex, cellIndex);
    }
  }

  /**
   * 添加行
   * @param {[type]} rowData [description]
   */
  addRow(rowData, node, nodePrefix) {
    var that = this;
    if (!this.rowTemplate) {
      this.rowTemplate = this.getRowTemplate();
    }
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    let rowIndex = divDataList.children("div").length;
    rowData._rowIndex = rowIndex;
    rowData._rowNum = rowIndex + 1;
    if (this.dataModel.allowPaging) rowData._rowNum = ((this.curPage ? this.curPage : 1) - 1) * this.pageSize + rowIndex + 1;

    if (this.dataModel.onBeforeAddDataRow) {
      try {
        eval(this.dataModel.onBeforeAddDataRow);
      } catch (e) {
        console.log(e);
      }
    }

    var rowHtml = "";
    try {
      rowHtml = this._tfp.replaceDataField(rowData, this.rowTemplate);
      rowHtml = this._tfp.exeExpress(rowHtml);
    } catch (e) {
      console.log(e);
    }
    //console.log(rowHtml);
    let newRow = $(rowHtml);

    if(node) {
      newRow.attr("node-id", node.id);
      newRow.attr("parent-node-id", node.parentId);
      if(!this.dataModel.expandAllNode && !this.rootNodes.contains(node.id)) {
        newRow.css("display", "none");
      }
    }

    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      let celElIndex = i;
      if (this.dataModel.showCheckbox) celElIndex++;
      if (this.dataModel.showRowNum) celElIndex++;
      let cellDiv = newRow.children(".tfp-grid-datarow-cell").eq(i);

      let haveSetBgColor = false;
      
      //根据表头设置列宽，避免因为调整了列宽后重新加载数据导致列宽与表头不一致
      if(this.showHeader) {
        let headerColWidth = this._jqObj.children(".tfp-grid-header").find(".tfp-grid-header-col").eq(i).outerWidth();
        cellDiv.css("flex-basis", headerColWidth+"px");
      }

      //如果设置了内容显示条件，则进行判断
      if (col.displayConditions && col.displayConditions.length > 0) {
        let haveMatch = false;
        for (let j = 0; j < col.displayConditions.length; j++) {
          var condition = col.displayConditions[j];
          var conditionExpress = this._tfp.replaceDataField(rowData, condition.condition);
          var conditionRet = false;

          try {
            conditionRet = eval(conditionExpress);
          } catch (e) {
            console.log(e);
          }
          if (conditionRet) {
            let cellHtml = "";
            if (condition.content) {
              try {
                cellHtml = this._tfp.replaceDataField(rowData, condition.content);
                cellHtml = this._tfp.exeExpress(cellHtml);
              } catch (e) {
                console.log(e);
              }
            }
            if (col.contentType == "button") {
              cellDiv.children("div").html(cellHtml);
              if (condition.fontColor) cellDiv.children("div").css("color", condition.fontColor);
              if (condition.bgColor) {
                cellDiv.children("div").css("background-color", condition.bgColor);
              }
              if (condition.bold) cellDiv.children("div").css("font-weight", "bold");
            } else if (col.contentType == "link") {
              cellDiv.children("a").html(cellHtml);
              if (condition.fontColor) cellDiv.children("a").css("color", condition.fontColor);
              if (condition.bgColor) {
                cellDiv.css("background-color", condition.bgColor);
                haveSetBgColor = true;
              }
              if (condition.bold) cellDiv.children("a").css("font-weight", "bold");
            } else if (col.contentType == "image") {
              cellDiv.children("img").attr("src", cellHtml);
            } else {
              cellDiv.html(cellHtml);
              if (condition.fontColor) cellDiv.css("color", condition.fontColor);
              if (condition.bgColor) {
                cellDiv.css("background-color", condition.bgColor);
                haveSetBgColor = true;
              }
              if (condition.bold) cellDiv.css("font-weight", "bold");
            }
            haveMatch = true;
            break;
          }
        }
        if (!haveMatch && col.notDisplayOnNoCondition) {
          cellDiv.html("");
        }
      } else if (!isNull(col.displayCondition)) {  //TODO  这个参数在最新版的里面已经没有了
        let condition = this._tfp.replaceDataField(rowData, col.displayCondition);
        let conditionRet = false;
        try {
          conditionRet = eval(condition);
        } catch (e) {
          console.log(e);
        }
        if (!conditionRet) cellDiv.html("");
      }
      //如果设置了最大长度
      if (col.maxLength && (!col.contentType || col.contentType == "text")) {
        let content = cellDiv.text();
        if (content.gblen() > col.maxLength) {
          let len = 0;
          for (let k = 0; k < content.length; k++) {
            if (content.charCodeAt(k) > 127 || content.charCodeAt(k) == 94) {
              len += 2;
            } else {
              len++;
            }
            if (len > col.maxLength) {
              let spanC = $("<span style=\"display:none;\">"+content+"</span>");
              cellDiv.html(content.substr(0, k) + "...");
              cellDiv.append(spanC);
              let imgMoreTop = (cellDiv.height()-16)/2;
              cellDiv.css("position", "relative");
              cellDiv.append("<img class=\"tfp-grid-datalist-cell-more\" style=\"top:"+imgMoreTop+"px;\" "
                +"src=\"/node_modules/tfp/src/components/grid/images/toggle-dark.png\" title=\"查看全部内容\" />");
              let imgMore = cellDiv.children(".tfp-grid-datalist-cell-more");
              imgMore.click(function(){
                that.showMoreContent(content, imgMore.offset().left, imgMore.offset().top);
                window.event.stopPropagation();
              });
              imgMore.mouseover(function() {
                window.event.stopPropagation();
              });
              break;
            }
          }
        }
      }
      //如果鼠标经过显示全部内容
      if(col.showMoreOnMouseOver) {
        cellDiv.mouseover(function() {
          if(cellDiv.children("span").length>0) {
            that.showMoreContent(cellDiv.children("span").text());
          } else {
            that.showMoreContent(cellDiv.text());
          }
        });
        cellDiv.mouseout(function() {
          $("#"+that.id+"_more_content").hide();
        });
      }
      //设置进度条
      if (col.contentType == "progress" && col.format) {
        let progress = 0;
        try {
          progress = this._tfp.replaceDataField(rowData, col.format);
          progress = this._tfp.exeExpress(progress);
          progress = parseInt(progress);
          if (progress < 0) progress = 0;
          if (progress > 100) progress = 100;
        } catch (e) {
          console.log(e);
        }
        if (progress > 0) {
          cellDiv.find(".tfp-grid-cell-progress-bar").css("width", progress + "px");
        }
        cellDiv.find(".tfp-grid-cell-progress-label").html(progress + "%");
      }
      //如果设置了onClick事件，但单元格内容为空，则移除onClick事件
      if (col.onClick && cellDiv.html() == "") cellDiv.removeAttr("onClick");

      //如果当前列没有设置背景颜色
      if (col.bgColor || haveSetBgColor) {
        cellDiv.attr("data-set-bg-color", "true");
      }

      //如果有自定义单元格，则需要动态创建单元格及其内部的组件
      if(this.customCells) {
        for(let j=0;j<this.customCells.length;j++) {
          let cell = JSON.parse(JSON.stringify(this.customCells[j]));
          cell.id = this.id+"_cell_"+rowIndex+"_"+cell.cellIndex;
          this.createCellCpt(this, cell, rowIndex, cell.cellIndex, cell.id);
          this._tfp.initCptRuntime(this._tfp.get(cell.id));
        }
      }

      //如果要显示树形
      if (node) {
        //如果当前列是显示树形的列
        if(i == this.dataModel.treeColIndex) {
          var html = cellDiv.html();
          let nodeImage = "<img src=\"/node_modules/tfp/src/components/tree/images/transparent.png\" "
            +"style=\"margin-left:"+(nodePrefix+2)+"px; margin-right:10px;\" />";
          if(node.childs.length > 0) {
            if(this.dataModel.expandAllNode) {
              nodeImage = "<img src=\"/node_modules/tfp/src/components/tree/images/toggle-dark.png\" "
                +"class=\"tfp-grid-tree-node-icon\" style=\""+"margin-left:"+nodePrefix+"px;\" />";
            } else {
              nodeImage = "<img src=\"/node_modules/tfp/src/components/tree/images/expand-dark.png\" "
                +"class=\"tfp-grid-tree-node-icon\" style=\""+"margin-left:"+nodePrefix+"px;\" />";
            }
          }
          cellDiv.html(nodeImage + html);
          cellDiv.addClass("tfp-grid-tree-node-col");
          if(node.childs.length > 0) {
            cellDiv.find("img").click(function() {
              let nodeId = $(this).parent().parent().attr("node-id");
              let nodeTmp = that.nodes[nodeId];
              if($(this).attr("src").indexOf("expand-dark")>0) {
                $(this).attr("src", "/node_modules/tfp/src/components/tree/images/toggle-dark.png");
                for(let j=0;j<nodeTmp.childs.length;j++) {
                  that._jqObj.children(".tfp-grid-datalist").children("div[node-id="+nodeTmp.childs[j]+"]").show();
                }
              } else {
                that.hideChildNode(nodeId);
              }
            });
          }
        }
      }
    }

    divDataList.append(newRow);

    //设置行序号
    if (this.showRowNum) {
      let colRowNum = newRow.children("div").get(0);
      if (this.showCheckbox) colRowNum = newRow.children("div").get(1);
      colRowNum.innerHTML = rowData._rowNum;
    }

    //设置单双行背景颜色
    this.setRowBgColor(rowIndex);

    let curRow = divDataList.children("div").last();

    curRow.mouseover(function () {
      if(!that.disableMouseOverBg) {
        if (that._tfp.curPage.bgColorMode == "dark") {
          $(this).css("background-color", "#444444");
        } else {
          $(this).css("background-color", "#F3F3F3");
        }

        $(this).children("div").each(function () {
          if ($(this).attr("data-set-bg-color")) return;
          if (that._tfp.curPage.bgColorMode == "dark") {
            $(this).css("background-color", "#444444");
          } else {
            $(this).css("background-color", "#F3F3F3");
          }
        });
      }

      if (that.dataModel.onRowMouseOver) {
        try {
          let rowIndex = $(this).index();
          eval(that.dataModel.onRowMouseOver);
        } catch (err) {
          console.log(err.message);
        }
      }
    });

    curRow.mouseout(function () {
      if(!that.disableMouseOverBg) that.setRowBgColor($(this).index(), true);
      if (that.dataModel.onRowMouseOut) {
        try {
          let rowIndex = $(this).index();
          eval(that.dataModel.onRowMouseOut);
        } catch (err) {
          console.log(err.message);
        }
      }
    });

    if (this.dataModel.onCellBindData || this.dataModel.onCellClick || this.dataModel.onCellDblClick) {
      curRow.children(".tfp-grid-datarow-cell").each(function (index) {
        //最后一列填充列不需要附加任何事件处理函数
        if($(this).hasClass("tfp-grid-padding-col")) return;
        let colIndex = index;
        if (that.showCheckbox) colIndex++;
        //如果设置了单元格点击事件
        if (that.dataModel.onCellClick) {
          $(this).click(function () {
            let rowIndex = $(this).closest(".tfp-grid-datarow").index();
            try {
              eval(that.dataModel.onCellClick);
            } catch (err) {
              console.log(err.message);
            }
          });
        }
        //如果设置了单元格双击事件
        if (that.dataModel.onCellDblClick) {
          $(this).dblclick(function () {
            let rowIndex = $(this).closest(".tfp-grid-datarow").index();
            try {
              eval(that.dataModel.onCellDblClick);
            } catch (err) {
              console.log(err.message);
            }
          });
        }
        //如果设置了单元格数据绑定事件
        if (that.dataModel.onCellBindData) {
          try {
            let val = eval(that.dataModel.onCellBindData);
            if (val || val == 0) $(this).html(val);
          } catch (err) {
            console.log(err.message);
          }
        }
      });
    }

    if (this.dataModel.onAfterAddDataRow) {
      try {
        eval(this.dataModel.onAfterAddDataRow);
      } catch (e) {
        console.log(e);
      }
    }
  }

  setRowBgColor(rowIndex, isMouseOut) {
    let curRow = this._jqObj.children(".tfp-grid-datalist").children("div").eq(rowIndex);
    //设置单双行背景颜色
    if (rowIndex % 2 == 1) {
      if (this.dataModel.doubleRowBgColor) {
        curRow.css("background-color", this.dataModel.doubleRowBgColor);
      } else if (this.dataModel.doubleColor) {
        curRow.css("background-color", this.dataModel.doubleColor);
      } else {
        if(isMouseOut) curRow.css("background-color", "#FFFFFF");
      }
    } else {
      if (this.dataModel.singleRowBgColor) {
        curRow.css("background-color", this.dataModel.singleRowBgColor);
      } else if (this.dataModel.singleColor) {
        curRow.css("background-color", this.dataModel.singleColor);
      } else {
        if(isMouseOut) curRow.css("background-color", "#FFFFFF");
      }
    }
    var that = this;
    curRow.children("div").each(function () {
      if ($(this).attr("data-set-bg-color")) return;
      if (rowIndex % 2 == 1) {
        if (that.dataModel.doubleRowBgColor) {
          $(this).css("background-color", that.dataModel.doubleRowBgColor);
        } else if (that.dataModel.doubleColor) {
          $(this).css("background-color", that.dataModel.doubleColor);
        } else {
          if(isMouseOut) $(this).css("background-color", "#FFFFFF");
        }
      } else {
        if (that.dataModel.singleRowBgColor) {
          $(this).css("background-color", that.dataModel.singleRowBgColor);
        } else if (that.dataModel.singleColor) {
          $(this).css("background-color", that.dataModel.singleColor);
        } else {
          if(isMouseOut) $(this).css("background-color", "#FFFFFF");
        }
      }
    });
  }

  /**
   * 获得指定索引的行
   * @param  {[type]} rowIndex [description]
   * @return {[type]}          [description]
   */
  getRow(rowIndex) {
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    return divDataList.children("div").eq(rowIndex);
  }

  /**
   * 获得指定索引行的数据
   * @param  {[type]} rowIndex [description]
   * @return {[type]}          [description]
   */
  getRowData(rowIndex) {
    return this.dataList[rowIndex];
  }

  /**
   * 获得指定单元格
   * @param  {[type]} rowIndex [description]
   * @param  {[type]} colIndex [description]
   * @return {[type]}          [description]
   */
  getCell(rowIndex, colIndex) {
    let row = this.getRow(rowIndex);
    let index = colIndex;
    //if (this.showCheckbox) index++;
    //if (this.showRowNum) index++;
    return row.children(".tfp-grid-datarow-cell").eq(index);
  }

  /**
   * 移除行
   * @param  {[type]} rowIndex [description]
   * @return {[type]}          [description]
   */
  removeRow(rowIndex) {
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    divDataList.children("div").eq(rowIndex).remove();
  }

  /**
   * 删除行数据
   * @param  {[type]} keyValue [description]
   * @return {[type]}          [description]
   */
  deleteRowData(keyValue) {
    if (!this.dataModel.delDataService) {
      this._tfp.showMsg("请设置删除数据的服务！");
      return;
    }
    if (!this.dataModel.dataBindingKey) {
      this._tfp.showMsg("请设置数据主键字段名！");
      return;
    }
    let that = this;
    this._tfp.showConfirm("确定删除？", function (ret) {
      if (ret) {
        let serviceCpt = that._tfp.components[that.dataModel.delDataService];
        let args = {};
        if (that.dataModel.dataBindingKey.indexOf(",") < 0) {
          args[that.dataModel.dataBindingKey] = keyValue;
        } else {
          let dataKeys = that.dataModel.dataBindingKey.split(",");
          for (var i = 0; i < dataKeys.length; i++) {
            if (arguments.length < (i + 2)) break;
            args[dataKeys[i]] = arguments[i + 1];
          }
        }
        serviceCpt.request(args, function (req, res) {
          if (res.code != 0) {
            that._tfp.showMsg(res.message);
            return;
          }
          that.reloadData();
        });
      }
    });
  }

  //该方法将来不再使用，请使用deleteRowData
  deleteRow(keyValue) {
    this.deleteRowData(keyValue);
  }

  order(field, type, img) {
    for(let i=0; i<this.orders.length; i++) {
      let o = this.orders[i];
      if(o.field==field) {
        //如果排序规则没有变化
        if(o.type==type) return;
        o.type = type;
        break;
      }
    }
    let divOrder = $(img).parent();
    if(type=="asc") {
      divOrder.find("img").eq(0).attr("src", this._tfp.rootPath+"/src/components/grid/images/icon-up.png");
      divOrder.find("img").eq(1).attr("src", this._tfp.rootPath+"/src/components/grid/images/icon-down-blue.png");
    } else {
      divOrder.find("img").eq(0).attr("src", this._tfp.rootPath+"/src/components/grid/images/icon-up-blue.png");
      divOrder.find("img").eq(1).attr("src", this._tfp.rootPath+"/src/components/grid/images/icon-down.png");
    }
    this.loadData(1);
  }

  /**
   * 显示单元格的更多内容
   * @param {*} content 
   */
  showMoreContent(content, left, top) {
    let divId = this.id+"_more_content";
    let moreDiv = $("#"+divId);
    let e = window.event;
    if(moreDiv.length==0) {
      $("body").append("<div id=\""+divId+"\" class=\"tfp-grid-more-content\"></div>");
      moreDiv = $("#"+divId);
      moreDiv.mouseover(function() {
        moreDiv.show();
      });
      moreDiv.mouseout(function() {
        moreDiv.html("");
        moreDiv.hide();
      });
    }
    let y = e.clientY;
    if(top) y = top;
    if(y<0) y = 0;
    moreDiv.css("top", y);
    let x = e.clientX;
    if(left) x = left;
    if(x<0) x = 0;
    moreDiv.css("left", x);
    moreDiv.html(content);

    let sw = document.documentElement.clientWidth;
    let sh = document.documentElement.clientHeight;
    let dw = moreDiv.outerWidth();
    let dh = moreDiv.outerHeight();
    if(y+dh>sh) moreDiv.css("top", (sh - dh - 10)+"px");
    if(x+dw>sw) moreDiv.css("left", (sw - dw - 10)+"px");

    moreDiv.show();
  }

  checkAll(cbk) {
    if (cbk.checked) {
      this._jqObj.children(".tfp-grid-datalist").find(".tfp-grid-datarow-checkbox").each(function () {
        if ($(this).find("input").get(0)) {
          $(this).find("input").get(0).checked = true;
        }

      });
    } else {
      this._jqObj.children(".tfp-grid-datalist").find(".tfp-grid-datarow-checkbox").each(function () {
        if ($(this).find("input").get(0)) {
          $(this).find("input").get(0).checked = false;
        }
      });
    }
  }

  /**
   * 获得选中行的主键值
   * @return {[type]} [description]
   */
  getCheckedKeys() {
    let vals = "";
    this._jqObj.children(".tfp-grid-datalist").find(".tfp-grid-datarow-checkbox").each(function () {
      let cbk = $(this).find("input").get(0);
      if (cbk.checked) {
        if (vals != "") vals += ",";
        vals += cbk.value;
      }
    });
    return vals;
  }

  /**
   * 该方法将来不再使用
   * @return {[type]} [description]
   */
  getCheckedValues() {
    return this.getCheckedKeys();
  }

  /**
   * 获得选中的数据
   * @return {[type]} [description]
   */
  getCheckedData() {
    let rows = [];
    let cbks = this._jqObj.children(".tfp-grid-datalist").find(".tfp-grid-datarow-checkbox");
    for (var i = 0; i < cbks.length; i++) {
      let cbk = $(cbks[i]).find("input").get(0);
      if (cbk.checked) {
        rows.push(this.dataList[i]);
      }
    }
    return rows;
  }
  /**
   * 该方法将来不再使用
   * @return {[type]} [description]
   */
  getCheckedRows() {
    return this.getCheckedData();
  }

  getRowsChecked() {
    let rows = [];
    this._jqObj.children(".tfp-grid-datalist").children("div").each(function (index) {
      let cbk = $(this).children(".tfp-grid-datarow-checkbox");
      if (cbk.length > 0 && cbk.get(0).checked) rows.push($(this));
    });
    return rows;
  }

  //设置合计行
  setSumer() {
    if (!this.dataModel.showSumer) return;
    let divSumer = this._jqObj.children(".tfp-grid-sumer");
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      if (col.sum) {
        let colIndex = i;
        //if (this.dataModel.showCheckbox) colIndex++;
        //if (this.dataModel.showRowNum) colIndex++;
        let colDiv = divSumer.children(".tfp-grid-sumer-cell").eq(colIndex);
        if (col.dataFormat == "int") {
          colDiv.html(parseInt(col.sumValue));
        } else if (col.dataFormat == "money|0.00") {
          colDiv.html(this._tfp.formatMoney(col.sumValue, 2));
        } else if (col.dataFormat == "money|0,000.00") {
          colDiv.html(this._tfp.formatMoney(col.sumValue, 2, true));
        } else {
          if (col.decimalLength && (col.decimalLength + "") != "0") {
            colDiv.html(this._tfp.formatDecimal(col.sumValue, col.decimalCalcReg, col.decimalLength));
          } else if ((col.decimalLength + "") == "0") {
            colDiv.html(parseInt(col.sumValue));
          } else {
            colDiv.html(parseFloat(col.sumValue));
          }
        }
      }
    }
  };

  //设置翻页行
  setFooter() {
    if (this.dataModel.showSumer) this.setSumer();
    if (this.dataModel.allowPaging) {
      let footerDiv = this._jqObj.children(".tfp-grid-footer");
      let arr = [];
      let index = parseInt(this.curPage);
      while(index>0 && arr.length<3) {
        arr.unshift(index);
        index--;
      }
      index = parseInt(this.curPage) + 1;
      while(arr.length<5 && index<=this.pageCount) {
        arr.push(index);
        index++;
      }
      for(let i=0;i<arr.length;i++) {
        let btn = footerDiv.find(".tfp-grid-btn-page").eq(i);
        btn.html(arr[i]);
        btn.attr("title", "跳转到第"+arr[i]+"页");
        if(arr[i]==parseInt(this.curPage)) {
          btn.css("background-color", "#0099FF");
          btn.css("color", "#FFFFFF");
        } else {
          btn.css("background-color", "");
          btn.css("color", "");
        }
        btn.show();
      }
      for(let i=arr.length;i<5;i++) {
        let btn = footerDiv.find(".tfp-grid-btn-page").eq(i);
        btn.html("");
        btn.attr("title", "");
        btn.hide();
      }
      footerDiv.find(".tfp-grid-pagecount").text(this.pageCount);
      footerDiv.find(".tfp-grid-rowcount").text(this.rowsCount);
      footerDiv.find(".tfp-grid-input-topage").find("input").val(this.curPage);
    }
  }

  changePageSize(slt) {
    if (!this.dataModel.loadDataService || !this.dataModel.dataBindingMember) return;
    this.pageSize = slt.value;
    this.loadData(this.curPage);
  }

  gotoPage(toPage) {
    this.loadData(toPage);
  }

  addNodeRow(nodeId, prefix) {
    let node = this.nodes[nodeId];
    if(!node) return;
    this.addRow(node.data, node, prefix);
    for(let i=0;i<node.childs.length;i++) {
      this.addNodeRow(node.childs[i], prefix+20);
    }
  }

  /**
   * 绑定数据
   * @param  {[type]} data [description]
   * @return {[type]}      [description]
   */
  bindData(data) {
    if (!data || !Array.isArray(data)) return;
    this.dataList = data;
    this.nodes = {};
    this.rootNodes = [];
    this.nodeIds = [];

    if (this.dataModel.onBeforeBindData) {
      try {
        eval(this.dataModel.onBeforeBindData);
      } catch (err) {
        console.log(err);
      }
    }

    let dataListEl = this._jqObj.children(".tfp-grid-datalist");
    dataListEl.empty();
    if (this.showHeader && this.showCheckbox) {
      let cbk = this._jqObj.children(".tfp-grid-header").find(".tfp-grid-header-checkbox");
      if (cbk.length > 0) cbk.find("input").get(0).checked = false;
    }
    //如果显示合计栏，则需要初始化合计列的值
    if (this.dataModel.showSumer) {
      for (var j = 0; j < this.columns.length; j++) {
        let col = this.columns[j];
        if (col.sum) col.sumValue = 0;
      }
    }

    //生成行模板
    if (!this.rowTemplate) this.rowTemplate = this.getRowTemplate();
    if (Array.isArray(this.dataList)) {
      //如果显示树形
      if (this.dataModel.showTree && this.dataModel.parentNodeIdField
        && (this.dataModel.treeColIndex || this.dataModel.treeColIndex == 0) && this.dataModel.nodeIdField
        && (this.dataModel.rootNodeId || this.dataModel.rootNodeId==0)) {
        //生成树形结构
        for (var i = 0; i < this.dataList.length; i++) {
          let rowData = this.dataList[i];
          let nodeId = rowData[this.dataModel.nodeIdField];
          this.nodes[nodeId] = {
            id: nodeId,
            parentId: rowData[this.dataModel.parentNodeIdField],
            data: rowData,
            childs: []
          };
          this.nodeIds.push(nodeId);
        }
        for (var i = 0; i < this.nodeIds.length; i++) {
          let nodeId = this.nodeIds[i];
          let node = this.nodes[nodeId];
          //如果是一级节点
          if ((node.parentId + "") == (this.dataModel.rootNodeId + "")) {
            this.rootNodes.push(nodeId);
          } else {
            let nodeParent = this.nodes[node.parentId];
            if (nodeParent) nodeParent.childs.push(nodeId);
          }
        }
        for(let i=0;i<this.rootNodes.length;i++) {
          this.addNodeRow(this.rootNodes[i], 10);
        }
      } else {
        for (var i = 0; i < this.dataList.length; i++) {
          this.addRow(this.dataList[i]);
          //如果显示合计栏，则需要计算合计列
          if (this.dataModel.showSumer) {
            for (var j = 0; j < this.columns.length; j++) {
              let col = this.columns[j];
              if (col.sum) {
                let colVal = 0;
                try {
                  colVal = this._tfp.replaceDataField(this.dataList[i], col.format);
                  colVal = this._tfp.exeExpress(colVal);
                  if (isNull(colVal)) continue;
                  if (col.dataFormat == "int") {
                    colVal = parseInt(colVal);
                  } else {
                    colVal = parseFloat(colVal);
                  }
                  col.sumValue += colVal;
                } catch (e) {
                  console.log(e);
                }
              }
            }
          }
        }
      }
    } else {
      this.dataList = [];
    }

    this.setFooter();
    this.onResize();

    if (this.dataModel.onAfterBindData) {
      try {
        eval(this.dataModel.onAfterBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  getRowWidth() {
    let rowWith = 0;
    if (this.dataModel.showCheckbox) rowWith += 30;
    if (this.showBorder) rowWith++;
    if (this.dataModel.showRowNum) rowWith += 50;
    if (this.showBorder) rowWith++;
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      let colWidth = this.getColWidth(col, i);
      if (colWidth.indexOf("%") > 0) {
        this.havePercentWidth = true;
      } else {
        rowWith += parseInt(colWidth.replace("px", "").replace("%", ""));
      }
      if (i < (this.columns.length - 1) && this.showBorder) rowWith += 3;
    }
    return rowWith;
  }

  onResize() {
    let dataListEl = this._jqObj.children(".tfp-grid-datalist");
    let headerEl = this._jqObj.children(".tfp-grid-header");
    let sumerEl = this._jqObj.children(".tfp-grid-sumer");

    if (dataListEl.get(0).scrollHeight > dataListEl.get(0).clientHeight) {
      if (headerEl.length > 0) headerEl.css("overflow-y", "scroll");
      if (sumerEl.length > 0) sumerEl.css("overflow-y", "scroll");
      dataListEl.children("div").last().children("div").css("border-bottom", "0");
    } else {
      if (headerEl.length > 0) headerEl.css("overflow-y", "hidden");
      if (sumerEl.length > 0) sumerEl.css("overflow-y", "hidden");
      dataListEl.children("div").last().children("div").css("border-bottom", "1px solid " + this.borderColor);
    }

    let rowWith = this.getRowWidth();
    if (rowWith > dataListEl.width()) {
      if (headerEl.length > 0) headerEl.css("width", "");
      dataListEl.css("width", "");
      if (sumerEl.length > 0) sumerEl.css("width", "");
    } else {
      if (headerEl.length > 0) headerEl.css("width", "100%");
      dataListEl.css("width", "100%");
      if (sumerEl.length > 0) sumerEl.css("width", "100%");
    }
  }

  loadData(toPage) {
    if (!this.dataModel.loadDataService) {
      //alert("请为["+this.id+"]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataService);
    if (!serviceCpt) {
      alert("ID为[" + this.dataModel.loadDataService + "]的组件不存在！");
      return;
    }
    if (!this.dataModel.dataBindingMember) {
      alert("请为[" + this.id + "]设置数据绑定成员！");
      return;
    }

    var args = {};

    if (this.allowPaging) {
      args = {
        pageSize: this.pageSize,
        toPage: toPage ? toPage : 1
      };
    }

    if(this.orders && this.orders.length>0) {
      let arrOrders = [];
      for(let i=0;i<this.orders.length;i++) {
        let order = this.orders[i];
        if(order.type && order.type!="") arrOrders.push(order);
      }
      args[this.id+"_orderByArgs"] = arrOrders;
    }

    let that = this;
    //与服务组件建立绑定
    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
    serviceCpt.status = 0;

    if (this.dataModel.onBeforeLoadData) {
      try {
        eval(this.dataModel.onBeforeLoadData);
      } catch (err) {
        console.log(err);
      }
    }

    serviceCpt.request(args, function (req, res) {
      if (that.dataModel.onAfterLoadData) {
        try {
          eval(that.dataModel.onAfterLoadData);
        } catch (err) {
          console.log(err);
        }
      }

      var data = res[that.dataModel.dataBindingMember];
      if (!data) return;
      if (that.allowPaging) {
        if (data.rows) {
          that.curPage = data.toPage;
          that.rowsCount = data.rowsCount;
          that.pageCount = data.pageCount;
          that.pageSize = data.pageSize;
          that.bindData(data.rows);
        } else if (Array.isArray(data)) {
          that.curPage = 1;
          that.rowsCount = data.length;
          that.pageCount = 1;
          that.pageSize = data.length;
          that.bindData(data);
        }
      } else {
        if (data.rows) {
          that.bindData(data.rows);
        } else {
          that.bindData(data);
        }
      }
    });
  }

  reloadData() {
    this.loadData(1);
  }

  initDesigning() {
    let divHeader = this._jqObj.children(".tfp-grid-header");
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    let divSumer = this._jqObj.children(".tfp-grid-sumer");

    let gridWidth = this._jqObj.width();
    let dataListWidth = divDataList.children("div").eq(0).width();
    if (dataListWidth < (gridWidth - 2)) {
      if (divHeader.length > 0) divHeader.css("width", "100%");
      divDataList.css("width", "100%");
      if (divSumer.length > 0) divSumer.css("width", "100%");
    }

    if (divSumer.length > 0 && this.allowPaging) {
      divSumer.css("bottom", "49px");
    }

    divDataList.scroll(function () {
      if (divHeader.length > 0) {
        divHeader.get(0).scrollLeft = divDataList.get(0).scrollLeft;
      }
      if (divSumer.length > 0) {
        divSumer.get(0).scrollLeft = divDataList.get(0).scrollLeft;
      }
    });
  }

  initRuntime() {
    let that = this;

    //如果有自定义单元格，运行时需要将单元格数据模型从dataModel.components中转存到另外一个变量中，因为要动态生成多行组件
    if(this.dataModel.components && this.dataModel.components.length>0) {
      this.customCells = JSON.parse(JSON.stringify(this.dataModel.components));
      this.dataModel.components = [];
    }

    document.onmousemove = function() {
      if(that.headerResizeStartX<0) return;
      let x = window.event.clientX;
      let width = that.headerResizeDivWidth + (x - that.headerResizeStartX);
      if(width<20) width = 20;

      let divHeader = that._jqObj.children(".tfp-grid-header");
      let divHeaderCol = divHeader.children(".tfp-grid-header-col").eq(that.headerResizeCellIndex);
      divHeaderCol.css("flex-basis", width + "px");

      
      let colIndex = that.headerResizeCellIndex;
      //if(that.showCheckbox) colIndex++;
      //if(that.showRowNum) colIndex++;

      that._jqObj.children(".tfp-grid-datalist").children(".tfp-grid-datarow").each(function() {
        $(this).children(".tfp-grid-datarow-cell").eq(colIndex).css("flex-basis", width + "px");
      });

      that._jqObj.children(".tfp-grid-sumer").children(".tfp-grid-sumer-cell").eq(colIndex).css("flex-basis", width + "px");
    }

    document.onmouseup = function() {
      if(that.headerResizeStartX<0) return;
      that.headerResizeStartX = -1;
      that.headerResizeCellIndex = -1;
      that.headerResizeDivWidth = 0;
    }

    this.initDesigning();

    for (var i = 0; i < this.dataModel.columns.length; i++) {
      let col = this.dataModel.columns[i];
      if (col.allowOrder && col.orderField) {
        this.orders.push({
          field: col.orderField,
          type: col.orderType
        });
      }
    }

    if (this.allowPaging) {
      let divFooter = this._jqObj.children(".tfp-grid-footer");
      divFooter.find(".tfp-grid-btn-first").click(function () {
        that.gotoPage(1);
      });
      divFooter.find(".tfp-grid-btn-prev").click(function () {
        var prevPage = that.curPage - 1;
        if (prevPage < 1) prevPage = 1;
        that.gotoPage(prevPage);
      });
      divFooter.find(".tfp-grid-btn-next").click(function () {
        var nextPage = that.curPage + 1;
        if (nextPage > that.pageCount) nextPage = that.pageCount;
        that.gotoPage(nextPage);
      });
      divFooter.find(".tfp-grid-btn-last").click(function () {
        that.gotoPage(that.pageCount);
      });
      divFooter.find(".tfp-grid-btn-page").click(function () {
        let toPage = parseInt($(this).html());
        if(toPage==that.curPage) return;
        divFooter.find(".tfp-grid-btn-page").css("background-color", "");
        divFooter.find(".tfp-grid-btn-page").css("color", "");
        $(this).css("background-color", "#0099FF");
        $(this).css("color", "#FFFFFF");
        that.gotoPage(toPage);
      });
      divFooter.find(".tfp-grid-input-topage").find("input").blur(function () {
        let topage = $(this).val();
        if(!tfp.isInt(topage)) {
          $(this).val(that.curPage);
          return;
        }
        that.gotoPage(parseInt(topage));
      });
      divFooter.find("select").change(function () {
        that.changePageSize($(this).get(0));
      });
    }

    $(window).resize(function () {
      that.onResize();
    });

    let toPage = this._tfp.getUrlArg("toPage");
    if (!toPage) toPage = 1;

    that.loadData(toPage);
  }
}