import { VisibleComponent } from "../controller.js";

/**
 * 数据表格组件
 * @param {[type]} dataModel [description]
 */
export default class Grid extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Grid", dataModel, parent);

    this.pageSize = 10;
    this.curPage = 0;
    this.pageCount = 0;
    this.rowsCount = 0;
    this.dataList = [];

    if (__tfp.isDesigning) {
      if (!this.dataModel.components || this.dataModel.components.length == 0) {
        this.dataModel.components = [{
          id: this.id + "_DataRow",
          type: "GridDataRow",
          styles: {
            "height": "100px"
          }
        }];
      }
    }
  }

  //属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get dataBindingKey() { return this.dataModel.dataBindingKey }
  set dataBindingKey(value) { this.dataModel.dataBindingKey = value }

  get allowPaging() { return this.dataModel.allowPaging }
  set allowPaging(value) { this.dataModel.allowPaging = value }

  get containerEl() { 
    return this._jqObj.find(".wx-grid-datalist").get(0);
  }

 
}