import { FormInput } from "../controller.js";

/**
 * 甘特图组件
 * @param {[type]} dataModel [description]
 */
export default class GanttChart extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "GanttChart", dataModel, parent);
  }

  get expandAll() { return this.dataModel.expandAll }
  set expandAll(value) {
    this.dataModel.expandAll = value ? true : false;
  }

  get showNodeAddButton() { return this.dataModel.showNodeAddButton }
  set showNodeAddButton(value) {
    this.dataModel.showNodeAddButton = value ? true : false;
  }

  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get taskDataMember() { return this.dataModel.taskDataMember }
  set taskDataMember(value) { this.dataModel.taskDataMember = value }

  get parentTaskID() { return this.dataModel.parentTaskID }
  set parentTaskID(value) { this.dataModel.parentTaskID = value }

  get taskID() { return this.dataModel.taskID }
  set taskID(value) { this.dataModel.taskID = value }

  get taskStartDate() { return this.dataModel.taskStartDate }
  set taskStartDate(value) { this.dataModel.taskStartDate = value }

  get taskEndDate() { return this.dataModel.taskEndDate }
  set taskEndDate(value) { this.dataModel.taskEndDate = value }

  get taskHead() { return this.dataModel.taskHead }
  set taskHead(value) { this.dataModel.taskHead = value }

  get taskText() { return this.dataModel.taskText }
  set taskText(value) { this.dataModel.taskText = value }

  get taskProgress() { return this.dataModel.taskProgress }
  set taskProgress(value) { this.dataModel.taskProgress = value }

  get taskDuration() { return this.dataModel.taskDuration }
  set taskDuration(value) { this.dataModel.taskDuration = value }

  get taskColor() { return this.dataModel.taskColor }
  set taskColor(value) { this.dataModel.taskColor = value }

  get taskMilestone() { return this.dataModel.taskMilestone }
  set taskMilestone(value) { this.dataModel.taskMilestone = value }

  get taskRollup() { return this.dataModel.taskRollup }
  set taskRollup(value) { this.dataModel.taskRollup = value }

  get lineDataMember() { return this.dataModel.lineDataMember }
  set lineDataMember(value) { this.dataModel.lineDataMember = value }

  get lineId() { return this.dataModel.lineId }
  set lineId(value) { this.dataModel.lineId = value }

  get sourceTaskID() { return this.dataModel.sourceTaskID }
  set sourceTaskID(value) { this.dataModel.sourceTaskID = value }

  get targetTaskID() { return this.dataModel.targetTaskID }
  set targetTaskID(value) { this.dataModel.targetTaskID = value }

  get lineType() { return this.dataModel.lineType }
  set lineType(value) { this.dataModel.lineType = value }

  loadLinkData(resTask, tasks) {
    if (this.dataModel.lineDataMember && resTask[this.dataModel.lineDataMember]) {
      this.bindData(tasks, resTask[this.dataModel.lineDataMember]);
      return;
    }

    if (!this.dataModel.lineDataQuerySetting 
        || !(this.dataModel.lineDataQuerySetting.servicePath || this.dataModel.lineDataQuerySetting.serviceCpt)) {
      this.bindData(tasks, []);
      return;
    }

    let that = this;

    if(this.dataModel.lineDataQuerySetting && this.dataModel.lineDataQuerySetting.servicePath) {
      let options = {
        servicePath: this.dataModel.lineDataQuerySetting.servicePath,
        autoShowError: true,
        showLoading: true 
      };
      if(this.dataModel.lineDataQuerySetting.requestArgs && this.dataModel.lineDataQuerySetting.requestArgs.length>0) {
        options.argSettings = this.dataModel.lineDataQuerySetting.requestArgs;
      }
      if(this.dataModel.lineDataQuerySetting.encryptRequestArgs) options.encryptRequestArgs = this.dataModel.lineDataQuerySetting.encryptRequestArgs;
      if(this.dataModel.lineDataQuerySetting.encryptResponseArgs) options.encryptResponseArgs = this.dataModel.lineDataQuerySetting.encryptResponseArgs;

      this._tfp.request(options, function(req, res) {
        that.bindData(resTask, res[that.dataModel.lineDataQuerySetting.dataMember]);
      });
      return;
    }

    let serviceId = serviceId = this.dataModel.leafNodeDataQuerySetting.serviceCpt;
    let serviceCpt = this._tfp.get(serviceId);
    if (!serviceCpt) {
      this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
      return;
    }

    serviceCpt.status = 0;
    serviceCpt.request(null, function (req, res) {
      that.bindData(resTask, res[that.dataModel.lineDataQuerySetting.dataMember]);
    });
  }

  loadData() {
    if (!this.dataModel.loadDataService && !this.dataModel.taskDataQuerySetting) {
      alert("请为[" + this.id + "]设置加载数据服务！");
      return;
    }
    let taskDataMember = this.dataModel.taskDataMember;
    if(this.dataModel.taskDataQuerySetting && this.dataModel.taskDataQuerySetting.dataMember)
    taskDataMember = this.dataModel.taskDataQuerySetting.dataMember;
    if (!taskDataMember) {
      alert("请为[" + this.id + "]设置任务数据成员！");
      return;
    }

    let that = this;
    
    if (this.dataModel.onBeforeLoadTaskData) {
      try {
        eval(this.dataModel.onBeforeLoadTaskData);
      } catch (err) {
        console.log(err);
      }
    }

    if (this.dataModel.taskDataQuerySetting && this.dataModel.taskDataQuerySetting.servicePath) {
      this._tfp.use("Service", function() {
        let service = that._tfp.new("Service");
        service.path = that.dataModel.taskDataQuerySetting.servicePath;
        if(that.dataModel.taskDataQuerySetting.requestArgs && that.dataModel.taskDataQuerySetting.requestArgs.length>0) {
          service.argSettings = that.dataModel.taskDataQuerySetting.requestArgs;
        }
        if(that.dataModel.taskDataQuerySetting.encryptRequestArgs) service.encryptRequestArgs = that.dataModel.taskDataQuerySetting.encryptRequestArgs;
        if(that.dataModel.taskDataQuerySetting.encryptResponseArgs) service.encryptResponseArgs = that.dataModel.taskDataQuerySetting.encryptResponseArgs;
  
        service.request(null, function(req, res) {
          if (res.code != 0) {
            that._tfp.showMsg(res.message);
            return;
          }
    
          if (that.dataModel.onAfterLoadTaskData) {
            try {
              eval(that.dataModel.onAfterLoadTaskData);
            } catch (err) {
              console.log(err);
            }
          }

          that.loadLinkData(res, res[taskDataMember]);
        });
      });
      return;
    }
    
    let serviceId = this.dataModel.loadDataService;
    if(this.dataModel.taskDataQuerySetting && this.dataModel.taskDataQuerySetting.serviceCpt)
      serviceId = this.dataModel.taskDataQuerySetting.serviceCpt;
    let serviceCpt = this._tfp.components[serviceId];
    if (!serviceCpt) {
      this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
      return;
    }

    //与服务组件建立绑定
    if (!serviceCpt.bindCpts) serviceCpt.bindCpts = [];
    if (!serviceCpt.bindCpts.contains(this.id)) serviceCpt.bindCpts.push(this.id);
    serviceCpt.request(null, function (req, res) {
      that.loadLinkData(res, res[taskDataMember]);
    });
  }

  bindData(data, links) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let parentTaskID = "parent";
        if (this.dataModel.parentTaskID) parentTaskID = this.dataModel.parentTaskID;
        if (parentTaskID.indexOf("{") < 0 && parentTaskID.indexOf("#[") < 0) parentTaskID = "{" + parentTaskID + "}";
        option.parent = this._tfp.replaceDataField(row, parentTaskID);
        if (option.parent) option.parent = this._tfp.exeExpress(option.parent);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskID = "id";
        if (this.dataModel.taskID) taskID = this.dataModel.taskID;
        if (taskID.indexOf("{") < 0 && taskID.indexOf("#[") < 0) taskID = "{" + taskID + "}";
        option.id = this._tfp.replaceDataField(row, taskID);
        if (option.id) option.id = this._tfp.exeExpress(option.id);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskStartDate = "start_date";
        if (this.dataModel.taskStartDate) taskStartDate = this.dataModel.taskStartDate;
        if (taskStartDate.indexOf("{") < 0 && taskStartDate.indexOf("#[") < 0) taskStartDate = "{" + taskStartDate + "}";
        option.start_date = this._tfp.replaceDataField(row, taskStartDate);
        if (option.start_date) option.start_date = this._tfp.exeExpress(option.start_date);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskEndDate = "end_date";
        if (this.dataModel.taskEndDate) taskEndDate = this.dataModel.taskEndDate;
        if (taskEndDate.indexOf("{") < 0 && taskEndDate.indexOf("#[") < 0) taskEndDate = "{" + taskEndDate + "}";
        option.end_date = this._tfp.replaceDataField(row, taskEndDate);
        if (option.end_date) option.end_date = this._tfp.exeExpress(option.end_date);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskHead = "task_head";
        if (this.dataModel.taskHead) taskHead = this.dataModel.taskHead;
        if (taskHead.indexOf("{") < 0 && taskHead.indexOf("#[") < 0) taskHead = "{" + taskHead + "}";
        option.task_head = this._tfp.replaceDataField(row, taskHead);
        if (option.task_head) option.task_head = this._tfp.exeExpress(option.task_head);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskText = "text";
        if (this.dataModel.taskText) taskText = this.dataModel.taskText;
        if (taskText.indexOf("{") < 0 && taskText.indexOf("#[") < 0) taskText = "{" + taskText + "}";
        option.text = this._tfp.replaceDataField(row, taskText);
        if (option.text) option.text = this._tfp.exeExpress(option.text);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskProgress = "progress";
        if (this.dataModel.taskProgress) taskProgress = this.dataModel.taskProgress;
        if (taskProgress.indexOf("{") < 0 && taskProgress.indexOf("#[") < 0) taskProgress = "{" + taskProgress + "}";
        option.progress = this._tfp.replaceDataField(row, taskProgress);
        if (option.progress) option.progress = this._tfp.exeExpress(option.progress);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskDuration = "duration";
        if (this.dataModel.taskDuration) taskDuration = this.dataModel.taskDuration;
        if (taskDuration.indexOf("{") < 0 && taskDuration.indexOf("#[") < 0) taskDuration = "{" + taskDuration + "}";
        option.duration = this._tfp.replaceDataField(row, taskDuration);
        if (option.duration) option.duration = this._tfp.exeExpress(option.duration);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskColor = "color";
        if (this.dataModel.taskColor) taskColor = this.dataModel.taskColor;
        if (taskColor.indexOf("{") < 0 && taskColor.indexOf("#[") < 0) taskColor = "{" + taskColor + "}";
        option.color = this._tfp.replaceDataField(row, taskColor);
        if (option.color) option.color = this._tfp.exeExpress(option.color);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskMilestone = "type";
        if (this.dataModel.taskMilestone) taskMilestone = this.dataModel.taskMilestone;
        if (taskMilestone.indexOf("{") < 0 && taskMilestone.indexOf("#[") < 0) taskMilestone = "{" + taskMilestone + "}";
        option.type = this._tfp.replaceDataField(row, taskMilestone);
        if (option.type) option.type = this._tfp.exeExpress(option.type);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let taskRollup = "rollup";
        if (this.dataModel.taskRollup) taskRollup = this.dataModel.taskRollup;
        if (taskRollup.indexOf("{") < 0 && taskRollup.indexOf("#[") < 0) taskRollup = "{" + taskRollup + "}";
        option.rollup = this._tfp.replaceDataField(row, taskRollup);
        if (option.rollup) option.rollup = this._tfp.exeExpress(option.rollup);
      } catch (e) {
        console.log(e);
        return;
      }
      options.push(option);
    }
    this.bindLinks(links, options);
  }

  bindLinks(links, data) {
    if (isNull(links) || !Array.isArray(links)) return;
    let options = [];
    for (var i = 0; i < links.length; i++) {
      let row = links[i];
      let option = {};
      try {
        let lineId = "id";
        if (this.dataModel.lineId) lineId = this.dataModel.lineId;
        if (lineId.indexOf("{") < 0 && lineId.indexOf("#[") < 0) lineId = "{" + lineId + "}";
        option.id = this._tfp.replaceDataField(row, lineId);
        if (option.id) option.id = this._tfp.exeExpress(option.id);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let sourceTaskID = "source";
        if (this.dataModel.sourceTaskID) sourceTaskID = this.dataModel.sourceTaskID;
        if (sourceTaskID.indexOf("{") < 0 && sourceTaskID.indexOf("#[") < 0) sourceTaskID = "{" + sourceTaskID + "}";
        option.source = this._tfp.replaceDataField(row, sourceTaskID);
        if (option.source) option.source = this._tfp.exeExpress(option.source);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let targetTaskID = "target";
        if (this.dataModel.targetTaskID) targetTaskID = this.dataModel.targetTaskID;
        if (targetTaskID.indexOf("{") < 0 && targetTaskID.indexOf("#[") < 0) targetTaskID = "{" + targetTaskID + "}";
        option.target = this._tfp.replaceDataField(row, targetTaskID);
        if (option.target) option.target = this._tfp.exeExpress(option.target);
      } catch (e) {
        console.log(e);
        return;
      }
      try {
        let lineType = "type";
        if (this.dataModel.lineType) lineType = this.dataModel.lineType;
        if (lineType.indexOf("{") < 0 && lineType.indexOf("#[") < 0) lineType = "{" + lineType + "}";
        option.type = this._tfp.replaceDataField(row, lineType);
        if (option.type) option.type = this._tfp.exeExpress(option.type);
      } catch (e) {
        console.log(e);
        return;
      }
      options.push(option);
    }
    this.tasks = {
      data: data,
      links: options
    }
    this.getGanttChart();
  }

  getGanttChart() {
    let type = "day";
    let that = this;
    gantt.i18n.setLocale("cn");
    gantt.config.xml_date = "%Y-%m-%d %H:%i";
    // 初始化类型
    this.setScaleConfig(type);
    // 展开节点
    if (this.dataModel.expandAll) gantt.config.open_tree_initially = true;
    //关闭所有错误提示信息：gantt有自己的异常消息，如果不关闭可能页面会弹出异常消息
    gantt.config.show_errors = false;
    // //单击节点事件
    // gantt.attachEvent("onTaskClick", function (id, e) {
    //   if (that.dataModel.onClickNode) {
    //     let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNode);
    //     eval(eventFucName + "('" + id + "')");
    //   }
    //   return false;
    // });
    // //双击节点事件
    // gantt.attachEvent("onTaskDblClick", function (id, e) {
    //   if (that.dataModel.onDblClickNode) {
    //     let eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onDblClickNode);
    //     eval(eventFucName + "('" + id + "')");
    //   }
    //   return false;
    // });
    // 点击"+"事件
    gantt.attachEvent("onTaskCreated", function (task) {
      let id = null;
      if (task.parent) id = parseInt(task.parent);
      if (that.dataModel.onClickNodeAddButton) {
        var eventFucName = that._tfp.getCptEventFuncName(that.dataModel.onClickNodeAddButton);

        eval(eventFucName + "('" + id + "')");
      }

      return false;
    });
    // 阻止打开灯箱
    gantt.attachEvent("onBeforeLightbox", function (id) {
      return false;
    });
    // 任务之间创建新链接时
    gantt.attachEvent("onLinkCreated", function (link) {
      let links = link;
      if (that.dataModel.onLinkCreated) {
        try {
          eval(that.dataModel.onLinkCreated);
        } catch (e) {
          console.log(e);
        }
      }
      return true;
    });
    // 拖放任务时
    gantt.attachEvent("onAfterTaskDrag", function (id, mode, e) {
      let task = gantt.getTask(id);
      let links = {
        id: task.id,
        text: task.text,
        start_date: new Date(task.start_date).format("yyyy-MM-dd"),
        end_date: new Date(task.end_date).format("yyyy-MM-dd"),
        duration: task.duration,
        progress: task.progress,
        parent: task.parent,
        color: task.color,
        type: task.type,
        rollup: task.rollup
      };
      if (that.dataModel.onAfterTaskDrag) {
        try {
          eval(that.dataModel.onAfterTaskDrag);
        } catch (e) {
          console.log(e);
        }
      }
      return true;
    });
    // 里程碑文字提示
    gantt.templates.rightside_text = function (start, end, task) {
      if (task.type == "milestone") {
        return task.text;
      }
      return "";
    };
    // 隐藏"+"
    if (!this.dataModel.showNodeAddButton) {
      gantt.config.columns = [
        { name: "text", label: "任务", tree: true, resize: true, width: 180 },
        { name: "start_date", label: "计划开始", align: "center", resize: true, width: 100 },
        { name: "end_date", label: "计划结束", align: "center", resize: true, width: 100 },
        { name: "task_head", label: "任务负责人", align: "center", resize: true, width: 100 },
        { name: "add", label: "", hide: true, width: 30 }
      ];
    } else {
      gantt.config.columns = [
        { name: "text", label: "任务", tree: true, resize: true, width: 180 },
        { name: "start_date", label: "计划开始", align: "center", resize: true, width: 100 },
        { name: "end_date", label: "计划结束", align: "center", resize: true, width: 100 },
        { name: "task_head", label: "任务负责人", align: "center", resize: true, width: 100 },
        { name: "add", label: "", width: 0 }
      ];
    }
    // 设计时只读
    if (this._tfp.isDesigning || this.dataModel.readonly) gantt.config.readonly = true;
    gantt.init("tfp-ganttchart-gantt");
    gantt.clearAll();
    gantt.parse(this.tasks);
  }

  // 动态设置Scale
  setScaleConfig(level) {
    const weekScaleTemplate = function (date) {
      const dateToStr = gantt.date.date_to_str('%M-%d日');
      const weekNum = gantt.date.date_to_str('(%W周)');
      const endDate = gantt.date.add(gantt.date.add(date, 1, 'week'), -1, 'day');
      return dateToStr(date) + '~' + dateToStr(endDate) + '' + weekNum(date);
    };
    switch (level) {
      case 'day':
        gantt.config.scale_height = 28 * 4;
        gantt.config.subscales = [
          {
            unit: 'year',
            step: 1,
            date: '%Y年',
          },
          {
            unit: 'month',
            step: 1,
            date: '%F',
          },
          {
            unit: 'week',
            step: 1,
            template: weekScaleTemplate,
          },
        ];
        gantt.config.scale_unit = 'day';
        gantt.config.date_scale = '周%D,%d日';
        gantt.render();
        break;
      case 'week':
        gantt.config.subscales = [
          {
            unit: 'year',
            step: 1,
            date: '%Y年',
          },
          {
            unit: 'week',
            step: 1,
            template: weekScaleTemplate,
          },
        ];
        gantt.config.scale_height = 28 * 3;
        gantt.config.scale_unit = 'month';
        gantt.config.date_scale = '%F';
        gantt.render();
        break;
      case 'month':
        gantt.config.subscales = [
          {
            unit: 'year',
            step: 1,
            date: '%Y年',
          },
        ];
        gantt.config.scale_unit = 'month';
        gantt.config.date_scale = '%F';
        gantt.config.scale_height = 28 * 2;
        gantt.render();
        break;
      case 'year':
        gantt.config.subscales = [];
        gantt.config.scale_unit = 'year';
        gantt.config.date_scale = '%Y年';
        gantt.config.scale_height = 28 * 2;
        gantt.render();
        break;
    }
  }

  initRuntime() {
    let that = this;
    if (this.dataModel.loadDataService || this.dataModel.taskDataQuerySetting) {
      this.loadData();
    } else {
      this.initDesigning();
    }

    // this._jqObj.find(".tfp-ganttchart-export input").click(function () {
    //   let index = $(this).index();
    //   if (index == 0) {
    //     gantt.exportToPDF({
    //       name: "mygantt.pdf",
    //       locale: "cn",
    //       data: that.tasks
    //     });
    //   } else if (index == 1) {
    //     gantt.exportToPNG({
    //       name: "mygantt.png",
    //       locale: "cn",
    //       data: that.tasks
    //     });
    //   } else if (index == 2) {
    //     gantt.exportToICal({
    //       name: "mygantt.xlsx",
    //       locale: "cn",
    //       data: that.tasks
    //     });
    //   }
    // });

    this._jqObj.find(".tfp-ganttchart-type label").click(function () {
      let index = $(this).index();
      let type = "day";
      if (index == 0) return;
      if (index == 2) {
        type = "week";
      } else if (index == 3) {
        type = "month";
      } else if (index == 4) {
        type = "year";
      }
      that.setScaleConfig(type);
    });
  }

  initDesigning() {
    this.tasks = {
      data: [
        { id: 1, text: "项目 #1", start_date: "2023-07-01", end_date: "2023-07-08", task_head: "负责人 #1", progress: 0.6, open: true, color: "#f56c6c" },
        { id: 2, text: "项目 #2", start_date: "2023-07-01", end_date: "2023-07-09", task_head: "负责人 #2", progress: 1, open: true, color: "#ff9900" },
        { id: 3, text: "项目 #3", start_date: "2023-07-02", end_date: "2023-07-08", task_head: "负责人 #3", progress: 0.5, open: true, color: "#e7ed6c", parent: 1 },
        { id: 4, text: "项目 #4", start_date: "2023-07-01", end_date: "2023-07-07", task_head: "负责人 #4", progress: 1, open: true, color: "#0099ff" }
      ]
    };
    this.getGanttChart();
  }
}