export default {
  "name": "Form",
  "comment": "表单",
  "attrs": [
    {
      "name": "dataQuerySetting",
      "comment": "数据查询设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
      "width": "800px",
      "height": "640px"
    },
    {
      "name": "dataSubmitSetting",
      "comment": "数据提交设置",
      "type": "Dialog",
      "path": "taskbuilder-tfp-designer/DataSubmitSetting.tfp",
      "width": "720px",
      "height": "640px"
    },
    {
      "name": "showSubmitSuccessHint",
      "comment": "显示提交成功提示",
      "type": "Switch"
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "300px"
  },
  "methods": [
    {
      "name": "submit",
      "comment": "提交数据"
    },
    {
      "name": "loadData",
      "comment": "加载数据"
    },
    {
      "name": "bindData",
      "comment": "绑定数据",
      "args": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "disableAllInputs",
      "comment": "禁用所有输入项"
    },
    {
      "name": "enableAllInputs",
      "comment": "启用所有输入项"
    },
    {
      "name": "setAllInputsReadOnly",
      "comment": "设置所有输入项只读"
    },
    {
      "name": "setAllInputsWritable",
      "comment": "设置所有输入项可写"
    }
  ],
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onBeforeLoadData",
      "comment": "加载数据前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "args",
        "type": "Object",
        "comment": "请求参数"
      }]
    }, {
      "name": "onAfterLoadData",
      "comment": "加载数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "req",
        "type": "Object",
        "comment": "请求参数"
      }, {
        "name": "res",
        "type": "Object",
        "comment": "响应参数"
      }]
    }, {
      "name": "onAfterBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定数据"
      }]
    }, {
      "name": "onBeforeSubmit",
      "comment": "提交前",
      "isNotHtmlEvent": true
    }, {
      "name": "onAfterSubmit",
      "comment": "提交后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "req",
        "comment": "请求",
        "type": "Object"
      },{
        "name": "res",
        "comment": "响应",
        "type": "Object"
      }]
    }
  ]
}