import { ContainerComponent } from "../controller.js";

/**
 * 表单组件
 * @param {[type]} dataModel [description]
 */
export default class Form extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Form", dataModel, parent);
    this._data = null;
  }

  //loadDataService属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  //dataBindingMember属性
  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  //submitService属性
  get submitService() { return this.dataModel.submitService }
  set submitService(value) { this.dataModel.submitService = value }

  //是否显示提交成功提示
  get showSubmitSuccessHint() { return this.dataModel.showSubmitSuccessHint ? true : false }
  set showSubmitSuccessHint(value) { this.dataModel.showSubmitSuccessHint = value ? true : false }

  /**
   * 批量设置输入项属性
   * @param {*} components 
   * @param {*} attrName 
   * @param {*} attrVal 
   */
  batchSetIptAttr(components, attrName, attrVal) {
    if(components) {
      components.forEach(cdm => {
        let cpt = this._tfp.get(cdm.id);
        if(cpt.isFormInput) {
          cpt[attrName] = attrVal;
        }
        if(cdm.components) this.batchSetIptAttr(cdm.components, attrName, attrVal);
      });
    }
  }
  
  /**
   * 禁用所有输入项
   */
  disableAllInputs() {
    this.batchSetIptAttr(this.dataModel.components, "disabled", true);
  }
  
  /**
   * 启用所有输入项
   */
  enableAllInputs() {
    this.batchSetIptAttr(this.dataModel.components, "disabled", false);
  }

  /**
   * 设置所有输入项只读
   */
  setAllInputsReadOnly() {
    this.batchSetIptAttr(this.dataModel.components, "readonly", true);
  }
  
  /**
   * 设置所有输入项可写
   */
  setAllInputsWritable() {
    this.batchSetIptAttr(this.dataModel.components, "readonly", false);
  }

  /**
   * 设置所有输入项必填
   */
  setAllInputsRequired() {
    this.batchSetIptAttr(this.dataModel.components, "required", true);
  }

  /**
   * 取消所有输入项必填
   */
  cancelAllInputsRequired() {
    this.batchSetIptAttr(this.dataModel.components, "required", false);
  }

  /**
   * 校验表单输入项的数据是否符合要求
   * @param  {[type]} ipt  [description]
   * @param  {[type]} args [description]
   * @return {[type]}      [description]
   */
  checkInputData(cdm, args) {
    let cpt = this._tfp.get(cdm.id);
    let cptTypeInfo = this._tfp.type(cpt.type);
    if (cpt.isFormInput) {
      if (cpt.required && (
        isNull(cpt.value) || (cpt.value + "").trim() == ""
        || (Array.isArray(cpt.value) && cpt.value.length == 0))) {
        if (cpt.comment) {
          this._tfp.showMsg(cpt.comment + "不能为空！", function() {
            if (cpt.focus) cpt.focus();
          });
        } else {
          this._tfp.showMsg(cpt.id + "不能为空！", function() {
            if (cpt.focus) cpt.focus();
          });
        }
        return false;
      }

      if (!isNull(cpt.value) && cpt.dataModel.verify && typeof cpt.dataModel.verify == 'object'
        && cpt.dataModel.verify.verify && cpt.dataModel.verify.verifyMsg) {
        var reg = new RegExp(cpt.dataModel.verify.verify);
        if (!reg.test(cpt.value.toString())) {
          this._tfp.showMsg(cpt.dataModel.verify.verifyMsg, function() {
            if (cpt.focus) cpt.focus();
          });
          return false;
        }
      }

      if(!isNull(cpt.value) && cpt.type=="Text" && cpt.dataModel.subDataType) {
        if (cpt.focus) cpt.focus();
        if(!this._tfp.runVerify(cpt)) return false;
      }

      if (!isNull(cpt.value)) {
        args[cpt.id] = cpt.value;
        /*if(ipt.type=="DateTime" && ipt.value.length<19) {
          args[ipt.id] = ipt.value + ":00";
        } else if(ipt.type=="Date" && ipt.value.length<19) {
          args[ipt.id] = ipt.value + " 0:00:00";
        }*/
      }
      //如果该组件的数据需要加密发送
      if(cpt.dataModel.encrypted && this.dataModel.dataSubmitSetting) {
        if(!this.dataModel.dataSubmitSetting.encryptRequestArgs) this.dataModel.dataSubmitSetting.encryptRequestArgs = "";
        let encArgs = this.dataModel.dataSubmitSetting.encryptRequestArgs.split(',');
        if(!encArgs.contains(cpt.id)) encArgs.push(cpt.id);
        this.dataModel.dataSubmitSetting.encryptRequestArgs = encArgs.join(",");
      }
    } else if (cpt.type == "DataSet") {
      let rows = cpt.getRowsData({ checkRequired: true });
      if (!rows) return false;
      args[cpt.id] = rows;
    }
    let isOK = true;
    if (cdm.components) {
      for (var i = 0; i < cdm.components.length; i++) {
        isOK = this.checkInputData(cdm.components[i], args);
        if (!isOK) return false;
      }
    }
    return isOK;
  }

  submit() {
    if (!this.dataModel.submitService && 
      !(this.dataModel.dataSubmitSetting 
        && (this.dataModel.dataSubmitSetting.serviceCpt || this.dataModel.dataSubmitSetting.servicePath))) {
      this._tfp.showMsg("请为[" + this.id + "]设置数据提交有关参数！");
      return;
    }

    if(this.dataModel.onBeforeSubmit) {
      let ret = eval(this.dataModel.onBeforeSubmit);
      if(!ret) return;
    }

    //对表单内的输入项的数据进行校验，并生成请求参数
    let args = {};
    let isOK = true;
    if (this.dataModel.components) {
      for (var i = 0; i < this.dataModel.components.length; i++) {
        isOK = this.checkInputData(this.dataModel.components[i], args);
        if (!isOK) return;
      }
    }

    let that = this;

    if(this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.servicePath) {
      let options = {
        servicePath: this.dataModel.dataSubmitSetting.servicePath,
        autoShowError: true,
        showLoading: true,
        //encryptRequestArgs,
        args: args
      };
      if(that.dataModel.dataSubmitSetting.requestArgs && that.dataModel.dataSubmitSetting.requestArgs.length>0) {
        options.argSettings = that.dataModel.dataSubmitSetting.requestArgs;
      }
      if(that.dataModel.dataSubmitSetting.encryptRequestArgs) options.encryptRequestArgs = that.dataModel.dataSubmitSetting.encryptRequestArgs;
      if(that.dataModel.dataSubmitSetting.encryptResponseArgs) options.encryptResponseArgs = that.dataModel.dataSubmitSetting.encryptResponseArgs;
      
      this._tfp.request(options, function(req, res) {
        if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
        that.exeEventHandler("onAfterSubmit", req, res);
      });
      return;
    }

    let serviceId = this.dataModel.submitService;
    if(this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.serviceCpt) {
      serviceId = this.dataModel.dataSubmitSetting.serviceCpt;
    }
    let serviceCpt = this._tfp.get(serviceId);
    if (!serviceCpt) {
      this._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
      return;
    }
    serviceCpt.request(args, function (req, res) {
      if (that.dataModel.showSubmitSuccessHint) that._tfp.showMsg("提交成功！");
      that.exeEventHandler("onAfterSubmit", req, res);
      /*if(that._tfp.curPage.pagetype=="dialog") {
        onDialogOK({req: req, res: res});
        closeCurDialog();
      }*/
    });
  }

  bindData(data) {
    if (!this.dataModel.components || !data) return;
    let formData = data;
    //如果绑定数据是数组，则取数组的第一个元素作为绑定数据对象
    if (Array.isArray(formData)) {
      if (formData.length == 0) return;
      formData = data[0];
    }
    this._data = formData;
    for (var i = 0; i < this.dataModel.components.length; i++) {
      this._tfp.bindCptData(this.dataModel.components[i], formData);
    }
    this.exeEventHandler("onAfterBindData");
  }

  onLoadData(req, res) {
    var data = res;
    //如果设置了数据绑定成员名称，则从服务响应对象中取这个成员对象作为表单的数据源
    //否则，将整个响应对象作为表单的数据源
    if (this.dataModel.dataBindingMember) {
      data = res[this.dataModel.dataBindingMember];
    } else if(this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      data = res[this.dataModel.dataQuerySetting.dataMember];
    }
    //如果是翻页的数据
    if (data.rows && data.pageCount) data = data.rows;
    //如果是数组
    if(Array.isArray(data)) data = data[0];
    //把表单的数据先缓存起来，以便后续某些场景需要继续使用
    this.dataModel.data = data;
    this.bindData(data);
  }

  initRuntime() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataService //某些老版本的组件使用的该属性，需要兼容
      || (this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    }
  }
}