export default {
  "name": "FlexPanel",
  "comment": "弹性面板",
  "attrs": [
    {
      "name": "direction",
      "comment": "元素排列方向",
      "type": "Select",
      "options": [
        {
          "value": "row",
          "text": "从左到右显示"
        },
        {
          "value": "row-reverse",
          "text": "从右到左显示"
        },
        {
          "value": "column",
          "text": "从上到下显示"
        },
        {
          "value": "column-reverse",
          "text": "从下到上显示"
        }
      ]
    },
    {
      "name": "wrap",
      "comment": "元素自动换行",
      "type": "Switch"
    },
    {
      "name": "align",
      "comment": "主轴对齐方式",
      "type": "Select",
      "options": [
        {
          "value": "flex-start",
          "text": "起点对齐"
        },
        {
          "value": "flex-end",
          "text": "终点对齐"
        },
        {
          "value": "center",
          "text": "居中对齐"
        },
        {
          "value": "space-between",
          "text": "两端对齐"
        },
        {
          "value": "space-around",
          "text": "等距对齐"
        }
      ]
    },
    {
      "name": "valign",
      "comment": "交叉轴对齐方式",
      "type": "Select",
      "options": [
        {
          "value": "flex-start",
          "text": "起点对齐"
        },
        {
          "value": "flex-end",
          "text": "终点对齐"
        },
        {
          "value": "center",
          "text": "居中对齐"
        },
        {
          "value": "baseline",
          "text": "基线对齐"
        },
        {
          "value": "stretch",
          "text": "自动伸展"
        }
      ]
    },
    {
      "name": "alignContent",
      "comment": "内容整体对齐方式",
      "type": "Select",
      "options": [
        {
          "value": "stretch",
          "text": "自动拉伸"
        },
        {
          "value": "flex-start",
          "text": "在容器的顶部排列"
        },
        {
          "value": "flex-end",
          "text": "在容器的底部排列"
        },
        {
          "value": "center",
          "text": "在容器内居中排列"
        },
        {
          "value": "space-between",
          "text": "均匀分布，上下靠边"
        },
        {
          "value": "space-around",
          "text": "均匀分布，每行等距"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "display": "flex",
    "flex-direction": "row",
    "justify-content": "flex-start",
    "align-items": "center",
    "width": "100%",
    "height": "120px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onMouseOver",
      "comment": "鼠标经过时"
    }, {
      "name": "onMouseOut",
      "comment": "鼠标移出时"
    }]
}