import {ContainerComponent} from "../controller.js";

/**
 * 弹性面板组件
 * @param {[type]} dataModel [description]
 */
export default class FlexPanel extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "FlexPanel", dataModel, parent);
  }

  get containerEl() { return this.el }

  get direction() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-direction": "row"
      };
    }
    return this.dataModel.styles["flex-direction"];
  }
  set direction(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-direction": "row"
      };
    }
    this.dataModel.styles["flex-direction"] = value;
    if(this._jqObj) this._jqObj.css("flex-direction", value);
  }

  get wrap() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-wrap": "nowrap"
      };
    }
    return this.dataModel.styles["flex-wrap"];
  }
  set wrap(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "flex-wrap": "nowrap"
      };
    }
    this.dataModel.styles["flex-wrap"] = value ? "wrap" : "nowrap";
    if(this._jqObj) this._jqObj.css("flex-wrap", value);
  }

  get align() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "justify-content": "flex-start"
      };
    }
    return this.dataModel.styles["justify-content"];
  }
  set align(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "justify-content": "flex-start"
      };
    }
    this.dataModel.styles["justify-content"] = value;
    if(this._jqObj) this._jqObj.css("justify-content", value);
  }

  get valign() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "align-items": "stretch"
      };
    }
    return this.dataModel.styles["align-items"];
  }
  set valign(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "align-items": "stretch"
      };
    }
    this.dataModel.styles["align-items"] = value;
    if(this._jqObj) this._jqObj.css("align-items", value);
  }

  get alignContent() { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "align-content": "stretch"
      };
    }
    return this.dataModel.styles["align-content"];
  }
  set alignContent(value) { 
    if(!this.dataModel.styles) {
      this.dataModel.styles = {
        "align-content": "stretch"
      };
    }
    this.dataModel.styles["align-content"] = value;
    if(this._jqObj) this._jqObj.css("align-content", value);
  }

  show() {
    if(this._jqObj) this._jqObj.css("display", "flex");
  }
}