import TFPComponentRender from '../render.js'

export default class FlexBoxRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    if (getComponentsHtml) {
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent, retainStyleAttr);
    }
    return bodyHtml + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    cpt_wx.wxml = "\r\n";
    let indent = this.getHtmlIndent();
    if (getComponentsHtml) {
      var coms_wx = this.getComponentsWX(getComponentsHtml, indent, retainStyleAttr, otherOptions);
      cpt_wx.wxml += coms_wx.wxml;
      cpt_wx.wxjs += coms_wx.wxjs;
    }
    cpt_wx.wxml += indent;

    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", getComponentsHtml, parentIndent, retainStyleAttr, otherOptions);
  }
}