import TFPComponentRender from '../render.js'

export default class FileUploadRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    html += indent;
    html += `\r\n<div class="wx-panel fileupload-uploadbox wx-fileupload-outbox" style="display:` + (this.dataModel.allowUpload ? 'none' : 'flex') + `;">
      <div class="wx-fileupload-uploadbox">
        <view>上传文件</view>
      </div>
    </div>`;
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `  <view class="wx-fileupload-outbox">
        <view wx:for="{{`+ vid + `_uploadfileList}}" wx:for-item="items" wx:key="id" class="wx-fileupload-list">
          <view class="wx-fileupload-onebox">
            <view class="wx-fileupload-imagebox">
              <view class="wx-fileupload-file">
              </view>
            </view>`;
    if (!this.dataModel.allowDelete) {
      bodyHtml += ` <view bindtap="bindclick_openFile" data-type="file" data-index="{{index}}" data-array="` + vid + `_uploadfileList" class="wx-fileupload-namebox">
              {{items.name}}
            </view>
            <view bindtap="bindclick_delFile" data-type="file" data-index="{{index}}" data-array="`+ vid + `_uploadfileList" class="wx-fileupload-delbox">
              删除
            </view>`;
    } else {
      bodyHtml += ` <view bindtap="bindclick_openFile" data-type="file" data-index="{{index}}" data-array="` + vid + `_uploadfileList" class="wx-fileupload-namebox2">
              {{items.name}}
            </view>`;
    }
    bodyHtml += `
          </view>
        </view>
        <view class="wx-fileupload-uploadbox" wx-if="{{`+ !this.dataModel.allowUpload + `}}">
          <view bindtap="bindclick_uploadFile" data-type="file" data-array="`+ vid + `_uploadfileList" data-number="` + this.dataModel.size + `" data-appCode="`+this.dataModel.appCode+`">
            上传文件
          </view>
        </view>
      </view>\r`;
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}