import TFPComponentRender from '../render.js'

export default class FileUploadRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let btnText = '上传文件';
    if (this.dataModel.btnText) btnText = this.dataModel.btnText;
    let imgUrl = "";
    if (this._tfp.isDesigning) {
      imgUrl = "../tfp/src/components/fileupload/images/icon.png";
      html += indent + "\t<div class=\"tfp-button tfp-button-primary tfp-button-rect\" style=\"line-height:30px;\">"
        + "<img src=\"" + imgUrl + "\" style=\"width:16px; height:16px; margin-right:7px;\">" + btnText + "</div>\r\n";
    } else {
      imgUrl = "/node_modules/tfp/src/components/fileupload/images/icon.png";
      if (this.dataModel.allowUpload) {
        html += indent + "\t<div class=\"tfp-fileupload-row\" style=\"height:40px;width:100%;\">\r\n"
          + indent + "\t\t<div class=\"tfp-button tfp-button-primary tfp-button-rect\" style=\"line-height:30px;\">"
          + "<img src=\"" + imgUrl + "\" style=\"width:16px; height:16px; margin-right:7px;\">" + btnText + "</div>\r\n"
          + "</div>\r\n";
      }
      if (this.cpt.files) {
        for (var i = 0; i < this.cpt.files.length; i++) {
          let fileInfo = this.cpt.files[i];
          html += indent + "\t<div class=\"tfp-fileupload-row\">"
            + indent + "\t\t<p class=\"tfp-fileupload-fileinfo\">"
            + "<img src=\"/node_modules/tfp/src/components/fileupload/images/attach.png\" align=\"absmiddle\" />&nbsp;&nbsp;"
            + "<a href=\"/Download?fileCode=" + fileInfo.code + "\">" + fileInfo.name + "</a>"
            + indent + "\t\t</p>\r\n"
            + indent + "\t</div>\r\n";
        }
      }
    }
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}