export default {
  "name": "FileUpload",
  "comment": "文件上传",
  "attrs": [
    {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    },
    {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    },
    {
      "name": "fileType",
      "comment": "文件类型",
      "type": "String"
    },
    {
      "name": "appCode",
      "comment": "应用代码",
      "type": "String"
    },
    {
      "name": "appDataId",
      "comment": "应用数据ID",
      "type": "String"
    },
    {
      "name": "enIde",
      "comment": "启用身份验证",
      "type": "Switch"
    },
    {
      "name": "size",
      "comment": "文件总数",
      "type": "Number",
      "default": 10
    },
    {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    },
    {
      "name": "allowUpload",
      "comment": "隐藏上传",
      "type": "Switch",
      "default": false
    },
    {
      "name": "allowDelete",
      "comment": "隐藏删除",
      "type": "Switch",
      "default": false
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "overflow": "auto",
    "background": "white",
    "min-height":'57px'
  },
  "events": [{
    "name": "bindtap",
    "args": [{ 'name': 'e' }],
    "eventArgs": "",
    "comment": "点击时"
  }, {
    "name": "bindchange",
    "args": [{ 'name': 'e' }],
    "eventArgs": "",
    "comment": "值发生变化时"
  }, {
    "name": "onBeforeUpload",
    "comment": "上传前",
    "isNotHtmlEvent": true
  }, {
    "name": "onAfterUpload",
    "comment": "上传后",
    "isNotHtmlEvent": true
  }]
}