import { FormInput } from "../controller.js";

/**
 * 文件上传组件
 * @param {[type]} dataModel [description]
 */
export default class FileUpload extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "FileUpload", dataModel, parent);
    }
  }

  //应用代码
  get appCode() { return this.dataModel.appCode }
  set appCode(value) { this.dataModel.appCode = value }

  //应用数据ID
  get appDataId() { return this.dataModel.appDataId }
  set appDataId(value) { this.dataModel.appDataId = value }

  //是否验证身份
  get enIde() { return this.dataModel.enIde }
  set enIde(value) { this.dataModel.enIde = value }

  //文件类型
  get fileType() { return this.dataModel.fileType }
  set fileType(value) { this.dataModel.fileType = value }

  //文件总数
  get size() { return this.dataModel.size }
  set size(value) { this.dataModel.size = value }

  //隐藏上传
  get allowUpload() { return this.dataModel.allowUpload }
  set allowUpload(value) {
    this.dataModel.allowUpload = value
    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".fileupload-uploadbox").css("display", 'none');
      } else {
        this._jqObj.find(".fileupload-uploadbox").css("display", 'flex');
      }
    }
  }

  //隐藏删除
  get allowDelete() { return this.dataModel.allowDelete }
  set allowDelete(value) {
    this.dataModel.allowDelete = value
    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".fileupload-delbox").css("display", 'none');
      } else {
        this._jqObj.find(".fileupload-delbox").css("display", 'flex');
      }
    }
  }
  
  initRuntime() {
    let that = this;
  }
}