import { FormInput } from "../controller.js";

/**
 * 文件组组件
 * @param {[type]} dataModel [description]
 */
export default class FileList extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "FileList", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return [];
    return this.dataModel.value;
  }
  set value(value) {
    if (!value) {
      this.dataModel.value = [];
    } else {
      this._jqObj.find(".tfp-filelist-box").children(".tfp-filelist-row").remove();
      if (this.dataModel.appCode && this.dataModel.appDataId) {
        if (!Array.isArray(value)) return;
        this.dataModel.value = value;
        this.setAppHtml(value);
      } else {
        if (value.indexOf(",") >= 0) {
          this.dataModel.value = value.split(',');
          this.setHtml(value.split(','), 0);
        } else {
          this.dataModel.value = [value];
          this.setHtml([value], 0);
        }
      }

      if (!this._tfp.isDesigning) {
        this.exeEventHandler("onChange");
      }
    }
  }


  get appCode() { return this.dataModel.appCode }
  set appCode(value) {
    this.dataModel.appCode = value;
  }

  get appDataId() { return this.dataModel.appDataId }
  set appDataId(value) {
    this.dataModel.appDataId = value;
  }

  get transverse() { return this.dataModel.transverse }
  set transverse(value) {
    this.dataModel.transverse = value ? true : false;
  }

  get showStyle() { return this.dataModel.showStyle }
  set showStyle(value) {
    this.dataModel.showStyle = value;
  }

  setHtml(data, index) {
    let that = this;

    if (data && data.length > index) {
      this.onAfterBindData({
        fileCode: data[index]
      }, function (fileInfo) {
        that.addHtml(fileInfo);
        index++;
        that.setHtml(data, index);
      });
    } else {
      return;
    }
  }

  setAppHtml(value) {
    for (var i = 0; i < value.length; i++) {
      this.addHtml(value[i]);
    }
  }

  addHtml(fileInfo) {
    let html = '';
    let that = this;
    let filesDiv = that._jqObj.find(".tfp-filelist-box");
    let src = that._tfp.getUrlRealPath(fileInfo.code);
    html += "<div class=\"tfp-filelist-row\"><p class=\"tfp-filelist-fileinfo";
    if (this.dataModel.showStyle == "bigIconMode") html += " tfp-filelist-row-p";
    html += "\">";

    if (this.dataModel.showStyle == "bigIconMode") {
      html += "<img style=\"width:40px;\" src=\"" + this.getBigIcon(fileInfo.name) + "\" align=\"absmiddle\" />";
    } else {
      html += "<img src=\"/node_modules/tfp/src/components/fileupload/images/attach.png\" align=\"absmiddle\" />&nbsp;&nbsp;";
    }
    html += "<a href=\"/Download?fileCode=" + src + "\"";
    if (this.dataModel.showStyle == "bigIconMode") html += " title=\"" + fileInfo.name + "\"  class=\"tfp-filelist-row-a\"";
    html += ">" + fileInfo.name + "</a>";
    html += "</p></div>";
    filesDiv.append(html);
  }

  getBigIcon(filename) {
    let suffix = filename.toLowerCase().split('.').pop();
    suffix += '';
    if (suffix != 'avi' && suffix != 'doc' && suffix != 'docx' && suffix != 'eps' && suffix != 'xls' && suffix != 'xlsx' && suffix != 'exe' && suffix != 'gif' && suffix != 'mp3' && suffix != 'pdf' && suffix != 'ppt' && suffix != 'pptx' && suffix != 'psd' && suffix != 'sql' && suffix != 'swf' && suffix != 'zip')
      suffix = 'default';
    return "/node_modules/tfp/src/components/fileupload/images/" + suffix + ".png";
  }

  onAfterBindData(data, cb) {
    let args = {};
    if (data && data.fileCode) {
      args.file_code = data.fileCode;
    } else if (this.dataModel.appCode && this.dataModel.appDataId) {
      args.app_code = this.dataModel.appCode;
      args.app_data_id = this.dataModel.appDataId;
    }
    //应用代码和应用数据id都设置了才能自动查询附件信息
    if (!(args.file_code || (args.app_code && args.app_data_id))) return;

    let that = this;
    this._tfp.use("Service", function () {
      var service = that._tfp["new"]("Service");
      service.path = "sys/service/app_attach/getUploadCptVal.tbs";
      service.request(args, function (req, res) {
        if (!res.data) return;
        if (cb) cb(res.data[0]);
        else that.value = res.data;
      });
    });
  }
}


