import ExcelExport from "../excelexport/controller.pc.js";

/**
 * Excel导入组件
 * @param {[type]} dataModel [description]
 */
export default class ExcelImport extends ExcelExport {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "ExcelImport");
  }

  get template() { return this.dataModel.template }
  set template(value) {
    this.dataModel.template = value;
  }

  initRuntime() {
    var that = this;
    this._jqObj.click(function () {
      if (!that.dataModel.service && !that.dataModel.dataImportSetting) {
        that._tfp.showMsg("请为[" + that.id + "]设置数据导入有关参数！");
        return;
      }

      let args = {};
      if(that.dataModel.template) args._templatePath = that.dataModel.template;
      let servicePath = "";
      let encryptRequestArgs = "";
      let encryptResponseArgs = "";
      if (that.dataModel.dataImportSetting) {
        if (that.dataModel.dataImportSetting.servicePath) {
          if (that.dataModel.dataImportSetting.requestArgs
            && that.dataModel.dataImportSetting.requestArgs.length > 0) {
            that._tfp.getRequestArgs(args, that.dataModel.dataImportSetting.requestArgs);
          }
          servicePath = that.dataModel.dataImportSetting.servicePath;
          encryptRequestArgs = that.dataModel.dataImportSetting.encryptRequestArgs;
          encryptResponseArgs = that.dataModel.dataImportSetting.encryptResponseArgs;
        } else if(that.dataModel.dataImportSetting.serviceCpt) {
          let serviceCpt = that._tfp.get(that.dataModel.dataImportSetting.serviceCpt);
          if (!serviceCpt) {
            that._tfp.showMsg("没有找到id为[" + that.dataModel.dataImportSetting.serviceCpt + "]的组件！");
            return;
          }
          servicePath = serviceCpt.dataModel.path;
          encryptRequestArgs = serviceCpt.dataModel.encryptRequestArgs;
          encryptResponseArgs = serviceCpt.dataModel.encryptResponseArgs;
          if (serviceCpt.dataModel.argSettings && serviceCpt.dataModel.argSettings.length > 0)
            that._tfp.getRequestArgs(args, serviceCpt.dataModel.argSettings);
        }
      } else if (that.dataModel.service) {
        servicePath = that.dataModel.service;
        encryptRequestArgs = that.dataModel.encryptRequestArgs;
        encryptResponseArgs = that.dataModel.encryptResponseArgs;
      }
      
      if (!servicePath) {
        that._tfp.showMsg("请为[" + that.id + "]设置数据导入有关参数！");
        return;
      }

      let url = "/node_modules/tfp/src/components/excelimport/tfp/importExcel.tfp?servicePath=" + servicePath;
      if (that.dataModel.onImport) url += "&cb=" + that._tfp.getCptEventFuncName(that.dataModel.onImport);
      that._tfp.openDialog("导入Excel数据", url, "480px", "350px", { args: args }, window);
    });
  }
}