import TFPComponentRender from '../render.js'

export default class ExcelExportRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getSpecialClass() {
    let classHtml = " tfp-button";
    classHtml += " tfp-button-primary tfp-button-" + (this.dataModel.theme ? this.dataModel.theme : "rect");
    return classHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let imgUrl = "";
    if (this._tfp.isDesigning) {
      imgUrl = "../tfp/src/components/"+this.dataModel.type.toLowerCase()+"/images/icon.png";
    } else {
      imgUrl = "/node_modules/tfp/src/components/"+this.dataModel.type.toLowerCase()+"/images/icon.png";
    }
    return "<img src=\""+imgUrl+"\" style=\"width:16px; height:16px; margin-right:7px;\">"+this.dataModel.text;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}