import { VisibleComponent } from "../controller.js";

/**
 * Excel导出组件
 * @param {[type]} dataModel [description]
 */
export default class ExcelExport extends VisibleComponent {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "ExcelExport", dataModel, parent);
    }
  }

  //属性
  get text() { return this.dataModel.text }
  set text(value) {
    this.dataModel.text = value;
    if (this._jqObj) {
      this._jqObj.html(value);
    }
  }

  get theme() { return this.dataModel.theme }
  set theme(value) {
    let theme = "rect";
    if (value) theme = value;
    if (!this.checkAttrOption("theme", theme)) {
      this._tfp.showMsg("不支持风格：" + theme + "！");
      return;
    }
    this.dataModel.theme = theme;
    if (this._jqObj) {
      this._jqObj.removeClass("tfp-button-round tfp-button-rect tfp-button-circle");
      this._jqObj.addClass("tfp-button-" + theme);
    }
  }

  get service() { return this.dataModel.service }
  set service(value) { this.dataModel.service = value }

  get allowFilterFields() { return this.dataModel.allowFilterFields }
  set allowFilterFields(value) {
    this.dataModel.allowFilterFields = value ? true : false;
  }

  //是否验证身份
  get enIde() { return this.dataModel.enIde }
  set enIde(value) { this.dataModel.enIde = value }

  onExport(res) {
    if (res.code != 0) {
      this._tfp.showMsg(res.message);
      return;
    }
    $('.exportlink').remove();
    $('body').append('<a class="exportlink" style="display:none;" href="javascript:"></a>');
    var that = this;
    $('.exportlink').click(function () {
      let url = "/Download?fileCode=" + res.fileCode;
      window.location.href = that._tfp.setUrlAuthData(url);
    });
    $('.exportlink').click();
  }

  initRuntime() {
    var that = this;
    this._jqObj.click(function () {
      if (that.dataModel.allowFilterFields) {
        that._tfp.openDialog("选择导出字段", that._tfp.rootPath + "/src/components/excelexport/exportPicker.tfp?checkedFields=" + JSON.stringify(that.dataModel.dataExportSetting.fields), "540px", "260px", null, function (ret) {
          that.callingMethod(ret);
        });
      } else {
        that.callingMethod();
      }
    });
  }

  callingMethod(ret) {
    let that = this;

    if (!that.dataModel.service && !that.dataModel.dataExportSetting) {
      that._tfp.showMsg("请为[" + that.id + "]设置数据导出有关参数！");
      return;
    }

    if (that.dataModel.service || (that.dataModel.dataExportSetting && that.dataModel.dataExportSetting.serviceCpt)) {
      let serviceCptId = that.dataModel.service;  //兼容老版本组件
      if (!serviceCptId) serviceCptId = that.dataModel.dataExportSetting.serviceCpt;
      let serviceCpt = that._tfp.components[serviceCptId];
      if (!serviceCpt) {
        that._tfp.showMsg("没有找到id为[" + serviceCptId + "]的组件！");
        return;
      }
      let args = {};
      if (ret && ret.length > 0) args.checkedFields = ret;
      if (that.enIde) args.enIde = 1;
      serviceCpt.request(args, function (req, res) {
        that.onExport(res);
      });
      return;
    }

    if (that.dataModel.dataExportSetting && that.dataModel.dataExportSetting.servicePath) {
      let options = {
        servicePath: that.dataModel.dataExportSetting.servicePath,
        autoShowError: true,
        showLoading: true
      };
      if (that.dataModel.dataExportSetting.requestArgs && that.dataModel.dataExportSetting.requestArgs.length > 0) {
        options.argSettings = that.dataModel.dataExportSetting.requestArgs;
      } else options.argSettings = [];
      if (that.dataModel.dataExportSetting.encryptRequestArgs) options.encryptRequestArgs = that.dataModel.dataExportSetting.encryptRequestArgs;
      if (that.dataModel.dataExportSetting.encryptResponseArgs) options.encryptResponseArgs = that.dataModel.dataExportSetting.encryptResponseArgs;
      if (ret && ret.length > 0) options.checkedFields = ret;
      if (that.enIde) options.argSettings.push({name: 'enIde', type: 'Default', value: '1', encrypt: 'false'});
      that._tfp.request(options, function (req, res) {
        that.onExport(res);
      });
    } else {
      that._tfp.showMsg("请为[" + that.id + "]设置数据导出有关参数！");
    }
  }
}

