export default {
  "name": "EncodingRule",
  "comment": "编码规则",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "ruleCode",
          "comment": "规则代码",
          "type": "Dialog",
          "inputType": "text",
          "title": "编码规则列表",
          "path": "taskbuilder-proj-manager/encodingRuleList.tfp",
          "width": "720px",
          "height": "480px"
        },
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "placeHolder",
          "comment": "输入提示",
          "type": "String",
          "isHtmlAttr": true
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "default": true,
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "encrypted",
          "comment": "加密发送",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "methods": [
    {
      "name": "loadCode",
      "comment": "加载规则代码"
    }
  ],
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时",
      "isNotHtmlEvent": true
    }, {
      "name": "onDblClick",
      "comment": "双击时",
      "isNotHtmlEvent": true
    }, {
      "name": "onFocus",
      "comment": "获得焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onBlur",
      "comment": "失去焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onKeyDown",
      "comment": "按下按键时",
      "isNotHtmlEvent": true
    }, {
      "name": "onKeyPress",
      "comment": "按下并松开按键时",
      "isNotHtmlEvent": true
    }, {
      "name": "onKeyUp",
      "comment": "松开按键时",
      "isNotHtmlEvent": true
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}