import Text from "../text/controller.js";

/**
 * 编码规则
 * @param {[type]} dataModel [description]
 */
export default class EncodingRule extends Text {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "EncodingRule");
  }

  get ruleCode() { return this.dataModel.ruleCode }
  set ruleCode(value) { this.dataModel.ruleCode = value }

  loadCode(cb) {
    //需要设置规则代码
    if (!this.dataModel.ruleCode) {
      console.log("请设置规则代码！");
      return;
    }
    let that = this;
    this._tfp.use("Service", function () {
      let service = that._tfp.new("Service");
      service.path = "sys/service/encoding_rule/getCurCode.tbs";
      service.request({
        rule_code: that.dataModel.ruleCode,
        update_mode: 'R'
      }, function (req, res) {
        that.value = res.data.code;
        if(cb) cb();
      });
    });
  }

  initRuntime() {

    super.initRuntime();

    //如果设置了数据绑定格式，则不需要再从后台查询
    if(this.dataModel.dataBindingFormat) return;

    this.loadCode();
  }
}