import TFPComponentRender from '../render.js'

export default class DropdownBoxRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let bodyHtml = "\r\n" + indent + "\t<div class=\"dropdownbox_top\"><input class=\"selectThis\" type=\"text\" readonly />\r\n";
    bodyHtml += indent + "\t<span class=\"icon dtreefont dtree-icon-xiangxia\"></span></div>\r\n";
    let dataListDivWidth = 200;
    if (this.dataModel.dataListDivWidth) dataListDivWidth = this.dataModel.dataListDivWidth;
    let dataListDivHeight = 240;
    if (this.dataModel.dataListDivHeight) dataListDivHeight = this.dataModel.dataListDivHeight;
    bodyHtml += "<div class=\"tfp-dropdownbox-datalist\" style=\"width:" + dataListDivWidth + "px; height:" + dataListDivHeight + "px;\">";
    bodyHtml += "<div class=\"selectInputBox\"><input class=\"selectInput\"type=\"text\"/></div>";
    bodyHtml += "<div id=\"" + this.dataModel.id + "_DropdownBoxDiv\"></div>";
    bodyHtml += "<div id=\"" + this.dataModel.id + "_SelectDropDownBoxDiv\"></div>";
    bodyHtml += " </div> ";
    return bodyHtml + "\t";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}