import { FormInput } from "../controller.js";

/**
 * 下拉树列表组件
 * @param {[type]} dataModel [description]
 */
export default class DropdownBox extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "DropdownBox", dataModel, parent);

    this.nodes = [];
    this.selectNodes = {};
    this.rootNodes = [];
    this.iconPath = this._tfp.rootPath + "/src/components/dropdownbox/images/";
    this.iconColor = this._tfp.curPage.contentColorMode;
    this.clickCheckboxs = [];
  }

  // 默认值
  get value() {
    return this.escapeValue(this.dataModel.storageType, this.dataModel.value);
  }
  set value(value) {
    var that = this;
    this.dataModel.value = this.escapeValue(this.dataModel.storageType, value);
    console.log('赋值')
    // 默认值赋值
    if (that.dataModel.value) {
      that.clickCheckboxs = JSON.parse(that.escapeValue('json', that.dataModel.value));
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }
  //属性
  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value
  }
  //属性
  get storageType() { return this.dataModel.storageType }
  set storageType(value) { this.dataModel.storageType = value }
  //属性
  get nodeDataMember() { return this.dataModel.nodeDataMember }
  set nodeDataMember(value) { this.dataModel.nodeDataMember = value }
  //属性
  get rootNodeParentId() { return this.dataModel.rootNodeParentId }
  set rootNodeParentId(value) { this.dataModel.rootNodeParentId = value }
  //属性
  get nodeIdFieldName() { return this.dataModel.nodeIdFieldName }
  set nodeIdFieldName(value) { this.dataModel.nodeIdFieldName = value }
  //属性
  get nodeNameFieldName() { return this.dataModel.nodeNameFieldName }
  set nodeNameFieldName(value) { this.dataModel.nodeNameFieldName = value }
  //属性
  get nodeParentIdFieldName() { return this.dataModel.nodeParentIdFieldName }
  set nodeParentIdFieldName(value) { this.dataModel.nodeParentIdFieldName = value }
  //属性
  get nodechildrenNum() { return this.dataModel.nodechildrenNum }
  set nodechildrenNum(value) { this.dataModel.nodechildrenNum = value }
  // 展开级数
  get spreadLevel() { return this.dataModel.spreadLevel }
  set spreadLevel(value) {
    if (isNull(value)) {
      value = 1;
    }
    this.dataModel.spreadLevel = value
  }
  //叶节点判断字段
  get isLeaf() { return this.dataModel.isLeaf }
  set isLeaf(value) { this.dataModel.isLeaf = value }

  // 弹出列表宽度
  get dataListDivWidth() { return this.dataModel.dataListDivWidth }
  set dataListDivWidth(value) { this.dataModel.dataListDivWidth = value }
  // 弹出列表高度
  get dataListDivHeight() { return this.dataModel.dataListDivHeight }
  set dataListDivHeight(value) { this.dataModel.dataListDivHeight = value }

  // 显示节点选择框
  get showNodeCheckbox() { return this.dataModel.showNodeCheckbox }
  set showNodeCheckbox(value) {
    this.dataModel.showNodeCheckbox = value ? true : false
  }
  // 允许多选
  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) { this.dataModel.multiCheck = value ? true : false; }
  // 加载单级列表
  get loadList() { return this.dataModel.loadList }
  set loadList(value) { this.dataModel.loadList = value ? true : false; }

  // 启用搜索
  get enableFilter() { return this.dataModel.enableFilter }
  set enableFilter(value) { this.dataModel.enableFilter = value }
  // 搜索节点数据服务
  get selectDataListService() { return this.dataModel.selectDataListService }
  set selectDataListService(value) { this.dataModel.selectDataListService = value }
  // 输入项搜索字段
  get inputSelectinfo() { return this.dataModel.inputSelectinfo }
  set inputSelectinfo(value) { this.dataModel.inputSelectinfo = value }
  // 节点数据成员
  get nodeDataMember2() { return this.dataModel.nodeDataMember2 }
  set nodeDataMember2(value) { this.dataModel.nodeDataMember2 = value }
  // 节点ID字段
  get nodeIdFieldName2() { return this.dataModel.nodeIdFieldName2 }
  set nodeIdFieldName2(value) { this.dataModel.nodeIdFieldName2 = value }
  // 节点名称字段
  get nodeNameFieldName2() { return this.dataModel.nodeNameFieldName2 }
  set nodeNameFieldName2(value) { this.dataModel.nodeNameFieldName2 = value }
  // 父节点ID字段
  get nodeParentIdFieldName2() { return this.dataModel.nodeParentIdFieldName2 }
  set nodeParentIdFieldName2(value) { this.dataModel.nodeParentIdFieldName2 = value }

  clear() {
    this.nodes = {};
    this.selectNodes = {};
    this.rootNodes = [];
    if (this._jqObj) {
      this._jqObj.find("#" + this.dataModel.id + "_DropdownBoxDiv").empty();
      this._jqObj.find("#" + this.dataModel.id + "_SelectDropDownBoxDiv").empty();
    }
  }

  /**
   * // value转  string/json
   * @param {*} value 
   * @returns 
   */
  escapeValue(type, value) {
    var that = this;
    if (isNull(value)) {
      value = '';
    } else {
      if (value.indexOf("#") > 0) {
        // 后台返回字符串
        if (type == 'json') {
          var idList = value.split('#')[0].split(',');
          var nameList = value.split('#')[1].split(',');
          value = [];
          for (var x = 0; x < idList.length; x++) {
            value.push({
              id: idList[x],
              name: nameList[x]
            })
          }
          value = JSON.stringify(value)
        }
      } else {
        // 后台返回JSON字符串
        if (type == 'string') {
          if (typeof value == 'string') {
            value = JSON.parse(value);
          }
          var idList = [];
          var nameList = [];
          for (var x = 0; x < value.length; x++) {
            idList.push(value[x].id);
            nameList.push(value[x].name);
          }
          value = idList.join(",") + "#" + nameList.join(",");
        }
      }
    }
    return value;
  }

  bindData(data) {
    console.log('生成页面')
    if (!data) {
      this._tfp.showMsg("请提供要绑定的数据！");
      return;
    }
    if (!this.dataModel.nodeDataMember) {
      this._tfp.showMsg("请为组件[" + this.id + "]设置[nodeDataMember]参数！");
      return;
    }
    let nodesData = data[this.dataModel.nodeDataMember];
    if (!nodesData) {
      this._tfp.showMsg("服务响应结果中没有名为[" + this.dataModel.nodeDataMember + "]的参数！");
      return;
    }
    var nodeIdArr = [];
    var that = this;
    // 树形
    if (!that.dataModel.loadList) {
      // 单选
      if (!that.dataModel.multiCheck) {
        if (that.clickCheckboxs.length > 0) {
          that._jqObj.find(".selectThis").val(that.clickCheckboxs[0].name);
          that.selectNodes[that.clickCheckboxs[0].id] = {
            id: that.clickCheckboxs[0].id,
            name: that.clickCheckboxs[0].name,
            isSelect: true
          }
        }
      } else {
        // 多选
        var iptValList = [];
        for (var x = 0; x < that.clickCheckboxs.length; x++) {
          iptValList.push(that.clickCheckboxs[x].name);
          that.selectNodes[that.clickCheckboxs[x].id] = {
            id: that.clickCheckboxs[x].id,
            name: that.clickCheckboxs[x].name,
            isSelect: true
          };
        }
        that._jqObj.find(".selectThis").val(iptValList.join(','))
      }
    }

    // 普通列表
    if (this.dataModel.loadList) {
      //将服务器端返回数据转换为节点对象
      if (nodesData instanceof Array) {
        for (var i = 0; i < nodesData.length; i++) {
          var nodeData = nodesData[i];
          var node = {};
          node.id = nodeData[this.dataModel.nodeIdFieldName];
          node.name = nodeData[this.dataModel.nodeNameFieldName];
          node.data = nodeData;
          // 是否已选中
          node.isSelect = false;
          this.nodes[node.id] = node;
          var divDataList = this._jqObj.find("#" + this.id + "_DropdownBoxDiv");
          this.createNodeList(divDataList, node, 5);
        }
      } else {
        that._tfp.showMsg("服务返回数据格式错误！");
        return;
      }
      return
    }
    //将服务器端返回数据转换为节点对象
    if (nodesData instanceof Array) {
      for (var i = 0; i < nodesData.length; i++) {
        var nodeData = nodesData[i];
        var node = {};
        node.id = nodeData[this.dataModel.nodeIdFieldName];
        node.name = nodeData[this.dataModel.nodeNameFieldName];
        node.parentId = nodeData[this.dataModel.nodeParentIdFieldName];
        node.data = nodeData;
        node.childNodes = [];
        // 是否已选中
        node.isSelect = this.selectNodes[node.id] ? this.selectNodes[node.id].isSelect : false;
        // 是否已点击过
        node.isClicked = false;
        // 是否已展开
        node.isOpen = false;
        // 子节点数量字段
        if (this.dataModel.nodechildrenNum) node.child_num = nodeData[this.dataModel.nodechildrenNum];
        // 是否为叶节点
        if (this.dataModel.isLeaf) node.isLeaf = nodeData[this.dataModel.isLeaf];
        this.nodes[node.id] = node;
        nodeIdArr.push(node.id);
      }
    } else {
      that._tfp.showMsg("服务返回数据格式错误！");
      return;
    }
    //生成节点之间的关系
    for (var i = 0; i < nodeIdArr.length; i++) {
      var nodeId = nodeIdArr[i];
      var node = this.nodes[nodeId];
      if (node.parentId == this.dataModel.rootNodeParentId) {
        // 节点等级
        this.nodes[nodeId].level = 1;
        if (this.dataModel.spreadLevel > 1) {
          // 是否已点击过
          node.isClicked = true;
          // 是否已展开
          node.isOpen = true;
        }
        this.rootNodes.push(nodeId);
      } else {
        var parentNode = this.nodes[node.parentId];
        if (parentNode) {
          this.nodes[nodeId].level = parentNode.level + 1;
          if (this.dataModel.spreadLevel < parentNode.level + 1) {
            continue;
          }
          if (this.dataModel.spreadLevel > parentNode.level + 1) {
            // 是否已点击过
            node.isClicked = true;
            // 是否已展开
            node.isOpen = true;
          }
          parentNode.childNodes.push(nodeId);
        }
      }
    }
    // 循环放入树
    for (var i = 0; i < this.rootNodes.length; i++) {
      var node = this.nodes[this.rootNodes[i]];
      if (!node.parentId) node.parentId = this.dataModel.rootNodeParentId;
      var divDataList = this._jqObj.find("#" + this.id + "_DropdownBoxDiv");
      this.createNode(divDataList, node, 5);
    }
    /*if(this.dataModel.onLoaded) {
      eval(this.dataModel.onLoaded+"(req, res)");
    }*/
  }

  loadData() {
    if (!this.dataModel.loadDataListService) {
      this._tfp.showMsg("请为[" + this.id + "]设置加载数据服务！");
      return;
    }
    let serviceCpt = this._tfp.get(this.dataModel.loadDataListService);
    if (!serviceCpt) {
      this._tfp.showMsg("ID为[" + this.dataModel.loadDataListService + "]的组件不存在！");
      return;
    }
    let that = this;
    serviceCpt.status = 0;
    serviceCpt.request(null, function (req, res) {
      that.bindData(res);
    });
  }

  reloadData() {
    this.loadData();
  }

  getNodeTextDivWidth(marginLeft) {
    //动态计算每个节点内文本框的最大宽度，以便文字过长时能自动出现省略号
    var divWidth = this._jqObj.get(0).offsetWidth;
    var nodeTextWidth = divWidth - marginLeft - 16 - 22;
    if (this.dataModel.showNodeCheckbox) nodeTextWidth -= 25;
    if (this.dataModel.showNodeDeleteButton) nodeTextWidth -= 21;
    if (this.dataModel.showNodeEditButton) nodeTextWidth -= 21;
    return nodeTextWidth;
  }

  /**
   * 创建节点
   * @param  {[type]} parentDiv  [description]
   * @param  {[type]} node       [description]
   * @param  {[type]} marginLeft [description]
   */
  createNode(parentDiv, node, marginLeft) {
    let that = this;
    var haveChild = false;
    if (node.childNodes.length > 0) haveChild = true;
    if (node.isLeaf) haveChild = false;
    var iconName = 'jia';
    // 是否已展开  或   无子节点  或 已点击过
    if (node.isOpen || (!that.haveChild(node.id) && node.isClicked)) {
      iconName = `jian`;
    }
    // 是否为叶节点
    if (node.isLeaf) {
      iconName = `normal-file`;
    }
    var nodeHtml = ``;
    nodeHtml += `
      <div class="tfp-dropdownbox-node" nodeid="`+ node.id + `">
        <div class="tfp-dropdownbox-node-icon" style="margin-left: `+ marginLeft + `px;">
          <span class="icon dtreefont dtree-icon-`+ iconName + `"></span>
        </div>`;
    // 显示节点选择框
    if (that.dataModel.showNodeCheckbox) {
      let cbkType = that.dataModel.multiCheck ? "checkbox" : "radio";
      let ischecked = '';
      let selectIcon = '';
      // 复选
      if (that.dataModel.multiCheck) {
        selectIcon = 'fuxuankuang';
      } else {
        selectIcon = 'circle1';
      }
      // 已选中
      if (node.isSelect) {
        ischecked = 'checked';
        // 复选
        if (that.dataModel.multiCheck) {
          selectIcon = 'fuxuankuangxuanzhong';
        } else {
          selectIcon = 'roundcheckfill';
        }
      }
      nodeHtml += `   
      <div class="tfp-dropdownbox-node-checkbox">
        <input type="`+ cbkType + `" value="` + node.id + `" ` + (cbkType == 'radio' ? `name="` + that.id + `"` : ``) + ` ` + ischecked + ` >
        <div class="icon dtreefont dtree-icon-`+ selectIcon + `" iconid="` + node.id + `">
        </div>
      </div>`;
    }
    nodeHtml += ` 
        <div class="tfp-dropdownbox-node-text" style="width:`+ that.getNodeTextDivWidth(marginLeft) + `px;">
          `+ node.name + `
        </div>
      </div>`;
    parentDiv.append(nodeHtml);

    let nodeDivNew = parentDiv.children(".tfp-dropdownbox-node").last();
    // 点击文字
    nodeDivNew.find(".tfp-dropdownbox-node-text").click(function () {
      that._jqObj.find(".tfp-dropdownbox-node").removeClass("tfp-dropdownbox-node-selected");
      $(this).closest(".tfp-dropdownbox-node").addClass("tfp-dropdownbox-node-selected");
      // 不显示节点选择框
      if (!that.dataModel.showNodeCheckbox) {
        that.noneInputSelect(node.id);
      }
      that.setChildrenNode(node.id, function () {
        that.nodes[node.id].isClicked = true;
        that.toggleNode(node.id);
      })
    });

    // 点击展开图标
    nodeDivNew.find(".tfp-dropdownbox-node-icon").click(function () {
      that.setChildrenNode(node.id, function () {
        that.nodes[node.id].isClicked = true;
        that.toggleNode(node.id);
      })
    });

    // 点击选择框图标
    nodeDivNew.find(".tfp-dropdownbox-node-checkbox").click(function () {
      that.checkNode(node.id);
    });

    var childDisplay = node.isOpen ? "" : "display:none";
    var childNodesDiv = $("<div class=\"tfp-dropdownbox-node-childs\" "
      + "nodeId=\"" + node.id + "\" style=\"" + childDisplay + "\"></div>");
    parentDiv.append(childNodesDiv);
    if (haveChild) {
      for (var i = 0; i < node.childNodes.length; i++) {
        var childNode = that.nodes[node.childNodes[i]];
        //如果子节点没有设置父节点编号属性，则在此设置一下
        //目前在选择部门和人员时需要这么做
        if (!childNode.parentId) childNode.parentId = node.id;
        that.createNode(childNodesDiv, childNode, marginLeft + 20);
      }
    }
  }

  /**
   * 创建列表节点
   * @param  {[type]} parentDiv  [description]
   * @param  {[type]} node       [description]
   * @param  {[type]} marginLeft [description]
   */
  createNodeList(parentDiv, node, marginLeft) {
    let that = this;
    var iconName = `normal-file`;
    var nodeHtml = ``;
    nodeHtml += `
      <div class="tfp-dropdownbox-node" nodeid="`+ node.id + `">
        <div class="tfp-dropdownbox-node-icon" style="margin-left: `+ marginLeft + `px;">
          <span class="icon dtreefont dtree-icon-`+ iconName + `"></span>
        </div>`;
    // 显示节点选择框
    if (that.dataModel.showNodeCheckbox) {
      let cbkType = that.dataModel.multiCheck ? "checkbox" : "radio";
      let ischecked = '';
      let selectIcon = '';
      // 复选
      if (that.dataModel.multiCheck) {
        selectIcon = 'fuxuankuang';
      } else {
        selectIcon = 'circle1';
      }
      // 已选中
      if (node.isSelect) {
        ischecked = 'checked';
        // 复选
        if (that.dataModel.multiCheck) {
          selectIcon = 'fuxuankuangxuanzhong';
        } else {
          selectIcon = 'roundcheckfill';
        }
      }
      nodeHtml += `   
      <div class="tfp-dropdownbox-node-checkbox">
        <input type="`+ cbkType + `" value="` + node.id + `" ` + (cbkType == 'radio' ? `name="` + that.id + `"` : ``) + ` ` + ischecked + ` >
        <div class="icon dtreefont dtree-icon-`+ selectIcon + `" iconid="` + node.id + `">
        </div>
      </div>`;
    }
    nodeHtml += ` 
        <div class="tfp-dropdownbox-node-text" style="width:`+ marginLeft + `px;">
          `+ node.name + `
        </div>
      </div>`;
    parentDiv.append(nodeHtml);

    let nodeDivNew = parentDiv.children(".tfp-dropdownbox-node").last();
    // 点击文字
    nodeDivNew.find(".tfp-dropdownbox-node-text").click(function () {
      that._jqObj.find(".tfp-dropdownbox-node").removeClass("tfp-dropdownbox-node-selected");
      $(this).closest(".tfp-dropdownbox-node").addClass("tfp-dropdownbox-node-selected");
      // 不显示节点选择框
      if (!that.dataModel.showNodeCheckbox) {
        that.noneInputSelectList(node.id);
      }
    });
    // 点击选择框图标
    nodeDivNew.find(".tfp-dropdownbox-node-checkbox").click(function () {
      that.checkNode(node.id);
    });
  }

  /**
   * 处理节点选择框点击事件
   * @param  {[type]} nodeId [description]
   */
  checkNode(nodeId) {
    var that = this;
    this.nodes[nodeId].isSelect = !this.nodes[nodeId].isSelect;
    var node = this.nodes[nodeId];
    if (!node) return;
    var nodeDiv = this._jqObj.find(".tfp-dropdownbox-node[nodeId=" + nodeId + "]");
    // 单选
    if (!this.dataModel.multiCheck) {
      var otherNodesDiv = this._jqObj.find(".tfp-dropdownbox-node-checkbox");
      otherNodesDiv.find("div").each(function () {
        if (nodeId != $(this)[0].attributes.iconid.value) {
          that.nodes[$(this)[0].attributes.iconid.value].isSelect = false;
          $(this).context.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(false);
        }
      });
    }
    // 修改图标
    var iconDiv = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("div")[0];
    iconDiv.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(node.isSelect);
    var cbk = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("input").get(0);
    if (node.isSelect) {
      cbk.checked = true;
    } else {
      cbk.checked = false
    }
    that.setClickCheckboxs(nodeId, cbk.checked);
  }

  // 根据是否选中 判断选择框 显示哪种图标
  showCheckIcon(nodeCheck) {
    var that = this;
    var selectIcon = '';
    // 已选中
    if (nodeCheck) {
      // 复选
      if (that.dataModel.multiCheck) {
        selectIcon = 'fuxuankuangxuanzhong';
      } else {
        selectIcon = 'roundcheckfill';
      }
    } else {
      if (that.dataModel.multiCheck) {
        selectIcon = 'fuxuankuang';
      } else {
        selectIcon = 'circle1';
      }
    }
    return selectIcon;
  }

  /**
   * 选中数组
   * @param {*id值} nodeid 
   * @param {*是否选中} checked 
   */
  setClickCheckboxs(nodeid, checked, type) {
    var that = this;
    var node = that.nodes[nodeid];
    if (type == 'isSelect') {
      node = that.selectNodes[nodeid];
    }
    // 选中
    if (checked) {
      // 普通列表
      if (this.dataModel.loadList) {
        // 单选
        if (!that.dataModel.multiCheck) {
          that.clickCheckboxs = [];
          that.clickCheckboxs.push({
            id: node.id,
            name: node.name
          });
        } else {
          var hasSane = false;
          for (var x = 0; x < that.clickCheckboxs.length; x++) {
            if (nodeid == that.clickCheckboxs[x].id) {
              hasSane = true;
            }
          }
          if (!hasSane) {
            that.clickCheckboxs.push({
              id: node.id,
              name: node.name
            });
          }
        }
      } else {
        // 单选
        if (!that.dataModel.multiCheck) {
          that.clickCheckboxs = [];
          that.clickCheckboxs.push({
            id: node.id,
            name: node.name
          });
        } else {
          var hasSane = false;
          for (var x = 0; x < that.clickCheckboxs.length; x++) {
            if (nodeid == that.clickCheckboxs[x].id) {
              hasSane = true;
            }
          }
          if (!hasSane) {
            that.clickCheckboxs.push({
              id: node.id,
              name: node.name
            });
          }
        }
      }
    } else {
      var nodeIdList = [];
      for (var x = 0; x < that.clickCheckboxs.length; x++) {
        if (nodeid != that.clickCheckboxs[x].id) {
          nodeIdList.push(that.clickCheckboxs[x]);
        }
      }
      this.clickCheckboxs = nodeIdList;
    }
    this.setInputValue();
  }

  haveChild(nodeId) {
    return (this.nodes[nodeId].childNodes.length > 0);
  }

  /**
   * 处理节点展开收起按钮点击事件
   * @param  {[type]} nodeId [description]
   */
  toggleNode(nodeId) {
    var that = this;
    var nodeDiv = that._jqObj.find(".tfp-dropdownbox-node[nodeId=" + nodeId + "]");
    var childNodesDiv = that._jqObj.find(".tfp-dropdownbox-node-childs[nodeId=" + nodeId + "]");
    // 判断是叶节点返回
    if (that.nodes[nodeId].isLeaf) {
      childNodesDiv.hide();
      return false;
    }
    // 无子节点
    if (!that.haveChild(nodeId)) {
      nodeDiv.find('.tfp-dropdownbox-node-icon').html(`<span class="icon dtreefont dtree-icon-jian"></span>`);
      childNodesDiv.hide();
      return false;
    }
    if (!that.nodes[nodeId].isOpen) {
      nodeDiv.find('.tfp-dropdownbox-node-icon').html(`<span class="icon dtreefont dtree-icon-jian"></span>`);
      childNodesDiv.show();
      that.nodes[nodeId].isOpen = true;
    } else if (that.nodes[nodeId].isOpen) {
      nodeDiv.find('.tfp-dropdownbox-node-icon').html(`<span class="icon dtreefont dtree-icon-jia"></span>`);
      childNodesDiv.hide();
      that.nodes[nodeId].isOpen = false;
    }
  }

  getLeafNodeTextDivWidth(marginLeft) {
    //动态计算每个节点内文本框的最大宽度，以便文字过长时能自动出现省略号
    var divWidth = this._jqObj.get(0).offsetWidth;
    var nodeTextWidth = divWidth - marginLeft - 16 - 22;
    if (this.dataModel.showLeafNodeDeleteButton) nodeTextWidth -= 21;
    if (this.dataModel.showLeafNodeEditButton) nodeTextWidth -= 21;
    return nodeTextWidth;
  }

  /**
   * 获得节点HTML元素
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  getNodeEl(nodeId) {
    return this._jqObj.find(".tfp-dropdownbox-node[nodeId=" + nodeId + "]");
  }

  /**
   * 获得子节点容器HTML元素
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  getNodeChildsEl(nodeId) {
    return this._jqObj.find(".tfp-dropdownbox-node-childs[nodeId=" + nodeId + "]");
  }

  /**
   * 获得叶节点HTML元素
   * @param  {[type]} nodeId [description]
   * @return {[type]}        [description]
   */
  getLeafNodeEl(nodeId) {
    return this._jqObj.find(".tfp-dropdownbox-leaf-node[nodeId=" + nodeId + "]");
  }

  /**
   * 设置子节点左边距
   * @param {[type]} parent       [description]
   * @param {[type]} parentMargin [description]
   */
  setChildMargin(parent, parentMargin) {
    for (var i = 0; i < parent.childNodes.length; i++) {
      var node = this.nodes[parent.childNodes[i]];
      var nodeDiv = this.getNodeEl(node.id);
      var nodeIconDiv = nodeDiv.find(".tfp-dropdownbox-node-icon");
      nodeIconDiv.css("margin-left", (parentMargin + 20) + "px");
      this.setChildMargin(node, parentMargin + 20);
    }
  }

  /**
   * 获得选中的节点
   * @param  {[type]} getData [description]
   * @return {[type]}         [description]
   */
  getCheckedNodes(getData) {
    var nodes = [];
    let that = this;
    this._jqObj.find(".tfp-dropdownbox-node").each(function () {
      var input = $(this).first(".tfp-dropdownbox-node-checkbox").find("input");
      if (input.get(0).checked && input.val() != "") {
        var node = that.nodes[input.val()];
        if (getData) {
          nodes.push(node);
        } else {
          nodes.push({
            id: node.id,
            name: node.name,
            parentId: node.parentId
          });
        }
      }
    });
    return nodes;
  }

  /**
   * 获得选中的节点值
   * @return {[type]} [description]
   */
  getCheckedNodesValue() {
    var values = "";
    this._jqObj.find(".tfp-dropdownbox-node").each(function () {
      var input = $(this).find(".tfp-dropdownbox-node-checkbox").find("input");
      if (input.get(0).checked && input.val() != "") {
        if (values != "") values += ",";
        values += input.val();
      }
    });
    return values;
  }

  /**
   * 获得选中的叶节点值
   * @return {[type]} [description]
   */
  getCheckedLeafNodesValue() {
    var values = "";
    this._jqObj.find(".tfp-dropdownbox-leaf-node").each(function () {
      var input = $(this).find(".tfp-dropdownbox-node-checkbox").find("input");
      if (input.get(0).checked && input.val() != "") {
        if (values != "") values += ",";
        values += input.val();
      }
    });
    return values;
  }


  initRuntime() {
    if (!this.dataModel.loadDataListService) return;
    let that = this;
    this.clear();
    console.log('初始化')
    // 默认 显示树形 隐藏搜索框和搜索列表
    that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").hide();
    that._jqObj.find(".selectInputBox").hide();
    that._jqObj.find("#" + that.id + "_DropdownBoxDiv").show();
    that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").empty();
    that._jqObj.find(".tfp-dropdownbox-datalist").hide();

    // 开启搜索
    if (that.dataModel.enableFilter) {
      // 展示输入框
      that._jqObj.find(".selectInputBox").css('display', 'flex');

      // 输入框输入后搜索
      that._jqObj.find(".selectInput").on("input", function () {
        // 输入框无内容时切换回树形并清空搜索项
        if (that._jqObj.find(".selectInput").val() == '') {
          that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").hide();
          that._jqObj.find("#" + that.id + "_DropdownBoxDiv").show();
          event.stopPropagation();
        } else {
          that._jqObj.find("#" + that.id + "_DropdownBoxDiv").hide();
          that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").show();
          that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").html('');
          // 根据输入项加载后台数据
          that.loadSeek();
          event.stopPropagation();
        }
      })

      // 回车搜索
      that._jqObj.find(".selectInput").keydown(function (e) {
        var key = e.keyCode;
        if (key == 13) {
          if (that._jqObj.find(".selectInput").val() == '') {
            that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").hide();
            that._jqObj.find("#" + that.id + "_DropdownBoxDiv").show();
            event.stopPropagation();
          } else {
            that._jqObj.find("#" + that.id + "_DropdownBoxDiv").hide();
            that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").show();
            that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").html('');
            // 根据输入项加载后台数据
            that.loadSeek();
            event.stopPropagation();
          }
        }
      })
    }

    // 初始加载
    that.loadData();
    // 点击下拉框
    that._jqObj.find(".dropdownbox_top").click(function (e) {
      if (that._jqObj.find(".tfp-dropdownbox-datalist").css('display') != 'block') {
        // 展示弹出层
        that.showOptions();
      }
      event.stopPropagation();
    });
  }

  // 展示弹窗列表
  showOptions() {
    var that = this;
    // 调整位置
    var divDataList = $("#" + that.id + " .tfp-dropdownbox-datalist");
    if ($("body").innerHeight() < (Number(that.dataModel.dataListDivHeight) + Number(that._jqObj.offset().top) + Number($("#" + that.id).outerHeight()))) {
      divDataList.css("top", (Number(that._jqObj.offset().top) - (that.dataModel.dataListDivHeight ? Number(that.dataModel.dataListDivHeight) : 240)) + "px");
    } else {
      divDataList.css("top", (Number(that._jqObj.offset().top) + 31) + "px");
    }
    if (Number(that._jqObj.offset().left) + Number(that.dataModel.dataListDivWidth) > Number($("body").innerWidth())) {
      divDataList.css("left", Number(that._jqObj.offset().left) - (Number(that.dataModel.dataListDivWidth) - Number($("#" + that.id).outerWidth())) + "px");
    } else {
      divDataList.css("left", Number(that._jqObj.offset().left) + "px");
    }

    // 开启搜索
    if (that.dataModel.enableFilter) {
      // 输入框获取焦点
      that._jqObj.find(".selectInput").focus();
    }

    // 显示弹出框
    that._jqObj.find(".tfp-dropdownbox-datalist").css("display", "block");
    // 清除历史监听
    document.removeEventListener("click", judgeThis);
    // 全局点击监听
    document.addEventListener("click", judgeThis);

    function judgeThis(e) {
      // 判断是否点击树形 点击树形外自动关闭弹窗
      var isOut = 0;
      for (var x = 0; x < e.path.length; x++) {
        if (e.path[x].className == 'tfp-dropdownbox-datalist') {
          isOut++;
        }
      }
      if (isOut == 0) {
        // 隐藏弹窗
        that._jqObj.find(".tfp-dropdownbox-datalist").hide();
        // 清空输入项
        that._jqObj.find(".selectInput").val('');
        // 隐藏搜索项
        that._jqObj.find("#" + that.id + "_SelectDropDownBoxDiv").hide();
        that._jqObj.find("#" + that.id + "_DropdownBoxDiv").show();
        document.removeEventListener("click", judgeThis);
        return false;
      }
    }
  }

  /**
   * 服务加载子节点
   * @param {*父节点ID字段} attributes 
   * @param {*回调函数} cb 
   * @returns 
   */
  setChildrenNode(attributes, cb) {
    var that = this;
    if (that.nodes[attributes].isClicked) {
      return cb();
    }
    let serviceCpt = that._tfp.get(that.dataModel.loadDataListService);
    serviceCpt.status = 0;
    var args = {};
    args.parent_id = attributes;
    serviceCpt.request(args, function (req, res) {
      that._jqObj.find("#" + that.id + "_DropdownBoxDiv").empty()
      let nodesData = res[that.dataModel.nodeDataMember];
      if (!nodesData) {
        return cb();
      }
      var nodeIdArr = [];
      //将服务器端返回数据转换为节点对象
      if (nodesData instanceof Array) {
        for (var i = 0; i < nodesData.length; i++) {
          var nodeData = nodesData[i];
          var node = {};
          node.id = nodeData[that.dataModel.nodeIdFieldName];
          node.name = nodeData[that.dataModel.nodeNameFieldName];
          node.parentId = nodeData[that.dataModel.nodeParentIdFieldName];
          node.data = nodeData;
          node.childNodes = [];
          // 是否已选中
          node.isSelect = that.selectNodes[node.id] ? that.selectNodes[node.id].isSelect : false;
          // 是否已点击过
          node.isClicked = false;
          // 是否已展开
          node.isOpen = false;
          // 子节点数量字段
          if (that.dataModel.nodechildrenNum) node.child_num = nodeData[that.dataModel.nodechildrenNum];
          // 是否为叶节点
          if (that.dataModel.isLeaf) node.isLeaf = nodeData[that.dataModel.isLeaf];
          that.nodes[node.id] = node;
          nodeIdArr.push(node.id);
        }
      } else {
        that._tfp.showMsg("服务返回数据格式错误！");
        return cb();
      }

      //生成节点之间的关系
      for (var i = 0; i < nodeIdArr.length; i++) {
        var nodeId = nodeIdArr[i];
        var node = that.nodes[nodeId];
        if (node.parentId == that.dataModel.rootNodeParentId) {
          // 节点等级
          that.nodes[nodeId].level = 1;
          that.rootNodes.push(nodeId);
        } else {
          var parentNode = that.nodes[node.parentId];
          if (parentNode) {
            that.nodes[nodeId].level = parentNode.level + 1;
            parentNode.childNodes.push(nodeId);
          }
        }
      }

      for (var i = 0; i < that.rootNodes.length; i++) {
        var node = that.nodes[that.rootNodes[i]];
        if (!node.parentId) node.parentId = that.dataModel.rootNodeParentId;
        var divDataList = that._jqObj.find("#" + that.id + "_DropdownBoxDiv");
        that.createNode(divDataList, node, 5);
      }
      return cb();
    });
  }

  /**
   * 有选择框选中赋值
   */
  setInputValue() {
    var that = this;
    var iptValList = [];
    for (var x = 0; x < that.clickCheckboxs.length; x++) {
      iptValList.push(that.clickCheckboxs[x].name);
    }
    that._jqObj.find(".selectThis").val(iptValList.join(','))
    that.dataModel.value = that.escapeValue(that.dataModel.storageType, JSON.stringify(that.clickCheckboxs))
  }

  /**
   * 无选择框选中赋值
   * @param {*选中项} attributes 
   */
  noneInputSelect(attributes) {
    var that = this;
    if (that.dataModel.enableFilter && (that._jqObj.find(".selectInput").val() != '')) {
      var info = [{
        id: that.selectNodes[attributes].id,
        name: that.selectNodes[attributes].name
      }];
      that._jqObj.find(".selectThis").val(info[0].name)
      that.dataModel.value = that.escapeValue(that.dataModel.storageType, JSON.stringify(info))
    } else {
      var info = [{
        id: that.nodes[attributes].id,
        name: that.nodes[attributes].name
      }];
      that._jqObj.find(".selectThis").val(info[0].name)
      that.dataModel.value = that.escapeValue(that.dataModel.storageType, JSON.stringify(info))
    }
  }
  /**
   * 无选择框选中赋值 列表
   * @param {*选中项} attributes 
   */
  noneInputSelectList(attributes) {
    var that = this;
    if (that.dataModel.enableFilter && (that._jqObj.find(".selectInput").val() != '')) {
      var info = [{
        id: that.selectNodes[attributes].id,
        name: that.selectNodes[attributes].name
      }];
      that._jqObj.find(".selectThis").val(info[0].name)
      that.dataModel.value = that.escapeValue(that.dataModel.storageType, JSON.stringify(info))
    } else {
      var info = [{
        id: that.nodes[attributes].id,
        name: that.nodes[attributes].name
      }];
      that._jqObj.find(".selectThis").val(info[0].name)
      that.dataModel.value = that.escapeValue(that.dataModel.storageType, JSON.stringify(info))
    }
  }

  /**
   * 根据关键词搜索后台
   */
  loadSeek() {
    var that = this;
    // 搜索服务
    let serviceSel = that._tfp.get(that.dataModel.selectDataListService);
    var args = {};
    // 输入项
    args[that.dataModel.inputSelectinfo] = that._jqObj.find(".selectInput").val();
    serviceSel.request(args, function (req, res) {
      let nodesData = res[that.dataModel.nodeDataMember2];
      that.selectNodes = {};
      var divDataList = $("#" + that.id + "_SelectDropDownBoxDiv");
      // 普通列表
      if (that.dataModel.loadList) {
        for (var i = 0; i < nodesData.length; i++) {
          var nodeData = nodesData[i];
          var node = {};
          node.id = nodeData[that.dataModel.nodeIdFieldName2];
          node.name = nodeData[that.dataModel.nodeNameFieldName2];
          node.data = nodeData;
          // 是否已选中
          if (that.nodes[node.id]) {
            node.isSelect = that.nodes[node.id].isSelect;
          } else {
            node.isSelect = false;
          }
          that.selectNodes[node.id] = node;
          that.createSelectNodeList(divDataList, node, 5);
        }
        return
      }
      for (var i = 0; i < nodesData.length; i++) {
        var nodeData = nodesData[i];
        var node = {};
        node.id = nodeData[that.dataModel.nodeIdFieldName2];
        node.name = nodeData[that.dataModel.nodeNameFieldName2];
        node.parentId = nodeData[that.dataModel.nodeParentIdFieldName2];
        node.data = nodeData;
        // 是否已选中
        if (that.nodes[node.id]) {
          node.isSelect = that.nodes[node.id].isSelect;
        } else {
          node.isSelect = false;
        }
        node.childNodes = [];
        that.selectNodes[node.id] = node;
        that.createSelectNode(divDataList, node, 5);
      }
    })
  }

  /**
  * 创建搜索节点
  * @param  {[type]} parentDiv  [description]
  * @param  {[type]} node       [description]
  * @param  {[type]} marginLeft [description]
  */
  createSelectNode(parentDiv, node, marginLeft) {
    let that = this;
    // 写入列表
    var iconName = "jian";
    // iconName = `normal-file`;
    var nodeHtml = `<div class="tfp-dropdownbox-node isSelect" nodeid="` + node.id + `">
      <div class="tfp-dropdownbox-node-icon" style="margin-left: `+ marginLeft + `px;">
        <span class="icon dtreefont dtree-icon-`+ iconName + `"></span>
      </div>`
    // 显示节点选择框
    if (that.dataModel.showNodeCheckbox) {
      let cbkType = that.dataModel.multiCheck ? "checkbox" : "radio";
      let ischecked = '';
      let selectIcon = '';
      // 复选
      if (that.dataModel.multiCheck) {
        selectIcon = 'fuxuankuang';
      } else {
        selectIcon = 'circle1';
      }
      // 已选中
      if (node.isSelect) {
        ischecked = 'checked';
        // 复选
        if (that.dataModel.multiCheck) {
          selectIcon = 'fuxuankuangxuanzhong';
        } else {
          selectIcon = 'roundcheckfill';
        }
      }
      nodeHtml += `   
      <div class="tfp-dropdownbox-node-checkbox">
        <input type="`+ cbkType + `" value="` + node.id + `" ` + (cbkType == 'radio' ? `name="select_` + that.id + `"` : ``) + ` ` + ischecked + ` >
        <div class="icon dtreefont dtree-icon-`+ selectIcon + `" iconid="` + node.id + `">
        </div>
      </div>`;
    }
    nodeHtml += `
      <div class="tfp-dropdownbox-node-text">
        `+ node.name + `
      </div>
    </div>`;
    parentDiv.append(nodeHtml);

    let nodeDivNew = parentDiv.children(".tfp-dropdownbox-node").last();
    // 点击选择框图标
    nodeDivNew.find(".tfp-dropdownbox-node-checkbox").click(function (e) {
      var nodeId = e.target.attributes.iconid.value;
      that.selectNodes[nodeId].isSelect = !that.selectNodes[nodeId].isSelect;
      if (that.nodes[nodeId]) {
        that.nodes[nodeId].isSelect = that.selectNodes[nodeId].isSelect;
      }
      var node = that.selectNodes[nodeId];
      var nodeDiv = that._jqObj.find(".tfp-dropdownbox-node[nodeId=" + nodeId + "]");
      // 单选
      if (!that.dataModel.multiCheck) {
        var otherNodesDiv = that._jqObj.find(".tfp-dropdownbox-node-checkbox");
        otherNodesDiv.find("div").each(function () {
          if (nodeId != $(this)[0].attributes.iconid.value && that.selectNodes[nodeId].isSelect) {
            if (that.nodes[$(this)[0].attributes.iconid.value]) {
              that.nodes[$(this)[0].attributes.iconid.value].isSelect = false;
            }
            if (that.selectNodes[$(this)[0].attributes.iconid.value]) {
              that.selectNodes[$(this)[0].attributes.iconid.value].isSelect = false;
            }
            $(this).context.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(false);
          }
        });
      }
      // 修改图标
      var iconDiv = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("div")[0];
      iconDiv.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(node.isSelect);
      var cbk = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("input")[0]
      if (node.isSelect) {
        cbk.checked = true;
      } else {
        cbk.checked = false
      }
      var iconDiv2 = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("div")[1];
      if (iconDiv2) {
        iconDiv2.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(node.isSelect);
        var cbk2 = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("input")[1]
        if (node.isSelect) {
          cbk2.checked = true;
        } else {
          cbk2.checked = false
        }
      }
      that.setClickCheckboxs(nodeId, that.selectNodes[nodeId].isSelect, 'isSelect');
    });
    // 点击文字
    nodeDivNew.find(".tfp-dropdownbox-node-text").click(function () {
      that._jqObj.find(".tfp-dropdownbox-node").removeClass("tfp-dropdownbox-node-selected");
      $(this).closest(".tfp-dropdownbox-node").addClass("tfp-dropdownbox-node-selected");
      // 不显示节点选择框
      if (!that.dataModel.showNodeCheckbox) {
        that.noneInputSelect(node.id);
      }
    });

  }

  /**
    * 创建搜索节点  列表
    * @param  {[type]} parentDiv  [description]
    * @param  {[type]} node       [description]
    * @param  {[type]} marginLeft [description]
    */
  createSelectNodeList(parentDiv, node, marginLeft) {
    let that = this;
    // 写入列表
    var iconName = `normal-file`;
    var nodeHtml = `<div class="tfp-dropdownbox-node isSelect" nodeid="` + node.id + `">
    <div class="tfp-dropdownbox-node-icon" style="margin-left: `+ marginLeft + `px;">
      <span class="icon dtreefont dtree-icon-`+ iconName + `"></span>
    </div>`
    // 显示节点选择框
    if (that.dataModel.showNodeCheckbox) {
      let cbkType = that.dataModel.multiCheck ? "checkbox" : "radio";
      let ischecked = '';
      let selectIcon = '';
      // 复选
      if (that.dataModel.multiCheck) {
        selectIcon = 'fuxuankuang';
      } else {
        selectIcon = 'circle1';
      }
      // 已选中
      if (node.isSelect) {
        ischecked = 'checked';
        // 复选
        if (that.dataModel.multiCheck) {
          selectIcon = 'fuxuankuangxuanzhong';
        } else {
          selectIcon = 'roundcheckfill';
        }
      }
      nodeHtml += `   
      <div class="tfp-dropdownbox-node-checkbox">
        <input type="`+ cbkType + `" value="` + node.id + `" ` + (cbkType == 'radio' ? `name="select_` + that.id + `"` : ``) + ` ` + ischecked + ` >
        <div class="icon dtreefont dtree-icon-`+ selectIcon + `" iconid="` + node.id + `">
        </div>
      </div>`;
    }
    nodeHtml += `
      <div class="tfp-dropdownbox-node-text">
        `+ node.name + `
      </div>
    </div>`;
    parentDiv.append(nodeHtml);

    let nodeDivNew = parentDiv.children(".tfp-dropdownbox-node").last();
    // 点击选择框图标
    nodeDivNew.find(".tfp-dropdownbox-node-checkbox").click(function (e) {
      var nodeId = e.target.attributes.iconid.value;
      that.selectNodes[nodeId].isSelect = !that.selectNodes[nodeId].isSelect;
      if (that.nodes[nodeId]) {
        that.nodes[nodeId].isSelect = that.selectNodes[nodeId].isSelect;
      }
      var node = that.selectNodes[nodeId];
      var nodeDiv = that._jqObj.find(".tfp-dropdownbox-node[nodeId=" + nodeId + "]");
      // 单选
      if (!that.dataModel.multiCheck) {
        var otherNodesDiv = that._jqObj.find(".tfp-dropdownbox-node-checkbox");
        otherNodesDiv.find("div").each(function () {
          if (nodeId != $(this)[0].attributes.iconid.value && that.selectNodes[nodeId].isSelect) {
            if (that.nodes[$(this)[0].attributes.iconid.value]) {
              that.nodes[$(this)[0].attributes.iconid.value].isSelect = false;
            }
            if (that.selectNodes[$(this)[0].attributes.iconid.value]) {
              that.selectNodes[$(this)[0].attributes.iconid.value].isSelect = false;
            }
            $(this).context.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(false);
          }
        });
      }
      // 修改图标
      var iconDiv = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("div")[0];
      iconDiv.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(node.isSelect);
      var cbk = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("input")[0]
      if (node.isSelect) {
        cbk.checked = true;
      } else {
        cbk.checked = false
      }
      var iconDiv2 = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("div")[1];
      if (iconDiv2) {
        iconDiv2.className = "icon dtreefont dtree-icon-" + that.showCheckIcon(node.isSelect);
        var cbk2 = nodeDiv.find(".tfp-dropdownbox-node-checkbox").find("input")[1]
        if (node.isSelect) {
          cbk2.checked = true;
        } else {
          cbk2.checked = false
        }
      }
      that.setClickCheckboxs(nodeId, that.selectNodes[nodeId].isSelect, 'isSelect');
    });
    // 点击文字
    nodeDivNew.find(".tfp-dropdownbox-node-text").click(function () {
      that._jqObj.find(".tfp-dropdownbox-node").removeClass("tfp-dropdownbox-node-selected");
      $(this).closest(".tfp-dropdownbox-node").addClass("tfp-dropdownbox-node-selected");
      // 不显示节点选择框
      if (!that.dataModel.showNodeCheckbox) {
        that.noneInputSelectList(node.id);
      }
    });
  }
}