import TFPComponentRender from '../render.js'

export default class DropdownRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let bodyHtml = "\r\n" + indent + "\t<input type=\"text\" readonly/>\r\n";
    bodyHtml += indent + "\t<img src=\"" + this._tfp.rootPath
      + "/src/components/select/images/arrow-down-"
      + this._tfp.curPage.contentColorMode + ".png\" />\r\n"
    return bodyHtml + "\t";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}