export default {
  "name": "Dropdown",
  "comment": "弹出菜单",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "列表设置",
      "type": "group",
      "items": [
        {
          "name": "options",
          "comment": "选项设置",
          "type": "Dataset",
          "isPro": true,
          "keyCol": "name",
          "width": "640px",
          "height": "600px",
          "columns": [
            {
              "id": "value",
              "name": "选项值",
              "type": "String",
              "required": true
            },
            {
              "id": "text",
              "name": "选项文本",
              "type": "String",
              "required": true
            },
            {
              "id": "target",
              "name": "目标页面",
              "type": "Select",
              "default": "self",
              "options": [
                {
                  "value": "self",
                  "text": "当前页面"
                },
                {
                  "value": "page",
                  "text": "新页面"
                },
                {
                  "value": "dialog",
                  "text": "对话框"
                },
                {
                  "value": "window",
                  "text": "新窗口"
                }
              ]
            },
            {
              "id": "targetTitle",
              "name": "目标页面标题",
              "type": "String"
            },
            {
              "id": "href",
              "name": "目标页面地址",
              "type": "String",
              "isHtmlAttr": true,
              "special": true
            },
            {
              "id": "dialogWidth",
              "name": "对话框宽度",
              "type": "Int"
            },
            {
              "id": "dialogHeight",
              "name": "对话框高度",
              "type": "Int"
            }
          ]
        }]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "dataListValueFormat",
          "comment": "选项值数据格式",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "dataListTextFormat",
          "comment": "选项文本数据格式",
          "type": "String",
          "showModelFieldList": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "120px",
    "height": "30px",
    "line-height": "30px",
    "padding-left": "2px",
    "padding-right": "2px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClickOption",
      "comment": "点击列表项时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "index",
          "comment": "选项索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "value",
          "comment": "选项值",
          "type": "String",
          "required": true
        }
      ]
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}