import { FormInput } from "../controller.js";

/**
 * 弹出菜单组件
 * @param {[type]} dataModel [description]
 */
export default class Dropdown extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Dropdown", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    let val = value;
    if (isNull(value)) {
      val = "";
      this.dataModel.value = null;
    } else {
      this.dataModel.value = val;
    }
  }

  get options() { return this.dataModel.options }
  set options(value) {
    this.dataModel.options = value;
    return;
  }

  get dataListValueFormat() { return this.dataModel.dataListValueFormat }
  set dataListValueFormat(value) {
    this.dataModel.dataListValueFormat = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListValueFormat) {
      alert("请为[" + this.id + "]设置选项值数据格式！");
      return false;
    }
    return true;
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.options = [];

    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let valueFormat = this.dataModel.dataListValueFormat;
        if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
        option.value = this._tfp.replaceDataField(row, valueFormat);
        if (option.value) option.value = this._tfp.exeExpress(option.value);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      option.text = option.value;
      if (this.dataModel.dataListTextFormat) {
        try {
          let textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (isNull(option.text)) continue;
      this.options.push(option);
    }
    if (this.options.length == 0) return;
  }

  addOptionDiv(divDataList, option) {
    let html = '';
    if (option.href) {
      html += "<a ";
      if (!this._tfp.isDesigning) {
        if (option.target == "self") {
          html += " href=\"" + option.href + "\"";
        } else {
          html += " href=\"javascript:void(0)\" onclick=\"";
          let title = "Tasgine - 任擎";
          if (option.targetTitle) title = option.targetTitle;
          if (option.target == "page") {
            html += "tfp.openPage('" + title + "', '" + option.href + "')";
          } else if (option.target == "dialog") {
            let width = option.dialogWidth;
            if (!width) width = "480px";
            if ((width + "").indexOf("px") < 0) width += "px";
            let height = option.dialogHeight;
            if (!height) height = "480px";
            if ((height + "").indexOf("px") < 0) height += "px";
            html += "tfp.openDialog('" + title + "', '" + option.href + "'"
              + ", '" + width + "', '" + height + "')";
          } else if (option.target == "window") {
            html += "window.open('" + option.href + "', '" + title + "')";
          }
          html += "\"";
        }
      }
      html += ">";
    }
    html += "<label>" + (option.text ? option.text : option.value) + "</label>";
    if (option.href) {
      html += "</a>";
    }

    divDataList.append("<div data-value=\"" + option.value + "\">" + html + "</div > ");
  }

  showOptions() {
    if (!this.options || this.options.length == 0) return;
    var divDataList = $("#" + this.id + "_dropdownDiv");
    let leg = divDataList.find("div").length;
    if (leg == 0) {
      for (var i = 0; i < this.options.length; i++) {
        var option = this.options[i];
        this.addOptionDiv(divDataList, option);
      }
    }
    var that = this;

    divDataList.find("div").click(function () {
      event.stopPropagation();

      let value = $(this).attr("data-value");
      let index = $(this).index();

      that.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      try {
        if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
      } catch (err) {
        console.log(err.message);
      }
      divDataList.find("div").unbind("click");
      divDataList.hide();
    });

    divDataList.css("left", that._jqObj.offset().left + "px");
    divDataList.css("top", (that._jqObj.offset().top + 31) + "px");
    divDataList.show();

    document.addEventListener("click", function () {
      if (!$(event.target).is(divDataList)) divDataList.hide();
    });
  }

  initRuntime() {
    let that = this;

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    }

    this._jqObj.find("input").click(function () {
      that.showOptions();
      event.stopPropagation();
    });

    let dataListDivWidth = this._jqObj.width() + 6;
    //添加数据列表层
    $("body").append("<div id=\"" + this.id + "_dropdownDiv\" "
      + "class=\"tfp-dropdown-datalist\" style=\"width:" + dataListDivWidth
      + "px;\"></div>");
  }
}