import TFPComponentRender from '../render.js'

export default class DateTimeRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let iptWidth = "96%";
    if (this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";
    let val = "";
    let pla = "";
    if (this.dataModel.value) {
      val = this.dataModel.value;
    } else if (this.dataModel.defaultNow && this._tfp.isDesigning) {
      val = this.cpt.getCurDateTime();
    }
    if (this.dataModel.placeHolder) {
      pla = this.dataModel.placeHolder;
    }
    html += indent + "\t<input type=\"text\" readonly style=\"width:"
      + iptWidth + ";\" value=\"" + val + "\" placeholder=\"" + pla + "\"/>\r\n";
    if (this.cpt.showIcon) html += indent + "\t<img src=\"" + this.cpt.iconUrl + "\" />\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}