import TFPComponentRender from '../render.js'

export default class DateRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);

    if (!this._tfp.isDesigning) {
      var vid = escape(this.dataModel.id).replaceAll("%", "");
      if (this.dataModel.defaultNow) {
        if (this.dataModel.type == "Date") this.dataModel.value = (new Date()).format("yyyy-MM-dd");
        else if (this.dataModel.type == "Time") this.dataModel.value = (new Date()).format("hh:mm");
        else this.dataModel.value = (new Date()).format("yyyy-MM-dd hh:mm");
      }

      attrHtml += " mode=\"" + this.dataModel.type.toLocaleLowerCase() + "\"";
      if (otherOptions && otherOptions.gridContainer) {
        attrHtml += " name=\"" + this.dataModel.id + "_{{index}}\"";
        attrHtml += " value=\"{{item." + vid + "}}\"";
      }
      else {
        attrHtml += " name=\"" + this.dataModel.id + "\"";
        attrHtml += " value=\"{{" + vid + "}}\"";
      }
      attrHtml += " bindchange=\"bindchange_controller\"";
    }

    return attrHtml;
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let iptWidth = this.cpt.getIptWidth();
    let val = "";
    if (this.dataModel.value) {
      val = this.dataModel.value;
    } else if (this.dataModel.defaultNow && this._tfp.isDesigning) {
      val = this.cpt.getCurDateTime();
    }
    html += indent + "\t<div class=\"wx-" + this.dataModel.type.toLocaleLowerCase() + "-picker\">" + val + "</div>\r\n";
    if (this.cpt.showIcon) html += indent + "\r\n";
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }

    var vid = escape(this.dataModel.id).replaceAll("%", "");
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "\t<view class=\"wx-" + this.dataModel.type.toLocaleLowerCase() + "-picker\">";
    if (otherOptions && otherOptions.gridContainer)
      bodyHtml += "{{item." + vid + "}}";
    else
      bodyHtml += "{{" + vid + "}}";
    bodyHtml += "</view>\r\n";

    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("picker", false, parentIndent, retainStyleAttr, otherOptions);
  }
}