import { FormInput } from "../controller.js";

/**
 * 日期时间组件
 * @param {[type]} dataModel [description]
 */
export default class DateTime extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "DateTime", dataModel, parent);
    }
  }

  //属性
  get value() { return this.dataModel.value }
  set value(value) {
    if (value) {
      let date = new Date(value);
      if (this.type == "Date") {
        if (this.dataModel.showMode == "yearMonthMode") {
          this.dataModel.value = date.format("yyyy-MM");
        } else if (this.dataModel.showMode == "yearMode") {
          this.dataModel.value = date.format("yyyy");
        } else {
          this.dataModel.value = date.format("yyyy-MM-dd");
        }
      } else {
        if (this.showSecond) {
          this.dataModel.value = date.format("yyyy-MM-dd HH:mm:ss");
        } else {
          this.dataModel.value = date.format("yyyy-MM-dd HH:mm");
        }
      }
    } else {
      this.dataModel.value = "";
    }
    if (this._jqObj) {
      this._jqObj.find("input").val(this.dataModel.value);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      if (this.dataModel.onChange) {
        eval(this.dataModel.onChange);
      }
      //下面这种方式不好使
      //this.exeEventHandler("onChange", this.dataModel.value);
    }
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.find("input").attr("placeholder", value);
  }

  get iconUrl() {
    return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase()
      + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
  }
  set iconUrl(value) { }

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) {
    this.dataModel.showIcon = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.showIcon) {
        if (this._jqObj.find("img").length == 0) {
          this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      this.resetWidth();
    }
  }

  get showSecond() { return this.dataModel.showSecond }
  set showSecond(value) {
    this.dataModel.showSecond = value ? true : false;
    if (this._jqObj) {
      this.resetWidth();
      if (this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurDateTime());
      }
    }
  }

  get defaultNow() { return this.dataModel.defaultNow }
  set defaultNow(value) {
    this.dataModel.defaultNow = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").val(this.getCurDateTime());
      } else {
        this._jqObj.find("input").val("");
      }
    }
  }

  get showMode() { return this.dataModel.showMode }
  set showMode(value) {
    this.dataModel.showMode = value;
  }

  getCptWidth() {
    let cptWidth = "95px";
    if (this.dataModel.showIcon) cptWidth = "125px";
    if (this.dataModel.type == "DateTime") {
      cptWidth = "135px";
      if (this.dataModel.showIcon) cptWidth = "165px";
      if (this.dataModel.showSecond) cptWidth = "185px";
    }
    return cptWidth;
  }

  resetWidth() {
    //如果当前组件的宽度设置为了100%，则不要因为是否显示图标、是否显示秒等参数变化而改变宽度
    if (this.dataModel.styles && this.dataModel.styles["width"] == "100%") return;
    let cptWidth = this.getCptWidth();
    let iptWidth = "96%";
    if (this.showIcon) iptWidth = "calc(100% - 30px)";
    this._jqObj.find("input").css("width", iptWidth);
    this._jqObj.css("width", cptWidth);
    this._jqObj.css("min-width", cptWidth);
    if (!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth;
    this.dataModel.styles["min-width"] = cptWidth;
  }

  clear() {
    this.value = "";
    this.closePicker();
  }

  closePicker() {
    $(".tfp-datetime-picker").remove();
    $("body").unbind("click", this.closePicker);
  };

  showPicker() {
    let offset = this._jqObj.offset();
    let val = new Date();
    if (this.dataModel.value && !isNaN(new Date(this.dataModel.value).getTime())) val = new Date(this.dataModel.value);
    let width = 240;
    if (this.type == "DateTime") width = this.showSecond ? 405 : 351;
    let top = offset.top + 31;
    let left = offset.left;
    let docWidth = document.documentElement.clientWidth;
    let docHeight = document.documentElement.clientHeight;
    //根据页面大小自动调整显示位置
    if ((left + width) > docWidth) {
      left = (offset.left + this._jqObj.outerWidth()) - width;
      if (left < 0) left = 0;
    }
    if ((top + 302) > docHeight) {
      top = offset.top - 302;
      if (top < 0) top = 0;
    }
    //默认开始年份是当前年份 - 10，结束年份是当前年份 + 10
    let yearBegin = (new Date()).getFullYear() - 10;
    let yearFinish = (new Date()).getFullYear() + 10;
    //如果当前组件设置了起止年份，则用设置的起止年份
    if (this.dataModel.startYear) yearBegin = this.dataModel.startYear;
    if (this.dataModel.endYear) yearFinish = this.dataModel.endYear;
    /*if (this.dataModel.value) {
      yearBegin = (this.dataModel.value + "").substring(0, 3) + '0';
      yearFinish = (this.dataModel.value + "").substring(0, 3) + '9';
    }*/

    let html = "<div class=\"tfp-datetime-picker\" data-cptid=\"" + this.id + "\" data-value=\""
      + val.format("yyyy-MM-dd") + "\" style=\"top: " + top + "px; left:" + left + "px; width: " + width + "px; display:none;\">";
    let imgDir = this._tfp.rootPath + "/src/components/datetime/images/";
    html += "<div style=\"width:100%;height:30px;border-bottom: 1px solid #CCCCCC;\">"
      + "<div class=\"tfp-datetime-picker-header\">"
      + "<div style=\"width:16px;\" title=\"上一年\"><img src=\"" + imgDir + "double-arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;"
    if (this.dataModel.showMode == "yearMonthMode" || this.dataModel.showMode == "yearMode")
      html += "display:none;";
    html += "\" title=\"上一月\"><img src=\"" + imgDir + "arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:166px; text-align:center;\">"
    if (this.dataModel.showMode == "yearMode") {
      html += "<span>" + yearBegin + "</span> 年 - <span>" + yearFinish + "</span> 年";
    } else {
      html += "<input class=\"tfp-datetime-picker-year\" type=\"text\" value=" + val.getFullYear() + " /> 年 ";
    }
    if (this.dataModel.showMode != "yearMonthMode" && this.dataModel.showMode != "yearMode")
      html += "<input class=\"tfp-datetime-picker-month\"  type=\"text\" value=" + (val.getMonth() + 1) + " /> 月"
    html += "</div>"
      + "<div style=\"width:16px;"
    if (this.dataModel.showMode == "yearMonthMode" || this.dataModel.showMode == "yearMode")
      html += "display:none;";
    html += "\" title=\"下一月\"><img src=\"" + imgDir + "arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;\" title=\"下一年\"><img src=\"" + imgDir + "double-arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "</div>";
    if (this.type == "DateTime") {
      html += "<div class=\"tfp-datetime-picker-time-value\" "
        + "style=\"width: " + (this.showSecond ? 162 : 108) + "px;\">"
        + this.getTimeValue() + "</div>";
    }
    html += "</div><div style=\"width:100%;height:230px;\">";
    if (this.dataModel.showMode == "yearMonthMode") {
      html += "<div class=\"tfp-datetime-picker-year-month-mode\">";
      html += "</div>";
    } else if (this.dataModel.showMode == "yearMode") {
      html += "<div class=\"tfp-datetime-picker-year-mode\">";
      html += "</div>";
    } else {
      html += "<div class=\"tfp-datetime-picker-grid\">";
      html += "<div class=\"tfp-datetime-picker-grid-header\">";
      html += "<div>一</div><div>二</div><div>三</div><div>四</div><div>五</div><div>六</div><div>日</div>"
      html += "</div>";
      html += "</div>";
    }
    if (this.type == "DateTime") {
      html += "<div class=\"tfp-datetime-picker-time-list\" "
        + "style=\"width: " + (this.showSecond ? 163 : 109) + "px;\">";
      html += this.getTimePickerHtml();
      html += "</div>";
    }
    html += "</div>";
    html += "<div class=\"tfp-datetime-picker-footer\"><span>清空</span>"

    if (this.dataModel.showMode == "yearMonthMode") {
      html += "<span style=\"color:#003399;\">本月</span>";
    } else if (this.dataModel.showMode == "yearMode") {
      html += "<span style=\"color:#003399;\">本年</span>";
    } else {
      html += "<span style=\"color:#003399;\">今天</span>";
    }
    if (this.type == "DateTime") html += "<input type=\"button\" value=\"确定\" />";
    html += "</div></div>";
    $("body").append(html);
    this.setDatePickerValue(val);
    let datetimePicker = $(".tfp-datetime-picker");
    let that = this;
    $(".tfp-datetime-picker-header").find("img").each(function (index) {
      $(this).click(function () {
        if (index == 0) {
          that.toPrevYear();
        } else if (index == 1) {
          that.toPrevMonth();
        } else if (index == 2) {
          that.toNextMonth();
        } else if (index == 3) {
          that.toNextYear();
        }
        event.stopPropagation();
      });
    });
    $(".tfp-datetime-picker-header").find("input").eq(0).change(function () {
      var reyear = /^(1949|19[5-9]\d|20\d{2}|2100)$/;
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      var dateYear = new Date($(this).val()).getFullYear();

      if (!reyear.test(dateYear)) {
        $(".tfp-datetime-picker-header").find("input").eq(0).val(date.getFullYear());
        that.setDatePickerValue(date);
        return;
      }

      date.setYear(dateYear);
      that.setDatePickerValue(date);
    })
    $(".tfp-datetime-picker-header").find("input").eq(1).change(function () {
      var remonth = /0?[0-9]|1[0-2]/;
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      var dateMonth = new Date($(this).val()).getMonth();

      if (!remonth.test(dateMonth)) {
        $(".tfp-datetime-picker-header").find("input").eq(1).val(date.getMonth());
        that.setDatePickerValue(date);
        return;
      }

      date.setMonth(dateMonth);
      that.setDatePickerValue(date);
    })
    let footer = datetimePicker.find(".tfp-datetime-picker-footer");
    footer.find("span").eq(0).click(function () {
      that.clear();
    });
    if (this.dataModel.showMode == "yearMonthMode") {
      footer.find("span").eq(1).click(function () {
        that.toMonth();
      });
    } else if (this.dataModel.showMode == "yearMode") {
      footer.find("span").eq(1).click(function () {
        that.toYear();
      });
    } else {
      footer.find("span").eq(1).click(function () {
        that.toToday();
      });
    }
    datetimePicker.click(function () {
      event.stopPropagation();
    });
    datetimePicker.fadeIn("slow");
    if (this.type == "DateTime") {
      let timeList = $(".tfp-datetime-picker-time-list").find("ul");
      timeList.each(function () {
        $(this).find("li").each(function () {
          $(this).click(function () {
            $(this).parent().find("li").attr("class", "");
            $(this).parent().find("li").css("color", "");
            $(this).attr("class", "tfp-datetime-picker-bgcolor");
            $(this).css("color", "#FFFFFF");
            $(this).parent().attr("data-value", $(this).html());
            let timeValue = timeList.eq(0).attr("data-value") + ":" + timeList.eq(1).attr("data-value");
            if (that.showSecond) timeValue += ":" + timeList.eq(2).attr("data-value");
            $(".tfp-datetime-picker-time-value").html(timeValue);
            event.stopPropagation();
          });
        });
        $(this).get(0).scrollTop = parseInt($(this).attr("data-value")) * 25;
      });
      footer.find("input").eq(0).click(function () {
        that.onCheckDateTime();
      });
    }
    $("body").bind("click", this.closePicker);
  }

  onCheckDateTime() {
    let val = $(".tfp-datetime-picker").attr("data-value");
    if (this.type == "DateTime") {
      let time = $(".tfp-datetime-picker-time-value").html();
      if (!time || time == "") time = "00:00";
      val += " " + time;
    }
    
  }

  setVal(val) {
    this.value = val;
    this.closePicker();
    this._jqObj.find("input").focus();
  }

  setDatePickerValue(date) {
    let firstDate = new Date(date.format("yyyy-MM-01"));
    let curWeek = firstDate.getDay();
    if (curWeek == 0) curWeek = 7;
    curWeek--;
    if (curWeek > 0) firstDate.setDate(firstDate.getDate() - curWeek);

    let grid = $(".tfp-datetime-picker-grid");
    grid.find(".tfp-datetime-picker-grid-row").remove();

    let month = $(".tfp-datetime-picker-year-month-mode");
    month.find(".tfp-datetime-picker-year-month-row").remove();

    let year = $(".tfp-datetime-picker-year-mode");
    year.find(".tfp-datetime-picker-year-row").remove();

    if (this.dataModel.showMode == "yearMonthMode") {
      $(".tfp-datetime-picker").attr("data-value", date.format("yyyy-MM"));
    } else if (this.dataModel.showMode == "yearMode") {
      $(".tfp-datetime-picker").attr("data-value", date.format("yyyy"));
    } else {
      $(".tfp-datetime-picker").attr("data-value", date.format("yyyy-MM-dd"));
    }
    $(".tfp-datetime-picker-header").find("input").eq(0).val(date.getFullYear());
    $(".tfp-datetime-picker-header").find("input").eq(1).val(date.getMonth() + 1);

    if (this.dataModel.showMode == "yearMonthMode") {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      var monthData = [{
        "name": "一月",
        "value": "01"
      }, {
        "name": "二月",
        "value": "02"
      }, {
        "name": "三月",
        "value": "03"
      }, {
        "name": "四月",
        "value": "04"
      }, {
        "name": "五月",
        "value": "05"
      }, {
        "name": "六月",
        "value": "06"
      }, {
        "name": "七月",
        "value": "07"
      }, {
        "name": "八月",
        "value": "08"
      }, {
        "name": "九月",
        "value": "09"
      }, {
        "name": "十月",
        "value": "10"
      }, {
        "name": "十一月",
        "value": "11"
      }, {
        "name": "十二月",
        "value": "12"
      }];
      var monthIndex = 0;
      for (var i = 0; i < 3; i++) {
        let monHtml = "<div class=\"tfp-datetime-picker-year-month-row\">";
        for (var j = 0; j < 4; j++) {
          let colorClass = "";
          if (this.dataModel.value && this.dataModel.value == date.getFullYear() + "-" + monthData[monthIndex].value) {
            colorClass = "tfp-datetime-picker-color";
          } else if (!this.dataModel.value && date.getFullYear() + "-" + monthData[monthIndex].value == new Date().format("yyyy-MM")) {
            colorClass = "tfp-datetime-picker-color";
          }
          monHtml += "<div data-value=\"" + date.getFullYear()
            + "-" + monthData[monthIndex].value + "\" class=\"" + colorClass + "\">" + monthData[monthIndex].name + "</div>";
          monthIndex++;
        }
        monHtml += "</div>";
        month.append(monHtml);
      }
    } else if (this.dataModel.showMode == "yearMode") {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      var date_begin = $(".tfp-datetime-picker-header").find("span").eq(0).text();
      var date_finish = $(".tfp-datetime-picker-header").find("span").eq(1).text();

      for (var i = 0; i < 3; i++) {
        var yearHtml = "<div class=\"tfp-datetime-picker-year-row\">";

        for (var j = 0; j < 4; j++) {
          if (date_begin > date_finish) continue;
          let colorClass = "";
          if (date_begin == date.getFullYear()) colorClass = "tfp-datetime-picker-color";

          yearHtml += "<div data-value=\"" + date_begin + "\" class=\"" + colorClass + "\">" + date_begin + "</div>";
          date_begin++;
        }

        yearHtml += "</div>";
        year.append(yearHtml);
      }
    } else {
      var index = 0;
      for (var i = 0; i < 6; i++) {
        let rowHtml = "<div class=\"tfp-datetime-picker-grid-row\">";
        for (var j = 0; j < 7; j++) {
          let dateTmp = new Date(firstDate.format("yyyy-MM-dd"));
          dateTmp.setDate(dateTmp.getDate() + index);
          let style = "";
          let colorClass = "";
          if (dateTmp.format("yyyy-MM-dd") == date.format("yyyy-MM-dd")) {
            style = "color:#FFFFFF;";
            colorClass = "tfp-datetime-picker-bgcolor";
          } else if (dateTmp.format("yyyy-MM") != date.format("yyyy-MM")) {
            style = "color:#999999;";
          }
          rowHtml += "<div data-value=\"" + dateTmp.format("yyyy-MM-dd")
            + "\" class=\"" + colorClass + "\" style=\"" + style + "\">" + dateTmp.format("dd") + "</div>";
          index++;
        }
        rowHtml += "</div>";
        grid.append(rowHtml);
      }
    }
    let that = this;
    grid.find(".tfp-datetime-picker-grid-row").each(function () {
      $(this).find("div").click(function () {
        if (that.type == "DateTime") {
          $(".tfp-datetime-picker-grid-row").find("div").each(function () {
            let dateTmp = $(this).attr("data-value");
            let curDate = $(".tfp-datetime-picker").attr("data-value");
            if (dateTmp == curDate) {
              $(this).attr("class", "");
              if (dateTmp.substr(0, 7) != curDate.substr(0, 7)) {
                $(this).css("color", "#999999");
              } else {
                $(this).css("color", "");
              }
              return false;
            }
          });
          $(".tfp-datetime-picker").attr("data-value", $(this).attr("data-value"));
          $(this).attr("class", "tfp-datetime-picker-bgcolor");
          $(this).css("color", "#FFFFFF");
          event.stopPropagation();
        } else {
          that.setVal($(this).attr("data-value"));
        }
      });
    });
    month.find(".tfp-datetime-picker-year-month-row").each(function () {
      $(this).find("div").click(function () {
        that.setVal($(this).attr("data-value"));
      });
    });
    year.find(".tfp-datetime-picker-year-row").each(function () {
      $(this).find("div").click(function () {
        that.setVal($(this).attr("data-value"));
      });
    });
  }

  getTimeValue() {
    let date;
    if (!this.dataModel.value) {
      date = new Date();
      if (this.showSecond) {
        return date.format("HH:mm:ss");
      } else {
        return date.format("HH:mm");
      }
    }
    if (this.showSecond) {
      date = new Date(this.dataModel.value);
      return date.format("HH:mm:ss");
    } else {
      date = new Date(this.dataModel.value + ":00");
      return date.format("HH:mm");
    }
  }

  getTimePickerHtml() {
    let html = "";
    let vals = this.getTimeValue().split(":");
    html += "<ul data-value=\"" + (vals.length > 0 ? vals[0] : "00") + "\" style=\"height:230px;\">";
    for (var i = 0; i < 24; i++) {
      let hour = i < 10 ? "0" + i : i + "";
      html += "<li";
      if (vals.length > 0 && hour == vals[0]) html += " class=\"tfp-datetime-picker-bgcolor\" style=\"color: #FFFFFF;\"";
      html += ">" + hour + "</li>";
    }
    html += "</ul>";
    html += "<ul data-value=\"" + (vals.length > 1 ? vals[1] : "00") + "\" style=\"height:230px;\">";
    for (var i = 0; i < 60; i++) {
      let minute = i < 10 ? "0" + i : i + "";
      html += "<li";
      if (vals.length > 1 && minute == vals[1]) html += " class=\"tfp-datetime-picker-bgcolor\" style=\"color: #FFFFFF;\"";
      html += ">" + minute + "</li>";
    }
    html += "</ul>";
    if (this.showSecond) {
      html += "<ul data-value=\"" + (vals.length > 2 ? vals[2] : "00") + "\" style=\"height:230px;\">";
      for (var i = 0; i < 60; i++) {
        let second = i < 10 ? "0" + i : i + "";
        html += "<li";
        if (vals.length > 2 && second == vals[2]) html += " class=\"tfp-datetime-picker-bgcolor\" style=\"color: #FFFFFF;\"";
        html += ">" + second + "</li>";
      }
      html += "</ul>";
    }
    return html;
  }

  toToday() {
    let now = new Date();
    this.setDatePickerValue(now);
    if (this.type == "Date") {
      this.setVal(now.format("yyyy-MM-dd"));
    }
    event.stopPropagation();
  }

  toMonth() {
    let now = new Date();
    this.setDatePickerValue(now);
    if (this.type == "Date") {
      this.setVal(now.format("yyyy-MM"));
    }
    event.stopPropagation();
  }

  toYear() {
    let now = new Date();
    this.setDatePickerValue(now);
    if (this.type == "Date") {
      this.setVal(now.format("yyyy"));
    }
    event.stopPropagation();
  }

  toPrevYear() {
    if (this.dataModel.showMode == "yearMode") {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      var date_begin = $(".tfp-datetime-picker-header").find("span").eq(0).text();
      var date_finish = $(".tfp-datetime-picker-header").find("span").eq(1).text();
      $(".tfp-datetime-picker-header").find("span").eq(0).text(parseInt(date_begin) - 10);
      $(".tfp-datetime-picker-header").find("span").eq(1).text(parseInt(date_finish) - 10);
      this.setDatePickerValue(date);
    } else {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      date.setYear(date.getFullYear() - 1);
      this.setDatePickerValue(date);
    }
  }

  toPrevMonth() {
    let date = new Date($(".tfp-datetime-picker").attr("data-value"));
    date.setMonth(date.getMonth() - 1);
    this.setDatePickerValue(date);
  }

  toNextYear() {
    if (this.dataModel.showMode == "yearMode") {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      var date_begin = $(".tfp-datetime-picker-header").find("span").eq(0).text();
      var date_finish = $(".tfp-datetime-picker-header").find("span").eq(1).text();
      $(".tfp-datetime-picker-header").find("span").eq(0).text(parseInt(date_begin) + 10);
      $(".tfp-datetime-picker-header").find("span").eq(1).text(parseInt(date_finish) + 10);
      this.setDatePickerValue(date);
    } else {
      var date = new Date($(".tfp-datetime-picker").attr("data-value"));
      date.setYear(date.getFullYear() + 1);
      this.setDatePickerValue(date);
    }
  }

  toNextMonth() {
    let date = new Date($(".tfp-datetime-picker").attr("data-value"));
    date.setMonth(date.getMonth() + 1);
    this.setDatePickerValue(date);
  }

  getCurDateTime() {
    if (this.type == "Date") {
      if (this.dataModel.showMode == "yearMonthMode") {
        return (new Date()).format("yyyy-MM");
      } else if (this.dataModel.showMode == "yearMode") {
        return (new Date()).format("yyyy");
      } else {
        return (new Date()).format("yyyy-MM-dd");
      }
    }
    if (this.type == "DateTime") {
      if (this.showSecond) {
        return (new Date()).format("yyyy-MM-dd HH:mm:ss");
      } else {
        return (new Date()).format("yyyy-MM-dd HH:mm");
      }
    }
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.find("input").css({ "margin-left": "0px", "padding-left": "0px" });
    }

    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      if ($(".tfp-datetime-picker").length > 0) {
        let cptId = $(".tfp-datetime-picker").attr("data-cptid");
        if (cptId == that.id) return;
        that.closePicker();
      }
      that.showPicker();
      event.stopPropagation();
    });
    if (this.dataModel.defaultNow && !this.dataModel.value) {
      this.dataModel.value = this.getCurDateTime();
      this._jqObj.find("input").val(this.dataModel.value);
    }

    this._jqObj.hover(function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("background-color", "#F6F6F6");
        that._jqObj.find("input").css("background-color", "#F6F6F6");
      }
    }, function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that._jqObj.find("input").is(":focus")) {
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
    });

    this._jqObj.find("input").focus(function () {
      if (that.disabled) return;
      if(that._tfp.curPage.bgColorMode=="light") 
        that._jqObj.css("outline", "1px solid var(--sys-theme-color)");
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find("input").blur(function () {
      if (that.disabled) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("outline", "0");
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    })
  }
}