import TFPComponentRender from '../render.js'

export default class DateRangeRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let palStart = '';
    let palEnd = '';
    let valStart = '';
    let valEnd = '';

    if (this.dataModel.showMode == 'monthMode') {
      palStart = '开始月份';
      palEnd = '结束月份';
    } else {
      palStart = '开始日期';
      palEnd = '结束日期';
    }
    if (this.dataModel.defaultNow) {
      valStart = this.cpt.getCurDateTime();
      valEnd = this.cpt.getCurDateTime();
    }
    if (this.dataModel.value) {
      valStart = this.dataModel.value.start;
      valEnd = this.dataModel.value.end;
    }
    if (this.dataModel.startDate && this.dataModel.endDate) {
      valStart = this.dataModel.startDate;
      valEnd = this.dataModel.endDate;
    }

    html += indent + "\t<input type=\"text\" readonly value=\"" + valStart + "\" placeholder=\"" + palStart + "\"/>"
      + "<label>至</label><input type=\"text\" readonly value=\"" + valEnd + "\" placeholder=\"" + palEnd + "\"/>\r\n";
    if (this.cpt.showIcon) html += indent + "\t<img src=\"" + this.cpt.iconUrl + "\" />\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}