import { FormInput } from "../controller.js";

/**
 * 日期范围组件
 * @param {[type]} dataModel [description]
 */
export default class DateRange extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "DateRange", dataModel, parent);
      this.dateValue = {};
      this.dateStartValue = '';
    }
  }

  //属性
  get value() { return this.dataModel.value }
  set value(value) {
    if (value) {
      let val = value;
      if (typeof (val) == "string") val = JSON.parse(value);
      this.dataModel.value = {};
      this.dataModel.value.start = val.start;
      this.dataModel.value.end = val.end;
    } else {
      this.dataModel.value = '';
    }
    if (this._jqObj) {
      if (value) {
        this._jqObj.find("input").eq(0).val(this.dataModel.value.start);
        this._jqObj.find("input").eq(1).val(this.dataModel.value.end);
      } else {
        this._jqObj.find("input").eq(0).val('');
        this._jqObj.find("input").eq(1).val('');
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      if (this.dataModel.onChange) {
        eval(this.dataModel.onChange);
      }
    }
  }

  get iconUrl() {
    return this._tfp.rootPath + "/src/components/" + this.type.toLowerCase()
      + "/images/icon-24-" + this._tfp.curPage.contentColorMode + ".png";
  }
  set iconUrl(value) { }

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) {
    this.dataModel.showIcon = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.showIcon) {
        if (this._jqObj.find("img").length == 0) {
          this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      this.resetWidth();
    }
  }

  get defaultNow() { return this.dataModel.defaultNow }
  set defaultNow(value) {
    this.dataModel.defaultNow = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").eq(0).val(this.getCurDateTime());
        this._jqObj.find("input").eq(1).val(this.getCurDateTime());
      } else {
        this._jqObj.find("input").val("");
      }
    }
  }

  get showMode() { return this.dataModel.showMode }
  set showMode(value) {
    this.dataModel.showMode = value;
    if (this._jqObj) {
      if (this.dataModel.defaultNow && this._tfp.isDesigning) {
        this._jqObj.find("input").eq(0).val(this.getCurDateTime());
        this._jqObj.find("input").eq(1).val(this.getCurDateTime());
      } else {
        this._jqObj.find("input").val("");
      }
      if (this._tfp.isDesigning) {
        if (this.dataModel.showMode == 'monthMode') {
          this._jqObj.find("input").eq(0).attr('placeholder', '开始月份');
          this._jqObj.find("input").eq(1).attr('placeholder', '结束月份');
        } else {
          this._jqObj.find("input").eq(0).attr('placeholder', '开始日期');
          this._jqObj.find("input").eq(1).attr('placeholder', '结束日期');
        }
      }
    }
  }

  get startDate() { return this.dataModel.startDate }
  set startDate(value) {
    this.dataModel.startDate = value;
    if (this._jqObj && this.dataModel.endDate) {
      this._jqObj.find("input").eq(0).val(this.dataModel.startDate);
      this._jqObj.find("input").eq(1).val(this.dataModel.endDate);
    }
  }

  get endDate() { return this.dataModel.endDate }
  set endDate(value) {
    this.dataModel.endDate = value;
    if (this._jqObj && this.dataModel.startDate) {
      this._jqObj.find("input").eq(0).val(this.dataModel.startDate);
      this._jqObj.find("input").eq(1).val(this.dataModel.endDate);
    }
  }

  get start() { return this.dataModel.value.start }
  set start(value) {
    this.dataModel.value.start = value;
    if (this._jqObj && this.dataModel.value.start) {
      this._jqObj.find("input").eq(0).val(this.dataModel.value.start);
    }
  }

  get end() { return this.dataModel.value.end }
  set end(value) {
    this.dataModel.value.end = value;
    if (this._jqObj && this.dataModel.value.end) {
      this._jqObj.find("input").eq(0).val(this.dataModel.value.end);
    }
  }

  resetWidth() {
    let cptWidth = 227;
    if (this.showIcon) cptWidth += 20;
    this._jqObj.css("width", cptWidth + "px");
    this._jqObj.css("min-width", cptWidth + "px");
    if (!this.dataModel.styles) this.dataModel.styles = {};
    this.dataModel.styles["width"] = cptWidth + "px";
    this.dataModel.styles["min-width"] = cptWidth + "px";
  }

  clear() {
    this.value = '';
    this.closePicker();
  }

  closePicker() {
    $(".tfp-daterange-picker").remove();
    $("body").unbind("click", this.closePicker);
  };

  showPicker() {
    let offset = this._jqObj.offset();
    var valStart = new Date();
    var valEnd = new Date(new Date(this.getFirst(valStart)).setMonth(new Date(this.getFirst(valStart)).getMonth() + 1));
    let heaWidth = "166px";
    if (this.dataModel.showMode == 'monthMode') {
      heaWidth = "196px";
      valEnd = new Date(new Date().setFullYear(new Date().getFullYear() + 1));
    }
    if (this.dataModel.value) {
      valStart = new Date(this.dataModel.value.start);
      valEnd = new Date(this.dataModel.value.end);
    }
    let width = 480;
    let top = offset.top + 31;
    let left = offset.left;
    let docWidth = document.documentElement.clientWidth;
    let docHeight = document.documentElement.clientHeight;
    //根据页面大小自动调整显示位置
    if ((left + width) > docWidth) {
      left = (offset.left + this._jqObj.outerWidth()) - width;
      if (left < 0) left = 0;
    }
    if ((top + 302) > docHeight) {
      top = offset.top - 302;
      if (top < 0) top = 0;
    }
    let imgDir = this._tfp.rootPath + "/src/components/datetime/images/";

    let html = "<div class=\"tfp-daterange-picker\" data-cptid=\"" + this.id + "\" style=\"top: " + top + "px; left:" + left + "px; width: " + width + "px;\">";

    html += "<div class=\"tfp-daterange-picker-left\" data-value=\"" + valStart.format("yyyy-MM-dd") + "\">";
    html += "<div style=\"width:100%;height:30px;border-bottom: 1px solid #CCCCCC;\">"
      + "<div class=\"tfp-daterange-picker-header\">"
      + "<div style=\"width:16px;\" title=\"上一年\"><img src=\"" + imgDir + "double-arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;";
    if (this.dataModel.showMode == "monthMode") html += "display:none;"
    html += "\" title=\"上一月\"><img src=\"" + imgDir + "arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:" + heaWidth + "; text-align:center;\">"
      + "<span class=\"tfp-daterange-picker-year\">" + valStart.getFullYear() + "</span> 年 ";
    if (this.dataModel.showMode == "defaultMode") html += "<span class=\"tfp-daterange-picker-month\">" + (valStart.getMonth() + 1) + "</span> 月";
    html += "</div>"
      + "<div style=\"width:16px;";
    if (this.dataModel.showMode == "monthMode") html += "display:none;"
    html += "\" title=\"下一月\"><img src=\"" + imgDir + "arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;\" title=\"下一年\"><img src=\"" + imgDir + "double-arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>";
    html += "</div></div> ";
    html += "<div style =\"width:100%;height:230px;\">";
    if (this.dataModel.showMode == "monthMode") {
      html += "<div class=\"tfp-daterange-picker-grid-month\">";
      html += "</div>";
    } else {
      html += "<div class=\"tfp-daterange-picker-grid\">";
      html += "<div class=\"tfp-daterange-picker-grid-header\">";
      html += "<div>一</div><div>二</div><div>三</div><div>四</div><div>五</div><div>六</div><div>日</div>"
      html += "</div>";
      html += "</div>";
    }
    html += "</div>";
    html += "<div class=\"tfp-daterange-picker-footer\"><span>清空</span>"
    if (this.dataModel.showMode == 'monthMode') {
      html += "<span>本月</span><span>半年</span><span>一年</span>"
    } else {
      html += "<span>今天</span><span>一周</span><span>半月</span><span>一月</span><span>半年</span>"
    }
    html += "</div></div>";

    html += "<div class=\"tfp-daterange-picker-right\" data-value=\"" + valEnd.format("yyyy-MM-dd") + "\">";
    html += "<div style=\"width:100%;height:30px;border-bottom: 1px solid #CCCCCC;\">"
      + "<div class=\"tfp-daterange-picker-header\">"
      + "<div style=\"width:16px;\" title=\"上一年\"><img src=\"" + imgDir + "double-arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;";
    if (this.dataModel.showMode == "monthMode") html += "display:none;"
    html += "\" title=\"上一月\"><img src=\"" + imgDir + "arrow-left-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:" + heaWidth + "; text-align:center;\">"
      + "<span class=\"tfp-daterange-picker-year\">" + valEnd.getFullYear() + "</span> 年 ";
    if (this.dataModel.showMode == "defaultMode") html += "<span class=\"tfp-daterange-picker-month\">" + (valEnd.getMonth() + 1) + "</span> 月"
    html += "</div>"
      + "<div style=\"width:16px;";
    if (this.dataModel.showMode == "monthMode") html += "display:none;"
    html += "\" title=\"下一月\"><img src=\"" + imgDir + "arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>"
      + "<div style=\"width:16px;\" title=\"下一年\"><img src=\"" + imgDir + "double-arrow-right-" + this._tfp.curPage.contentColorMode + ".png\"></div>";
    html += "</div></div> ";
    html += "<div class=\"tfp-daterange-picker-content\" style =\"width:100%;height:230px;\">";
    if (this.dataModel.showMode == "monthMode") {
      html += "<div class=\"tfp-daterange-picker-grid-month\">";
      html += "</div>";
    } else {
      html += "<div class=\"tfp-daterange-picker-grid\">";
      html += "<div class=\"tfp-daterange-picker-grid-header\">";
      html += "<div>一</div><div>二</div><div>三</div><div>四</div><div>五</div><div>六</div><div>日</div>"
      html += "</div>";
      html += "</div>";
    }
    html += "</div>";
    html += "<div class=\"tfp-daterange-picker-footer\">"
    if (this.dataModel.showMode != 'monthMode') {
      html += "<span style='margin:0'>一年</span>"
    }
    html += "</div></div>";

    html += "</div>";

    $("body").append(html);
    this.setDateRangeValue(valStart, valEnd);
    let datetimePicker = $(".tfp-daterange-picker");
    let that = this;
    $(".tfp-daterange-picker-header").find("img").each(function (index) {
      $(this).click(function () {
        if (index == 0 || index == 4) {
          that.toPrevYear(index);
        } else if (index == 1 || index == 5) {
          that.toPrevMonth(index);
        } else if (index == 2 || index == 6) {
          that.toNextMonth(index);
        } else if (index == 3 || index == 7) {
          that.toNextYear(index);
        }
        event.stopPropagation();
      });
    });

    let footerLeft = datetimePicker.find(".tfp-daterange-picker-left .tfp-daterange-picker-footer");
    let footerRight = datetimePicker.find(".tfp-daterange-picker-right .tfp-daterange-picker-footer");
    footerLeft.find("span").eq(0).click(function () {
      that.clear();
    });
    if (this.dataModel.showMode == 'monthMode') {
      footerLeft.find("span").eq(1).click(function () {
        that.quickSetDateValue(that.getCurDateTime(), that.getCurDateTime())
      });
      footerLeft.find("span").eq(2).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, new Date(new Date(that.dateValue.start).setMonth(new Date(that.dateValue.start).getMonth() + 6)).format("yyyy-MM"));
          } else if (that.dateValue.end) {
            that.quickSetDateValue(new Date(new Date(that.dateValue.end).setMonth(new Date(that.dateValue.end).getMonth() - 6)).format("yyyy-MM"), that.dateValue.end);
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM"), new Date(new Date().setMonth(new Date().getMonth() + 6)).format("yyyy-MM"));
        }
      });
      footerLeft.find("span").eq(3).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, new Date(new Date(that.dateValue.start).setFullYear(new Date(that.dateValue.start).getFullYear() + 1)).format("yyyy-MM"));
          } else if (that.dateValue.end) {
            that.quickSetDateValue(new Date(new Date(that.dateValue.end).setFullYear(new Date(that.dateValue.end).getFullYear() - 1)).format("yyyy-MM"), that.dateValue.end);
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM"), new Date(new Date().setFullYear(new Date().getFullYear() + 1)).format("yyyy-MM"));
        }
      });
    } else {
      footerLeft.find("span").eq(1).click(function () {
        that.quickSetDateValue(that.getCurDateTime(), that.getCurDateTime())
      });
      footerLeft.find("span").eq(2).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, that.getDateEnd(new Date(that.dateValue.start), 7))
          } else if (that.dateValue.end) {
            that.quickSetDateValue(that.getDateStart(new Date(that.dateValue.end), 7), that.dateValue.end)
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM-dd"), that.getDateEnd(new Date(), 7))
        }
      });
      footerLeft.find("span").eq(3).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, that.getDateEnd(new Date(that.dateValue.start), 15))
          } else if (that.dateValue.end) {
            that.quickSetDateValue(that.getDateStart(new Date(that.dateValue.end), 15), that.dateValue.end)
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM-dd"), that.getDateEnd(new Date(), 15))
        }
      });
      footerLeft.find("span").eq(4).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, new Date(new Date(that.dateValue.start).setMonth(new Date(that.dateValue.start).getMonth() + 1)).format("yyyy-MM-dd"));
          } else if (that.dateValue.end) {
            that.quickSetDateValue(new Date(new Date(that.dateValue.end).setMonth(new Date(that.dateValue.end).getMonth() - 1)).format("yyyy-MM-dd"), that.dateValue.end);
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM-dd"), new Date(new Date().setMonth(new Date().getMonth() + 1)).format("yyyy-MM-dd"));
        }
      });
      footerLeft.find("span").eq(5).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, new Date(new Date(that.dateValue.start).setMonth(new Date(that.dateValue.start).getMonth() + 6)).format("yyyy-MM-dd"));
          } else if (that.dateValue.end) {
            that.quickSetDateValue(new Date(new Date(that.dateValue.end).setMonth(new Date(that.dateValue.end).getMonth() - 6)).format("yyyy-MM-dd"), that.dateValue.end);
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM-dd"), new Date(new Date().setMonth(new Date().getMonth() + 6)).format("yyyy-MM-dd"));
        }
      });
      footerRight.find("span").eq(0).click(function () {
        if (!$.isEmptyObject(that.dateValue)) {
          if (that.dateValue.start) {
            that.quickSetDateValue(that.dateValue.start, new Date(new Date(that.dateValue.start).setFullYear(new Date(that.dateValue.start).getFullYear() + 1)).format("yyyy-MM-dd"));
          } else if (that.dateValue.end) {
            that.quickSetDateValue(new Date(new Date(that.dateValue.end).setFullYear(new Date(that.dateValue.end).getFullYear() - 1)).format("yyyy-MM-dd"), that.dateValue.end);
          }
        } else {
          that.quickSetDateValue(new Date().format("yyyy-MM-dd"), new Date(new Date().setFullYear(new Date().getFullYear() + 1)).format("yyyy-MM-dd"));
        }
      });
    }


    datetimePicker.click(function () {
      event.stopPropagation();
    });
    $("body").bind("click", this.closePicker);
  }

  setDateRangeValue(dateStart, dateEnd) {
    let firstDate = new Date(dateStart.format("yyyy-MM-01"));
    let curWeekLeft = firstDate.getDay();
    if (curWeekLeft == 0) curWeekLeft = 7;
    curWeekLeft--;
    if (curWeekLeft > 0) firstDate.setDate(firstDate.getDate() - curWeekLeft);

    let lastDate = new Date(dateEnd.format("yyyy-MM-01"));
    let curWeekRight = lastDate.getDay();
    if (curWeekRight == 0) curWeekRight = 7;
    curWeekRight--;
    if (curWeekRight > 0) lastDate.setDate(lastDate.getDate() - curWeekRight);

    let gridLeft = $(".tfp-daterange-picker-left .tfp-daterange-picker-grid");
    gridLeft.find(".tfp-daterange-picker-grid-row").remove();

    let gridLeftMonth = $(".tfp-daterange-picker-left .tfp-daterange-picker-grid-month");
    gridLeftMonth.find(".tfp-daterange-picker-grid-row-month").remove();

    let gridRight = $(".tfp-daterange-picker-right .tfp-daterange-picker-grid");
    gridRight.find(".tfp-daterange-picker-grid-row").remove();

    let gridRightMonth = $(".tfp-daterange-picker-right .tfp-daterange-picker-grid-month");
    gridRightMonth.find(".tfp-daterange-picker-grid-row-month").remove();

    if (this.dataModel.showMode == "monthMode") {
      $(".tfp-daterange-picker-left").attr("data-value", dateStart.format("yyyy-MM"));
    } else {
      $(".tfp-daterange-picker-left").attr("data-value", dateStart.format("yyyy-MM-dd"));
    }
    $(".tfp-daterange-picker-left .tfp-daterange-picker-header").find("span").eq(0).text(dateStart.getFullYear());
    $(".tfp-daterange-picker-left .tfp-daterange-picker-header").find("span").eq(1).text(dateStart.getMonth() + 1);

    if (this.dataModel.showMode == "monthMode") {
      $(".tfp-daterange-picker-right").attr("data-value", dateEnd.format("yyyy-MM"));
    } else {
      $(".tfp-daterange-picker-right").attr("data-value", dateEnd.format("yyyy-MM-dd"));

    }
    $(".tfp-daterange-picker-right .tfp-daterange-picker-header").find("span").eq(0).text(dateEnd.getFullYear());
    $(".tfp-daterange-picker-right .tfp-daterange-picker-header").find("span").eq(1).text(dateEnd.getMonth() + 1);

    if (this.dataModel.showMode == "monthMode") {
      var dateLeft = new Date($(".tfp-daterange-picker-left").attr("data-value"));
      var dateRight = new Date($(".tfp-daterange-picker-right").attr("data-value"));
      var monthData = [{
        "name": "一月",
        "value": "01"
      }, {
        "name": "二月",
        "value": "02"
      }, {
        "name": "三月",
        "value": "03"
      }, {
        "name": "四月",
        "value": "04"
      }, {
        "name": "五月",
        "value": "05"
      }, {
        "name": "六月",
        "value": "06"
      }, {
        "name": "七月",
        "value": "07"
      }, {
        "name": "八月",
        "value": "08"
      }, {
        "name": "九月",
        "value": "09"
      }, {
        "name": "十月",
        "value": "10"
      }, {
        "name": "十一月",
        "value": "11"
      }, {
        "name": "十二月",
        "value": "12"
      }];
      var monthIndex = 0;
      for (var i = 0; i < 3; i++) {
        let monHtmlLeft = "<div class=\"tfp-daterange-picker-grid-row-month\">";
        let monHtmlRight = "<div class=\"tfp-daterange-picker-grid-row-month\">";

        for (var j = 0; j < 4; j++) {
          let dateLeftTmp = new Date(dateLeft.getFullYear() + "-" + monthData[monthIndex].value);
          let dateRightTmp = new Date(dateRight.getFullYear() + "-" + monthData[monthIndex].value);
          let monstyleLeft = "";
          let monstyleRight = "";
          let monclassLeft = "";
          let monclassRight = "";

          if (this.dateStartValue && dateLeftTmp.format("yyyy-MM") == new Date(this.dateStartValue).format("yyyy-MM")) {
            monstyleLeft = "color:#FFFFFF;";
            monclassLeft = "tfp-daterange-picker-bgcolor";
          } else if (!this.dateStartValue && this.dataModel.value && (dateLeftTmp.format("yyyy-MM") == new Date(this.dataModel.value.start).format("yyyy-MM") || dateLeftTmp.format("yyyy-MM") == new Date(this.dataModel.value.end).format("yyyy-MM"))) {
            monstyleLeft = "color:#FFFFFF;";
            monclassLeft = "tfp-daterange-picker-bgcolor";
          } else if (!this.dateStartValue && this.dataModel.value && dateLeftTmp > new Date(this.dataModel.value.start) && dateLeftTmp < new Date(this.dataModel.value.end)) {
            monstyleLeft = "background:#eee;";
            if (this._tfp.curPage.bgColorMode == 'dark') monstyleLeft = "background:#505050;";
          } else if (dateLeftTmp.format("yyyy-MM") == new Date().format("yyyy-MM")) {
            monclassLeft = "tfp-daterange-picker-color";
          }

          if (this.dateStartValue && dateRightTmp.format("yyyy-MM") == new Date(this.dateStartValue).format("yyyy-MM")) {
            monstyleRight = "color:#FFFFFF;";
            monclassRight = "tfp-daterange-picker-bgcolor";
          } else if (!this.dateStartValue && this.dataModel.value && (dateRightTmp.format("yyyy-MM") == new Date(this.dataModel.value.start).format("yyyy-MM") || dateRightTmp.format("yyyy-MM") == new Date(this.dataModel.value.end).format("yyyy-MM"))) {
            monstyleRight = "color:#FFFFFF;";
            monclassRight = "tfp-daterange-picker-bgcolor";
          } else if (!this.dateStartValue && this.dataModel.value && dateRightTmp > new Date(this.dataModel.value.start) && dateRightTmp < new Date(this.dataModel.value.end)) {
            monstyleRight = "background:#eee;";
            if (this._tfp.curPage.bgColorMode == 'dark') monstyleRight = "background:#505050;";
          } else if (dateRightTmp.format("yyyy-MM") == new Date().format("yyyy-MM")) {
            monclassRight = "tfp-daterange-picker-color";

          }

          monHtmlLeft += "<div data-value=\"" + dateLeft.getFullYear()
            + "-" + monthData[monthIndex].value + "\" class=\"" + monclassLeft + "\" style=\"" + monstyleLeft + "\">" + monthData[monthIndex].name + "</div>";

          monHtmlRight += "<div data-value=\"" + dateRight.getFullYear()
            + "-" + monthData[monthIndex].value + "\" class=\"" + monclassRight + "\"  style=\"" + monstyleRight + "\">" + monthData[monthIndex].name + "</div>";
          monthIndex++;
        }
        monHtmlLeft += "</div>";
        monHtmlRight += "</div>";
        gridLeftMonth.append(monHtmlLeft);
        gridRightMonth.append(monHtmlRight);
      }
    } else {
      var index = 0;
      for (var i = 0; i < 6; i++) {
        let rowLeftHtml = "<div class=\"tfp-daterange-picker-grid-row\">";
        let rowRightHtml = "<div class=\"tfp-daterange-picker-grid-row\">";
        for (var j = 0; j < 7; j++) {
          let dateLeftTmp = new Date(firstDate.format("yyyy-MM-dd"));
          let dateRightTmp = new Date(lastDate.format("yyyy-MM-dd"));
          dateLeftTmp.setDate(dateLeftTmp.getDate() + index);
          dateRightTmp.setDate(dateRightTmp.getDate() + index);
          let styleLeft = "";
          let styleRight = "";
          let classLeft = "";
          let classRight = "";

          if (this.dateStartValue && dateLeftTmp.format("yyyy-MM-dd") == new Date(this.dateStartValue).format("yyyy-MM-dd")) {
            styleLeft = "color:#FFFFFF;";
            classLeft = "tfp-daterange-picker-bgcolor";
          } else if (!this.dateStartValue && this.dataModel.value && (dateLeftTmp.format("yyyy-MM-dd") == new Date(this.dataModel.value.start).format("yyyy-MM-dd") || dateLeftTmp.format("yyyy-MM-dd") == new Date(this.dataModel.value.end).format("yyyy-MM-dd"))) {
            if (dateLeftTmp.format("yyyy-MM") != dateStart.format("yyyy-MM")) {
              styleLeft = "color:#999999;";
            } else {
              styleLeft = "color:#FFFFFF;";
              classLeft = "tfp-daterange-picker-bgcolor";
            }
          } else if (!this.dateStartValue && this.dataModel.value && dateLeftTmp > new Date(this.dataModel.value.start) && dateLeftTmp < new Date(this.dataModel.value.end)) {
            styleLeft = "background:#eee;";
            if (this._tfp.curPage.bgColorMode == 'dark') styleLeft = "background:#505050;";
          } else if (dateLeftTmp.format("yyyy-MM") != dateStart.format("yyyy-MM")) {
            styleLeft = "color:#999999;";
          } else if (dateLeftTmp.format("yyyy-MM-dd") == new Date().format("yyyy-MM-dd")) {
            classLeft = "tfp-daterange-picker-color";
          }

          if (this.dateStartValue && dateRightTmp.format("yyyy-MM-dd") == new Date(this.dateStartValue).format("yyyy-MM-dd")) {
            styleRight = "color:#FFFFFF;";
            classRight = "tfp-daterange-picker-bgcolor";
          } else if (!this.dateStartValue && this.dataModel.value && (dateRightTmp.format("yyyy-MM-dd") == new Date(this.dataModel.value.start).format("yyyy-MM-dd") || dateRightTmp.format("yyyy-MM-dd") == new Date(this.dataModel.value.end).format("yyyy-MM-dd"))) {
            if (dateRightTmp.format("yyyy-MM") != dateEnd.format("yyyy-MM")) {
              styleRight = "color:#999999;";
            } else {
              styleRight = "color:#FFFFFF;";
              classRight = "tfp-daterange-picker-bgcolor";
            }
          } else if (!this.dateStartValue && this.dataModel.value && dateRightTmp > new Date(this.dataModel.value.start) && dateRightTmp < new Date(this.dataModel.value.end)) {
            styleRight = "background:#eee;";
            if (this._tfp.curPage.bgColorMode == 'dark') styleRight = "background:#505050;";
          } else if (dateRightTmp.format("yyyy-MM") != dateEnd.format("yyyy-MM")) {
            styleRight = "color:#999999;";
          } else if (dateRightTmp.format("yyyy-MM-dd") == new Date().format("yyyy-MM-dd")) {
            classRight = "tfp-daterange-picker-color";

          }

          rowLeftHtml += "<div data-value=\"" + dateLeftTmp.format("yyyy-MM-dd")
            + "\" class=\"" + classLeft + "\" style=\"" + styleLeft + "\">" + dateLeftTmp.format("dd") + "</div>";
          rowRightHtml += "<div data-value=\"" + dateRightTmp.format("yyyy-MM-dd")
            + "\" class=\"" + classRight + "\" style=\"" + styleRight + "\">" + dateRightTmp.format("dd") + "</div>";
          index++;
        }
        rowLeftHtml += "</div>";
        rowRightHtml += "</div>";

        gridLeft.append(rowLeftHtml);
        gridRight.append(rowRightHtml);
      }
    }

    let that = this;
    that.dateValue = {};
    gridLeft.find(".tfp-daterange-picker-grid-row").each(function () {
      $(this).find("div").click(function () {
        $(".tfp-daterange-picker-left .tfp-daterange-picker-grid-row").find("div").each(function () {
          let dateTmp = $(this).attr("data-value");
          let curDate = $(".tfp-daterange-picker-left").attr("data-value");

          if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.start).format("yyyy-MM-dd") || new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.end).format("yyyy-MM-dd") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
            $(this).attr("class", "");
            $(this).css("background-color", "");
            if (dateTmp.substr(0, 7) != curDate.substr(0, 7)) {
              $(this).css("color", "#999999");
            } else if (dateTmp == new Date().format("yyyy-MM-dd")) {
              $(this).attr("class", "tfp-daterange-picker-color");
              $(this).css("color", "");
            } else {
              $(this).css("color", "");
            }
          }
        });
        $(this).attr("class", "tfp-daterange-picker-bgcolor");
        $(this).css("color", "#FFFFFF");
        event.stopPropagation();
        if (that.dateValue.start) {
          that.dateValue.end = $(this).attr("data-value");
        } else {
          that.dateValue.start = $(this).attr("data-value");
          $(".tfp-daterange-picker-right .tfp-daterange-picker-grid-row").find("div").each(function () {
            let dateTmp = $(this).attr("data-value");
            let curDate = $(".tfp-daterange-picker-right").attr("data-value");

            if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.start).format("yyyy-MM-dd") || new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.end).format("yyyy-MM-dd") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
              $(this).attr("class", "");
              $(this).css("background-color", "");
              if (dateTmp.substr(0, 7) != curDate.substr(0, 7)) {
                $(this).css("color", "#999999");
              } else if (dateTmp == new Date().format("yyyy-MM-dd")) {
                $(this).attr("class", "tfp-daterange-picker-color");
                $(this).css("color", "");
              } else {
                $(this).css("color", "");
              }
            }
          });
        }
        if (that.dateStartValue) that.dateValue.end = that.dateStartValue;
        that.setDateValue(that.dateValue);
      });
    });

    gridRight.find(".tfp-daterange-picker-grid-row").each(function () {
      $(this).find("div").click(function () {
        $(".tfp-daterange-picker-right .tfp-daterange-picker-grid-row").find("div").each(function () {
          let dateTmp = $(this).attr("data-value");
          let curDate = $(".tfp-daterange-picker-right").attr("data-value");

          if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.start).format("yyyy-MM-dd") || new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.end).format("yyyy-MM-dd") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
            $(this).attr("class", "");
            $(this).css("background-color", "");
            if (dateTmp.substr(0, 7) != curDate.substr(0, 7)) {
              $(this).css("color", "#999999");
            } else if (dateTmp == new Date().format("yyyy-MM-dd")) {
              $(this).attr("class", "tfp-daterange-picker-color");
              $(this).css("color", "");
            } else {
              $(this).css("color", "");
            }
          }
        });
        $(this).attr("class", "tfp-daterange-picker-bgcolor");
        $(this).css("color", "#FFFFFF");
        event.stopPropagation();
        if (that.dateValue.end) {
          that.dateValue.start = $(this).attr("data-value");
        } else {
          that.dateValue.end = $(this).attr("data-value");
          $(".tfp-daterange-picker-left .tfp-daterange-picker-grid-row").find("div").each(function () {
            let dateTmp = $(this).attr("data-value");
            let curDate = $(".tfp-daterange-picker-left").attr("data-value");

            if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.start).format("yyyy-MM-dd") || new Date(dateTmp).format("yyyy-MM-dd") == new Date(that.dataModel.value.end).format("yyyy-MM-dd") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
              $(this).attr("class", "");
              $(this).css("background-color", "");
              if (dateTmp.substr(0, 7) != curDate.substr(0, 7)) {
                $(this).css("color", "#999999");
              } else if (dateTmp == new Date().format("yyyy-MM-dd")) {
                $(this).attr("class", "tfp-daterange-picker-color");
                $(this).css("color", "");
              } else {
                $(this).css("color", "");
              }
            }
          });
        }
        if (that.dateStartValue) that.dateValue.start = that.dateStartValue;
        that.setDateValue(that.dateValue);
      });
    });

    gridLeftMonth.find(".tfp-daterange-picker-grid-row-month").each(function () {
      $(this).find("div").click(function () {
        $(".tfp-daterange-picker-left .tfp-daterange-picker-grid-row-month").find("div").each(function () {
          let dateTmp = $(this).attr("data-value");

          if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.start).format("yyyy-MM") || new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.end).format("yyyy-MM") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
            $(this).attr("class", "");
            $(this).css("background-color", "");
            if (dateTmp == new Date().format("yyyy-MM")) {
              $(this).attr("class", "tfp-daterange-picker-color");
              $(this).css("color", "");
            } else {
              $(this).css("color", "");
            }
          }
        });
        $(this).attr("class", "tfp-daterange-picker-bgcolor");
        $(this).css("color", "#FFFFFF");
        event.stopPropagation();
        if (that.dateValue.start) {
          that.dateValue.end = $(this).attr("data-value");
        } else {
          that.dateValue.start = $(this).attr("data-value");
          $(".tfp-daterange-picker-right .tfp-daterange-picker-grid-row-month").find("div").each(function () {
            let dateTmp = $(this).attr("data-value");

            if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.start).format("yyyy-MM") || new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.end).format("yyyy-MM") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
              $(this).attr("class", "");
              $(this).css("background-color", "");
              if (dateTmp == new Date().format("yyyy-MM")) {
                $(this).attr("class", "tfp-daterange-picker-color");
                $(this).css("color", "");
              } else {
                $(this).css("color", "");
              }
            }
          });
        }
        if (that.dateStartValue) that.dateValue.end = that.dateStartValue;
        that.setDateValue(that.dateValue);
      });
    });

    gridRightMonth.find(".tfp-daterange-picker-grid-row-month").each(function () {
      $(this).find("div").click(function () {
        $(".tfp-daterange-picker-right .tfp-daterange-picker-grid-row-month").find("div").each(function () {
          let dateTmp = $(this).attr("data-value");

          if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.start).format("yyyy-MM") || new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.end).format("yyyy-MM") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
            $(this).attr("class", "");
            $(this).css("background-color", "");
            if (dateTmp == new Date().format("yyyy-MM")) {
              $(this).attr("class", "tfp-daterange-picker-color");
              $(this).css("color", "");
            } else {
              $(this).css("color", "");
            }
          }
        });
        $(this).attr("class", "tfp-daterange-picker-bgcolor");
        $(this).css("color", "#FFFFFF");
        event.stopPropagation();
        if (that.dateValue.end) {
          that.dateValue.start = $(this).attr("data-value");
        } else {
          that.dateValue.end = $(this).attr("data-value");
          $(".tfp-daterange-picker-left .tfp-daterange-picker-grid-row-month").find("div").each(function () {
            let dateTmp = $(this).attr("data-value");

            if (that.dataModel.value && new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.start).format("yyyy-MM") || new Date(dateTmp).format("yyyy-MM") == new Date(that.dataModel.value.end).format("yyyy-MM") || (new Date(dateTmp) > new Date(that.dataModel.value.start) && new Date(dateTmp) < new Date(that.dataModel.value.end))) {
              $(this).attr("class", "");
              $(this).css("background-color", "");
              if (dateTmp == new Date().format("yyyy-MM")) {
                $(this).attr("class", "tfp-daterange-picker-color");
                $(this).css("color", "");
              } else {
                $(this).css("color", "");
              }
            }
          });
        }
        if (that.dateStartValue) that.dateValue.start = that.dateStartValue;
        that.setDateValue(that.dateValue);
      });
    });
  }

  setDateValue(dateValue) {
    let that = this;
    if (dateValue.start && dateValue.end) {
      let startTime = parseInt(dateValue.start.replace("-", "").replace("-", ""));
      let endTime = parseInt(dateValue.end.replace("-", "").replace("-", ""));
      if (startTime > endTime) {
        let time = dateValue.start;
        dateValue.start = dateValue.end;
        dateValue.end = time;
      }
      $(".tfp-daterange-picker-left").attr("data-value", dateValue.start);
      $(".tfp-daterange-picker-right").attr("data-value", dateValue.end);
      that.value = JSON.stringify(dateValue);
      that.dateStartValue = "";
      that.closePicker();
    }
  }

  quickSetDateValue(start, end) {
    this.dataModel.value = {};
    this.dataModel.value.start = start;
    this.dataModel.value.end = end;
    this._jqObj.find("input").eq(0).val(this.dataModel.value.start);
    this._jqObj.find("input").eq(1).val(this.dataModel.value.end);
    this.dateValue = {};
    this.closePicker();
  }

  toPrevYear(index) {
    if (this.dateValue) {
      if (this.dateValue.start) {
        this.dateStartValue = this.dateValue.start;
      } else if (this.dateValue.end) {
        this.dateStartValue = this.dateValue.end;
      }
    }
    var dateStart = new Date($(".tfp-daterange-picker-left").attr("data-value"));
    var dateEnd = new Date($(".tfp-daterange-picker-right").attr("data-value"));
    if (index < 4) {
      dateStart.setYear(dateStart.getFullYear() - 1);
    } else {
      dateEnd.setYear(dateEnd.getFullYear() - 1);
    }
    this.setDateRangeValue(dateStart, dateEnd);
  }

  toPrevMonth(index) {
    if (this.dateValue) {
      if (this.dateValue.start) {
        this.dateStartValue = this.dateValue.start;
      } else if (this.dateValue.end) {
        this.dateStartValue = this.dateValue.end;
      }
    }
    var dateStart = new Date($(".tfp-daterange-picker-left").attr("data-value"));
    var dateEnd = new Date($(".tfp-daterange-picker-right").attr("data-value"));
    if (index < 4) {
      dateStart.setMonth(dateStart.getMonth() - 1);
    } else {
      dateEnd.setMonth(dateEnd.getMonth() - 1);
    }
    this.setDateRangeValue(dateStart, dateEnd);
  }

  toNextYear(index) {
    if (this.dateValue) {
      if (this.dateValue.start) {
        this.dateStartValue = this.dateValue.start;
      } else if (this.dateValue.end) {
        this.dateStartValue = this.dateValue.end;
      }
    }
    var dateStart = new Date($(".tfp-daterange-picker-left").attr("data-value"));
    var dateEnd = new Date($(".tfp-daterange-picker-right").attr("data-value"));
    if (index < 4) {
      dateStart.setYear(dateStart.getFullYear() + 1);
    } else {
      dateEnd.setYear(dateEnd.getFullYear() + 1);
    }
    this.setDateRangeValue(dateStart, dateEnd);
  }

  toNextMonth(index) {
    if (this.dateValue) {
      if (this.dateValue.start) {
        this.dateStartValue = this.dateValue.start;
      } else if (this.dateValue.end) {
        this.dateStartValue = this.dateValue.end;
      }
    }
    var dateStart = new Date($(".tfp-daterange-picker-left").attr("data-value"));
    var dateEnd = new Date($(".tfp-daterange-picker-right").attr("data-value"));
    if (index < 4) {
      dateStart.setMonth(dateStart.getMonth() + 1);
    } else {
      dateEnd.setMonth(dateEnd.getMonth() + 1);
    }
    this.setDateRangeValue(dateStart, dateEnd);
  }

  getCurDateTime() {
    if (this.showMode == 'monthMode') {
      return (new Date()).format("yyyy-MM");
    } else {
      return (new Date()).format("yyyy-MM-dd");
    }
  }

  getFirst(val) {
    var date = new Date(val);
    date.setDate(1);
    var cTime = new Date(new Date(date).toLocaleDateString()).getTime();
    //将时间戳转换成时间格式
    var date1 = new Date(cTime);
    var year = date1.getFullYear();
    var month = date1.getMonth() + 1;
    var day = date1.getDate();
    month = month < 10 ? "0" + month : month;
    day = day < 10 ? "0" + day : day;
    var ddate = year + '-' + month + '-' + day;
    return ddate;
  }

  //definedTime表示结束时间，days表示往前推的天数
  getDateStart(definedTime, days) {
    let data = days;
    var d = new Date(definedTime);
    let year = d.getFullYear();
    let mon = d.getMonth() + 1;
    let day = d.getDate();
    if (day <= data) {
      if (mon > 1) {
        mon = mon - 1;
      } else {
        year = year - 1;
        mon = 12;
      }
    }
    d.setDate(d.getDate() - data);
    year = d.getFullYear();
    mon = d.getMonth() + 1;
    day = d.getDate();
    let s =
      year +
      "-" +
      (mon < 10 ? "0" + mon : mon) +
      "-" +
      (day < 10 ? "0" + day : day);
    return s
  }

  //definedTime表示开始时间，days表示往后推的天数
  getDateEnd(definedTime, days) {
    let data = days;
    var d = new Date(definedTime);
    let year = d.getFullYear();
    let mon = d.getMonth() + 1;
    let day = d.getDate();
    if (day <= data) {
      if (mon > 1) {
        mon = mon - 1;
      } else {
        year = year - 1;
        mon = 12;
      }
    }
    d.setDate(d.getDate() + data);
    year = d.getFullYear();
    mon = d.getMonth() + 1;
    day = d.getDate();
    let s =
      year +
      "-" +
      (mon < 10 ? "0" + mon : mon) +
      "-" +
      (day < 10 ? "0" + day : day);
    return s
  }

  initRuntime() {
    let that = this;

    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      if ($(".tfp-daterange-picker").length > 0) {
        let cptId = $(".tfp-daterange-picker").attr("data-cptid");
        if (cptId == that.id) return;
        that.closePicker();
      }
      that.showPicker();
      event.stopPropagation();
    });
    if (this.dataModel.defaultNow && !this.dataModel.value) {
      this.quickSetDateValue(this.getCurDateTime(), this.getCurDateTime())
    }
    if (this.dataModel.startDate && this.dataModel.endDate && !this.dataModel.value) {
      this.quickSetDateValue(this.dataModel.startDate, this.dataModel.endDate)
    }
    this._jqObj.find("input").focus(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find("input").blur(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    })
  }
}