export default {
  "name": "DataSet",
  "comment": "可编辑表格",
  "cssFiles": [
    "style.{bgColorMode}.phone.css",
    "../popuplist/style.css"
  ],
  "jsFiles": "../popuplist/index.js",
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "dataSubmitSetting",
          "comment": "数据提交设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataSubmitSetting.tfp",
          "width": "720px",
          "height": "640px"
        }
      ]
    },
    {
      "name": "columns",
      "comment": "输入项设置",
      "type": "Dataset",
      "isPro": true,
      "keyCol": "id",
      "width": "640px",
      "height": "600px",
      "columns": [
        {
          "id": "id",
          "name": "输入项ID",
          "type": "String",
          "required": true
        },
        {
          "id": "name",
          "name": "输入项名称",
          "type": "String"
        },
        {
          "id": "type",
          "name": "输入项类型",
          "type": "Select",
          "default": "text",
          "options": [
            {
              "value": "text",
              "text": "单行输入框"
            },
            {
              "value": "select",
              "text": "下拉列表"
            },
            {
              "value": "switch",
              "text": "开关"
            },
            {
              "value": "date",
              "text": "日期"
            },
            {
              "value": "datetime",
              "text": "日期时间"
            },
            {
              "value": "password",
              "text": "密码"
            }
          ]
        },
        {
          "id": "dataType",
          "name": "数据类型",
          "type": "Select",
          "default": "text",
          "options": [
            {
              "value": "text",
              "text": "文本"
            },
            {
              "value": "int",
              "text": "整数"
            },
            {
              "value": "float",
              "text": "小数"
            },
            {
              "value": "money",
              "text": "金额"
            },
            {
              "value": "date",
              "text": "日期"
            },
            {
              "value": "time",
              "text": "时间"
            },
            {
              "value": "datetime",
              "text": "日期时间"
            }
          ]
        },
        {
          "id": "proportion",
          "name": "比例",
          "type": "String",
          "default": "1:2"
        },
        {
          "id": "default",
          "name": "默认值",
          "type": "String"
        },
        {
          "id": "readonly",
          "name": "只读",
          "type": "Switch"
        },
        {
          "id": "required",
          "name": "必填",
          "type": "Switch"
        },
        {
          "id": "hidden",
          "name": "隐藏",
          "type": "Switch"
        },
        {
          "id": "options",
          "name": "可选值（多个值以英文逗号分隔，例如：a,b,c）",
          "type": "String",
          "wrap": true,
          "hidden": "('{type}'.toLowerCase()!='checkbox' && '{type}'.toLowerCase()!='radio' && '{type}'.toLowerCase()!='select' && '{type}'.toLowerCase()!='popuplist')"
        },
        {
          "id": "options",
          "name": "选项",
          "type": "SwitchOptions",
          "wrap": true,
          "hidden": "('{type}'.toLowerCase()!='switch')"
        },
        {
          "id": "formula",
          "name": "自动计算表达式",
          "type": "String",
          "wrap": true
        },
        {
          "id": "style",
          "name": "CSS样式",
          "type": "String",
          "wrap": true
        },
        {
          "id": "loadDataListService",
          "name": "可选项数据加载服务",
          "type": "Service"
        },
        {
          "id": "dataListBindingMember",
          "name": "可选项数据绑定成员",
          "type": "String"
        },
        {
          "id": "dataListValueFormat",
          "name": "选项值数据格式",
          "type": "String"
        },
        {
          "id": "dataListTextFormat",
          "name": "选项文本数据格式",
          "type": "String"
        }
      ]
    },
    {
      "name": "titleName",
      "comment": "标题文本",
      "type": "String",
      "default": "表格"
    },
    {
      "name": "showAddButton",
      "comment": "显示添加按钮",
      "type": "Switch",
      "default": true
    },
    {
      "name": "addButtonText",
      "comment": "添加按钮文本",
      "type": "String",
      "default": "添加"
    },
    {
      "name": "enableInsert",
      "comment": "允许插入",
      "type": "Switch",
      "default": true
    },
    {
      "name": "enableMove",
      "comment": "允许更改位置",
      "type": "Switch",
      "default": true
    },
    {
      "name": "enableDelete",
      "comment": "允许删除",
      "type": "Switch",
      "default": true
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onCellDataChange",
      "comment": "单元格数据发生变化时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellClick",
      "comment": "单击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellDblClick",
      "comment": "双击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellFocus",
      "comment": "单元格获得焦点时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellBlur",
      "comment": "单元格失去焦点时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellKeyPress",
      "comment": "单元格按键时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    }
  ],
  "methods": [
    {
      "name": "getRowsData",
      "comment": "获得所有行的数据集合",
      "args": [
        {
          "name": "options",
          "comment": "选项",
          "type": "Object"
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "rows",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getRowData",
      "comment": "获得指定行的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "data",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getCellData",
      "comment": "获得指定单元格的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "data",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "bindData",
      "comment": "绑定数据",
      "args": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "loadData",
      "comment": "加载数据"
    },
    {
      "name": "submit",
      "comment": "提交数据",
      "args": [
        {
          "name": "options",
          "comment": "选项",
          "type": "Object"
        }
      ]
    }
  ]
}