export default {
  "name": "DataSet",
  "comment": "可编辑表格",
  "cssFiles": "style.{bgColorMode}.pc.css",
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "dataSubmitSetting",
          "comment": "数据提交设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataSubmitSetting.tfp",
          "width": "720px",
          "height": "640px"
        }
      ]
    },
    {
      "name": "buttonListSetting",
      "comment": "按钮栏设置",
      "type": "group",
      "items": [
        {
          "name": "showAddButton",
          "comment": "显示添加按钮",
          "type": "Switch",
          "default": true
        },
        {
          "name": "addButtonText",
          "comment": "添加按钮文本",
          "type": "String",
          "default": "添加"
        },
        {
          "name": "showAddFromDialogButton",
          "comment": "显示弹窗选择按钮",
          "type": "Switch"
        },
        {
          "name": "addFromDialogButtonText",
          "comment": "弹窗选择按钮文本",
          "type": "String",
          "default": "弹窗选择"
        },
        {
          "name": "addFromDialogPath",
          "comment": "弹窗页面路径",
          "type": "PathPicker",
          "fileTypes": ["html", "tfp"]
        },
        {
          "name": "addFromDialogWidth",
          "comment": "弹窗宽度",
          "type": "Int",
          "default": 640
        },
        {
          "name": "addFromDialogHeight",
          "comment": "弹窗高度",
          "type": "Int",
          "default": 480
        }
      ]
    },
    {
      "name": "toolBarSetting",
      "comment": "工具栏设置",
      "type": "group",
      "items": [
        {
          "name": "enableInsert",
          "comment": "允许插入",
          "type": "Switch",
          "default": true
        },
        {
          "name": "enableMove",
          "comment": "允许更改位置",
          "type": "Switch",
          "default": true
        },
        {
          "name": "enableClear",
          "comment": "允许清空",
          "type": "Switch",
          "default": true
        },
        {
          "name": "enableDelete",
          "comment": "允许删除",
          "type": "Switch",
          "default": true
        },
        {
          "name": "showDelRowConfirm",
          "comment": "显示删除确认对话框",
          "type": "Switch",
          "default": false
        }
      ]
    },
    {
      "name": "tableSetting",
      "comment": "表格设置",
      "type": "group",
      "items": [
        {
          "name": "columns",
          "comment": "表格列设置",
          "type": "Dataset",
          "isPro": true,
          "keyCol": "id",
          "width": "640px",
          "height": "600px",
          "columns": [
            {
              "id": "id",
              "name": "列ID",
              "type": "String",
              "required": true
            },
            {
              "id": "name",
              "name": "列名",
              "type": "String"
            },
            {
              "id": "type",
              "name": "输入项类型",
              "type": "Select",
              "default": "text",
              "resetDisplay": true,
              "options": [
                {
                  "value": "text",
                  "text": "单行输入框"
                },
                {
                  "value": "textarea",
                  "text": "多行输入框"
                },
                {
                  "value": "select",
                  "text": "下拉列表"
                },
                {
                  "value": "popuplist",
                  "text": "弹出列表"
                },
                {
                  "value": "switch",
                  "text": "开关"
                },
                {
                  "value": "checkbox",
                  "text": "多选"
                },
                {
                  "value": "radio",
                  "text": "单选"
                },
                {
                  "value": "dep",
                  "text": "部门"
                },
                {
                  "value": "user",
                  "text": "用户"
                },
                {
                  "value": "date",
                  "text": "日期"
                },
                {
                  "value": "time",
                  "text": "时间"
                },
                {
                  "value": "datetime",
                  "text": "日期时间"
                },
                // {
                //   "value": "button",
                //   "text": "按钮"
                // },
                // {
                //   "value": "label",
                //   "text": "标题"
                // },
                {
                  "value": "password",
                  "text": "密码"
                },
                {
                  "value": "datadic",
                  "text": "数据字典"
                },
                {
                  "value": "encodingrule",
                  "text": "编码规则"
                },
                // {
                //   "value": "photoupload",
                //   "text": "图片"
                // },
                // {
                //   "value": "fileupload",
                //   "text": "文件"
                // }
                // ,{
                //   "value": "sign",
                //   "text": "签章"
                // },
                // {
                //   "value": "countersign",
                //   "text": "会签"
                // }
              ]
            },
            {
              "id": "dataType",
              "name": "数据类型",
              "type": "Select",
              "default": "text",
              "options": [
                {
                  "value": "text",
                  "text": "文本"
                },
                {
                  "value": "int",
                  "text": "整数"
                },
                {
                  "value": "float",
                  "text": "小数"
                },
                {
                  "value": "money",
                  "text": "金额"
                },
                {
                  "value": "date",
                  "text": "日期"
                },
                {
                  "value": "time",
                  "text": "时间"
                },
                {
                  "value": "datetime",
                  "text": "日期时间"
                }
              ]
            },
            {
              "id": "width",
              "name": "宽度",
              "type": "Size"
            },
            {
              "id": "default",
              "name": "默认值",
              "type": "String"
            },
            {
              "id": "align",
              "name": "水平对齐方式",
              "type": "Select",
              "default": "left",
              "hidden": "'{type}'!='text'",
              "options": [
                {
                  "value": "left",
                  "text": "左对齐"
                },
                {
                  "value": "center",
                  "text": "居中对齐"
                },
                {
                  "value": "right",
                  "text": "右对齐"
                }
              ]
            },
            {
              "id": "readonly",
              "name": "只读",
              "type": "Switch"
            },
            {
              "id": "required",
              "name": "必填",
              "type": "Switch"
            },
            {
              "id": "hidden",
              "name": "隐藏",
              "type": "Switch"
            },
            {
              "id": "multiCheck",
              "name": "多选",
              "type": "Switch",
              "hidden": "('{type}'.toLowerCase()!='user' && '{type}'.toLowerCase()!='dep' && '{type}'.toLowerCase()!='popuplist')"
            },
            {
              "id": "options",
              "name": "可选值",
              "type": "Dataset",
              "hidden": "('{type}'.toLowerCase()!='switch' && '{type}'.toLowerCase()!='checkbox' && '{type}'.toLowerCase()!='radio' && '{type}'.toLowerCase()!='select' && '{type}'.toLowerCase()!='popuplist')"
            },
            {
              "id": "dataQuerySetting",
              "name": "数据查询设置",
              "type": "DataQuerySetting",
              "hidden": "('{type}'!='select' && '{type}'!='popuplist' && '{type}'.toLowerCase()!='checkbox' && '{type}'.toLowerCase()!='radio')"
            },
            {
              "id": "dataListValueFormat",
              "name": "选项值数据格式",
              "type": "String",
              "hidden": "('{type}'!='select' && '{type}'!='popuplist' && '{type}'.toLowerCase()!='checkbox' && '{type}'.toLowerCase()!='radio')"
            },
            {
              "id": "dataListTextFormat",
              "name": "选项文本数据格式",
              "type": "String",
              "hidden": "('{type}'!='select' && '{type}'!='popuplist' && '{type}'.toLowerCase()!='checkbox' && '{type}'.toLowerCase()!='radio')"
            },
            {
              "id": "verify",
              "name": "文本格式验证设置",
              "type": "Verify",
              "hidden": "('{type}'.toLowerCase()!='text' && '{type}'.toLowerCase()!='textarea')"
            },
            {
              "id": "orgDataType",
              "name": "组织结构数据类型",
              "type": "Select",
              "default": "id",
              "hidden": "('{type}'!='dep' && '{type}'!='user' && '{type}'!='role')",
              "options": [
                {
                  "value": "id",
                  "text": "编号"
                },
                {
                  "value": "code",
                  "text": "编码"
                },
                {
                  "value": "name",
                  "text": "名称"
                },
                {
                  "value": "object",
                  "text": "JSON对象"
                }
              ]
            },
            {
              "id": "showSecond",
              "name": "显示秒",
              "type": "Switch",
              "hidden": "('{type}'.toLowerCase()!='datetime')"
            },
            {
              "id": "dataDicCode",
              "name": "数据字典编码",
              "type": "DataDic",
              "hidden": "('{type}'.toLowerCase()!='datadic')"
            },
            {
              "id": "encodingRuleCode",
              "name": "编码规则代码",
              "type": "EncodingRule",
              "hidden": "('{type}'.toLowerCase()!='encodingrule')"
            },
            {
              "id": "appCode",
              "name": "应用代码",
              "type": "String",
              "hidden": "('{type}'.toLowerCase()!='photoupload' && '{type}'.toLowerCase()!='fileupload')"
            },
            {
              "id": "appDataId",
              "name": "应用数据ID",
              "type": "String",
              "hidden": "('{type}'.toLowerCase()!='photoupload' && '{type}'.toLowerCase()!='fileupload')"
            },
            {
              "id": "size",
              "name": "文件总数",
              "type": "Number",
              "hidden": "('{type}'.toLowerCase()!='photoupload' && '{type}'.toLowerCase()!='fileupload')"
            },
            {
              "id": "dataListDivWidth",
              "name": "可选项列表宽度",
              "type": "Int",
              "default": "480",
              "hidden": "'{type}'!='popuplist'"
            },
            {
              "id": "dataListDivHeight",
              "name": "可选项列表高度",
              "type": "Int",
              "default": "320",
              "hidden": "'{type}'!='popuplist'"
            },
            {
              "id": "enableFilter",
              "name": "启用智能筛选",
              "type": "Switch",
              "hidden": "'{type}'!='popuplist'"
            },
            {
              "id": "filterArgName",
              "name": "筛选时传给后台的参数名",
              "type": "String",
              "default": "keyword",
              "hidden": "'{type}'!='popuplist'"
            },
            {
              "id": "showTable",
              "name": "弹出数据表格",
              "type": "Switch",
              "hidden": "'{type}'!='popuplist'",
              "resetDisplay": true,
            },
            {
              "id": "showRowNum",
              "name": "显示序号",
              "type": "Switch",
              "hidden": "'{showTable}'!='true'",
              "default": true
            },
            {
              "id": "allowPaging",
              "name": "允许翻页",
              "type": "Switch",
              "hidden": "'{showTable}'!='true'",
              "default": true
            },
            {
              "id": "pageSize",
              "name": "每页显示数量",
              "type": "Select",
              "hidden": "'{showTable}'!='true'",
              "options": [
                {
                  "value": "20",
                  "text": "20"
                },
                {
                  "value": "30",
                  "text": "30"
                },
                {
                  "value": "50",
                  "text": "50"
                },
                {
                  "value": "100",
                  "text": "100"
                },
                {
                  "value": "200",
                  "text": "200"
                },
                {
                  "value": "300",
                  "text": "300"
                },
                {
                  "value": "500",
                  "text": "500"
                }
              ]
            },
            {
              "id": "rowHeight",
              "name": "行高",
              "type": "Number",
              "default": "45",
              "hidden": "'{showTable}'!='true'"
            },
            {
              "id": "columns",
              "name": "数据表格列设置",
              "type": "DataSet",
              "isPro": true,
              "keyCol": "id",
              "width": "640px",
              "height": "600px",
              "hidden": "'{showTable}'!='true'",
              "columns": [
                {
                  "id": "name",
                  "name": "列标题",
                  "type": "String"
                },
                {
                  "id": "width",
                  "name": "宽度",
                  "type": "Size"
                },
                {
                  "id": "fill",
                  "name": "宽度弹性伸缩",
                  "type": "Switch"
                },
                {
                  "id": "fixed",
                  "name": "固定在列表左侧",
                  "type": "Switch"
                },
                {
                  "id": "fixedOnRight",
                  "name": "固定在列表右侧",
                  "type": "Switch"
                },
                {
                  "id": "bold",
                  "name": "文字加粗",
                  "type": "Switch"
                },
                {
                  "id": "color",
                  "name": "文字颜色",
                  "type": "Color"
                },
                {
                  "id": "align",
                  "name": "水平对齐方式",
                  "type": "Select",
                  "default": "center",
                  "options": [
                    {
                      "value": "left",
                      "text": "左对齐"
                    },
                    {
                      "value": "center",
                      "text": "居中对齐"
                    },
                    {
                      "value": "right",
                      "text": "右对齐"
                    }
                  ]
                },
                {
                  "id": "dataFormat",
                  "name": "内容格式",
                  "type": "Select",
                  "default": "text",
                  "options": [
                    {
                      "value": "text",
                      "text": "文本"
                    },
                    {
                      "value": "int",
                      "text": "整数"
                    },
                    {
                      "value": "decimal",
                      "text": "小数"
                    },
                    {
                      "value": "filesize",
                      "text": "文件大小：xxxKB,xxxMB,xxxGB,xxxTB"
                    },
                    {
                      "value": "money|0.00",
                      "text": "金额：0.00"
                    },
                    {
                      "value": "money|0,000.00",
                      "text": "金额：0,000.00"
                    },
                    {
                      "value": "week",
                      "text": "星期：X"
                    },
                    {
                      "value": "week|星期",
                      "text": "星期：星期X"
                    },
                    {
                      "value": "date|yyyy",
                      "text": "年份：yyyy"
                    },
                    {
                      "value": "date|MM",
                      "text": "月份：MM"
                    },
                    {
                      "value": "date|yyyy-MM",
                      "text": "年月：yyyy-MM"
                    },
                    {
                      "value": "date|yyyy/MM",
                      "text": "年月：yyyy/MM"
                    },
                    {
                      "value": "date|yyyy-MM-dd",
                      "text": "日期：yyyy-MM-dd"
                    },
                    {
                      "value": "date|yyyy/MM/dd",
                      "text": "日期：yyyy/MM/dd"
                    },
                    {
                      "value": "date|yyyy年MM月dd日",
                      "text": "日期：yyyy年MM月dd日"
                    },
                    {
                      "value": "date|MM-dd",
                      "text": "日期：MM-dd"
                    },
                    {
                      "value": "date|MM/dd",
                      "text": "日期：MM/dd"
                    },
                    {
                      "value": "date|MM月dd日",
                      "text": "日期：MM月dd日"
                    },
                    {
                      "value": "date|dd",
                      "text": "日期：dd"
                    },
                    {
                      "value": "time|HH:mm",
                      "text": "时间：HH:mm"
                    },
                    {
                      "value": "time|HH:mm:ss",
                      "text": "时间：HH:mm:ss"
                    },
                    {
                      "value": "time|HH时mm分",
                      "text": "时间：HH时mm分"
                    },
                    {
                      "value": "time|HH时mm分ss秒",
                      "text": "时间：HH时mm分ss秒"
                    },
                    {
                      "value": "datetime|yyyy-MM-dd HH:mm",
                      "text": "日期时间：yyyy-MM-dd HH:mm"
                    },
                    {
                      "value": "datetime|yyyy-MM-dd HH:mm:ss",
                      "text": "日期时间：yyyy-MM-dd HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy/MM/dd HH:mm",
                      "text": "日期时间：yyyy/MM/dd HH:mm"
                    },
                    {
                      "value": "datetime|yyyy/MM/dd HH:mm:ss",
                      "text": "日期时间：yyyy/MM/dd HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH:mm",
                      "text": "日期时间：yyyy年MM月dd日 HH:mm"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH:mm:ss",
                      "text": "日期时间：yyyy年MM月dd日 HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH时mm分",
                      "text": "日期时间：yyyy年MM月dd日 HH时mm分"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH时mm分ss秒",
                      "text": "日期时间：yyyy年MM月dd日 HH时mm分ss秒"
                    }
                  ]
                },
                {
                  "id": "decimalCalcReg",
                  "name": "小数取值规则",
                  "type": "Select",
                  "default": "",
                  "options": [
                    {
                      "value": "",
                      "text": "不处理"
                    },
                    {
                      "value": "trunc",
                      "text": "取整"
                    },
                    {
                      "value": "round",
                      "text": "四舍五入"
                    },
                    {
                      "value": "ceil",
                      "text": "向上取整"
                    },
                    {
                      "value": "floor",
                      "text": "向下取整"
                    },
                    {
                      "value": "toFixed",
                      "text": "固定精度"
                    },
                    {
                      "value": "toPrecision",
                      "text": "固定长度"
                    },
                    {
                      "value": "abs",
                      "text": "求绝对值"
                    }
                  ]
                },
                {
                  "id": "decimalLength",
                  "name": "小数位数",
                  "type": "Number"
                },
                {
                  "id": "format",
                  "name": "数据绑定表达式",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "class",
                  "name": "CSS样式类",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "style",
                  "name": "CSS样式",
                  "type": "String",
                  "wrap": true
                }
              ]
            },
            {
              "id": "inputs",
              "name": "表格数据关联列设置",
              "type": "Dataset",
              "hidden": "'{showTable}'!='true'",
              "columns": [
                {
                  "id": "inputId",
                  "name": "列ID",
                  "type": "String",
                  "width": "150px",
                  "required": true
                },
                {
                  "id": "fieldName",
                  "name": "字段名",
                  "type": "String",
                  "width": "360px",
                  "required": true
                }
              ]
            },
            {
              "id": "formula",
              "name": "自动计算表达式",
              "type": "String",
              "wrap": true
            }
          ]
        },
        {
          "name": "keyCol",
          "comment": "主键列",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "rowHeight",
          "comment": "数据行高度",
          "type": "Int"
        },
        {
          "name": "showRowNum",
          "comment": "显示行号",
          "type": "Switch"
        },
        {
          "name": "showCheckbox",
          "comment": "显示选择框",
          "type": "Switch"
        },
        {
          "name": "showMoveButton",
          "comment": "显示移动按钮",
          "type": "Switch"
        },
        {
          "name": "showDelButton",
          "comment": "显示删除按钮",
          "type": "Switch"
        },
        {
          "name": "enterKeyMode",
          "comment": "回车键处理方式",
          "type": "Select",
          "default": "right",
          "options": [
            {
              "value": "right",
              "text": "移动到右侧单元格"
            },
            {
              "value": "down",
              "text": "移动到下侧单元格"
            }
          ]
        },
        {
          "name": "enterKeyAddRow",
          "comment": "回车创建新行",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "200px",
    "position": "relative",
    "left": 0,
    "top": 0
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    },
    {
      "name": "onAfterBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "data",
          "comment": "绑定的数据",
          "type": "Array"
        }
      ]
    },
    {
      "name": "onAfterSubmit",
      "comment": "提交数据后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "res",
          "comment": "响应数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onBeforeAddRow",
      "comment": "添加行前",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object"
        }
      ]
    }, {
      "name": "onAfterAddRow",
      "comment": "添加行后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onBeforeRemoveRow",
      "comment": "删除行前",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onAfterRemoveRow",
      "comment": "删除行后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellDataChange",
      "comment": "单元格数据发生变化时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellClick",
      "comment": "单击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellDblClick",
      "comment": "双击单元格时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellFocus",
      "comment": "单元格获得焦点时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellBlur",
      "comment": "单元格失去焦点时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onCellKeyPress",
      "comment": "单元格按键时",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        },
        {
          "name": "cellData",
          "comment": "单元格数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "onAfterCheckedAll",
      "comment": "全选后",
      "isNotHtmlEvent": true,
      "args": []
    },
    {
      "name": "onAfterUnCheckedAll",
      "comment": "取消全选后",
      "isNotHtmlEvent": true,
      "args": []
    },
    {
      "name": "onAfterCheckedRow",
      "comment": "选中行后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "onAfterUnCheckedRow",
      "comment": "取消选中行后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "onAfterMoveRow",
      "comment": "移动行位置后",
      "isNotHtmlEvent": true,
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int"
        }
      ]
    }
  ],
  "methods": [
    {
      "name": "addRow",
      "comment": "添加行",
      "args": [
        {
          "name": "data",
          "comment": "行数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "addRows",
      "comment": "添加多行",
      "args": [
        {
          "name": "rows",
          "comment": "数据集合",
          "type": "Array"
        }
      ]
    },
    {
      "name": "bindData",
      "comment": "绑定数据",
      "args": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "checkAll",
      "comment": "选择所有行"
    },
    {
      "name": "checkRowsByIndex",
      "comment": "选中指定索引所在的行",
      "args": [
        {
          "name": "indexs",
          "comment": "要选中的行索引",
          "type": "Array",
          "required": true
        }
      ]
    },
    {
      "name": "checkRow",
      "comment": "选中指定索引的行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "要选中的行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "checkRowsByKey",
      "comment": "选中指定主键值所在的行",
      "args": [
        {
          "name": "keys",
          "comment": "要选中的键值",
          "type": "Array",
          "required": true
        }
      ]
    },
    {
      "name": "unCheckRowsByIndex",
      "comment": "取消选中指定索引所在的行",
      "args": [
        {
          "name": "indexs",
          "comment": "要选中的行索引",
          "type": "Array",
          "required": true
        }
      ]
    },
    {
      "name": "unCheckRow",
      "comment": "取消选中指定索引的行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "要选中的行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "getCellData",
      "comment": "获得指定单元格的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "data",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getCellEl",
      "comment": "获得指定单元格的jquery对象",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "cell",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getCheckedRows",
      "comment": "获得选中的行",
      "haveCbFunc": true,
      "cbArgs": [
        {
          "name": "rows",
          "comment": "行对象集合",
          "type": "Array"
        }
      ]
    },
    {
      "name": "getCheckedRowsData",
      "comment": "获得选中行的数据",
      "haveCbFunc": true,
      "cbArgs": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Array"
        }
      ]
    },
    {
      "name": "getRowData",
      "comment": "获得指定行的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Object"
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "data",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getRowEL",
      "comment": "获得指定行的jquery对象",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "row",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getRowsData",
      "comment": "获得所有行的数据集合",
      "haveCbFunc": true,
      "args": [
        {
          "name": "options",
          "comment": "选项",
          "type": "Object"
        }
      ],
      "cbArgs": [
        {
          "name": "rowsData",
          "comment": "数据",
          "type": "Array"
        }
      ]
    },
    {
      "name": "getRowsEl",
      "comment": "获得所有行的jQuery对象集合",
      "args": [
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "rows",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "getCheckedRowsEl",
      "comment": "获得选中行的jQuery对象集合",
      "args": [
        {
          "name": "retVarName",
          "comment": "返回给",
          "type": "varList",
          "width": "100px",
          "default": "rows",
          "required": true,
          "isOnlyStr": true
        }
      ]
    },
    {
      "name": "loadData",
      "comment": "加载数据"
    },
    {
      "name": "setCellData",
      "comment": "设置指定单元格的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "val",
          "comment": "单元格数据",
          "type": "String"
        }
      ]
    },
    {
      "name": "setRowData",
      "comment": "设置指定行的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "setColData",
      "comment": "设置指定列的数据",
      "args": [
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "data",
          "comment": "列数据",
          "type": "Object"
        }
      ]
    },
    {
      "name": "unCheckAll",
      "comment": "取消全选"
    },
    {
      "name": "removeRow",
      "comment": "删除行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "removeAll",
      "comment": "删除所有行"
    },
    {
      "name": "clearCellData",
      "comment": "清空指定单元格的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "clearRowData",
      "comment": "清空指定行的数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "clearColData",
      "comment": "清空指定列的数据",
      "args": [
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "clearRangeData",
      "comment": "清空指定区域内的数据",
      "args": [
        {
          "name": "startRowIndex",
          "comment": "起始行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "startColIndex",
          "comment": "起始列索引",
          "type": "Int"
        },
        {
          "name": "endRowIndex",
          "comment": "结束行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "endColIndex",
          "comment": "结束列索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "clearAllData",
      "comment": "删除所有数据"
    },
    {
      "name": "disableCell",
      "comment": "禁用指定单元格",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "disableRow",
      "comment": "禁用指定行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "disableCol",
      "comment": "禁用指定列",
      "args": [
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "disableRange",
      "comment": "禁用指定区域",
      "args": [
        {
          "name": "startRowIndex",
          "comment": "起始行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "startColIndex",
          "comment": "起始列索引",
          "type": "Int"
        },
        {
          "name": "endRowIndex",
          "comment": "结束行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "endColIndex",
          "comment": "结束列索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "disableAll",
      "comment": "禁用所有行"
    },
    {
      "name": "enableCell",
      "comment": "启用指定单元格",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "enableRow",
      "comment": "启用指定行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "enableCol",
      "comment": "启用指定列",
      "args": [
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "enableRange",
      "comment": "启用指定区域",
      "args": [
        {
          "name": "startRowIndex",
          "comment": "起始行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "startColIndex",
          "comment": "起始列索引",
          "type": "Int"
        },
        {
          "name": "endRowIndex",
          "comment": "结束行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "endColIndex",
          "comment": "结束列索引",
          "type": "Int"
        }
      ]
    },
    {
      "name": "enableAll",
      "comment": "启用所有行"
    },
    {
      "name": "selectRow",
      "comment": "选中指定行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "selectCell",
      "comment": "选中指定单元格",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        }
      ]
    }
  ]
}