import { VisibleComponent } from "../controller.js";

/**
 * 可编辑表格
 * @param {[type]} dataModel [description]
 */
export default class DataSet extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "DataSet", dataModel, parent);

    if (this._tfp.isDesigning && (!this.dataModel.columns || this.dataModel.columns.length == 0)) {
      //默认创建3行
      this.dataModel.columns = [{
        id: "input1",
        name: "输入项1",
        type: "text",
        proportion: "1:2"
      }, {
        id: "input2",
        name: "输入项2",
        type: "text",
        proportion: "1:2"
      }, {
        id: "input3",
        name: "输入项3",
        type: "text",
        proportion: "1:2"
      }];
    }
  }

  //属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get columns() { return this.dataModel.columns }
  set columns(value) {
    this.dataModel.columns = value;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get rows() { return this.getRowsData({ checkRequired: false }); }
  set rows(value) {
    this.dataModel.rows = value;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get showAddButton() { return this.dataModel.showAddButton }
  set showAddButton(value) {
    this.dataModel.showAddButton = value ? true : false;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get addButtonText() {
    if (!this.dataModel.addButtonText) this.dataModel.addButtonText = "添加";
    return this.dataModel.addButtonText;
  }
  set addButtonText(value) {
    this.dataModel.addButtonText = value;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get enableInsert() { return this.dataModel.enableInsert ? true : false }
  set enableInsert(value) {
    this.dataModel.enableInsert = value ? true : false;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get enableDelete() { return this.dataModel.enableDelete ? true : false }
  set enableDelete(value) {
    this.dataModel.enableDelete = value ? true : false;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get enableMove() { return this.dataModel.enableMove ? true : false }
  set enableMove(value) {
    this.dataModel.enableMove = value ? true : false;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  get titleName() { return this.dataModel.titleName }
  set titleName(value) {
    this.dataModel.titleName = value;
    if (this._jqObj) {
      this.reRenderBody();
    }
  }

  reRenderBody() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
  }

  getBodyHtml() {
    const { id, rows = [], titleName, showAddButton, addButtonText, enableInsert } = this.dataModel;
    const iconPath = this._tfp.rootPath + "/src/components/dataset/images/";

    // 设计时添加一行
    if (this._tfp.isDesigning) rows.push({});

    let html = `
      <div class="tfp-dataset-toolbar">
        <div class="tfp-dataset-title">${titleName || id}</div>
        <div class="tfp-dataset-tool">
          <div class="tfp-dataset-button-insert" style="${enableInsert ? '' : 'display:none'}"><img src="${iconPath}add-blue-24.png"/></div>
        </div>
      </div>
    `;

    rows.forEach((row, index) => {
      html += this.getRowHtml(index, row);
    });

    html += `<div class="tfp-dataset-button" style="${showAddButton ? '' : 'display:none'}">
      <div class="tfp-dataset-button-add">${addButtonText}</div>
    </div>`;
    return html;
  }

  getRowHtml(rowIndex, rowData) {
    if (typeof rowData !== 'object') rowData = {};
    const { id, titleName, columns, enableInsert = false, enableMove = false, enableDelete = false } = this.dataModel;
    const iconPath = this._tfp.rootPath + "/src/components/dataset/images/";
    const html = $(`
      <div class="tfp-dataset-row">
        <div class="tfp-dataset-row-header">
          <div class="tfp-dataset-row-header-title">${titleName || id}(${rowIndex + 1})</div>
          <div class="tfp-dataset-row-header-btns">
            <div class="tfp-dataset-button-insert"><img src="${iconPath}add-blue-24.png"/></div>
            <div class="tfp-dataset-button-moveUp"><img src="${iconPath}up-blue-24.png"/></div>
            <div class="tfp-dataset-button-moveDown"><img src="${iconPath}down-blue-24.png"/></div>
            <div class="tfp-dataset-button-delete"><img src="${iconPath}delete-blue-24.png"/></div>
          </div>
        </div>
      </div>
    `);

    if (!enableInsert) html.find('.tfp-dataset-button-insert').remove();
    if (!enableMove) html.find('.tfp-dataset-button-moveUp,.tfp-dataset-button-moveDown').remove();
    if (!enableDelete) html.find('.tfp-dataset-button-delete').remove();

    (columns || []).forEach((_input, index) => {
      const input = { ..._input };
      const item = $(`
        <div class="tfp-dataset-item">
          <div class="tfp-dataset-item-left" style="flex-basis:50%;"><label>${input.name || input.id}</label></div>
          <div class="tfp-dataset-item-right" style="flex-basis:50%;"></div>
        </div>
      `);
      const itemLeft = item.find('.tfp-dataset-item-left');
      const itemright = item.find('.tfp-dataset-item-right');

      // 组件值
      const cellValue = (() => {
        if (rowData[input.id]) return rowData[input.id];
        if (!input.default) return '';
        switch (input.dataType) {
          case 'int': return parseInt(input.default);
          case 'float': return parseFloat(input.default);
          case 'money': return this._tfp.formatMoney(input.default);
          case 'date': return this._tfp.formatDate(input.default, "yyyy-MM-dd");
          case 'time': return this._tfp.formatDate(input.default, "HH:mm:ss");
          case 'datetime': return this._tfp.formatDate(input.default, "yyyy-MM-dd HH:mm:ss");
        }
        return '';
      })();

      // 比例
      if (input.proportion) {
        const separator = ":";
        const proportionLeft = parseFloat(input.proportion.slice(0, input.proportion.indexOf(separator)));
        const proportionRight = parseFloat(input.proportion.slice(input.proportion.indexOf(separator) + 1));
        itemLeft.css('flex-basis', `calc(100% / ${proportionLeft + proportionRight} * ${proportionLeft})`);
        itemright.css('flex-basis', `calc(100% / ${proportionLeft + proportionRight} * ${proportionRight})`);
      }

      // 隐藏
      if (input.hidden) item.hide();

      // 添加控件
      const cptId = `${this.id}_${input.type.toLowerCase()}_${index}`;
      switch (input.type.toLowerCase()) {
        case 'date':
        case 'time':
        case 'datetime':
          const datetimeCpt = $(`<input type="text" readonly inpId="${input.id}">`);
          if (!this._tfp.isDesigning) datetimeCpt.attr('onclick', `${this.id}.dateOnClick(this)`);
          if (cellValue) datetimeCpt.attr('value', cellValue);
          itemright.append(datetimeCpt);
          break;
        case 'switch':
          itemright.css('text-align', 'right');
          if (input.readonly) {
            const switchCpt = $(`<input type="text" style="background-color:#eeeeee;" disabled inpId="${input.id}">`);
            if (cellValue) switchCpt.val(cellValue);
            itemright.append(switchCpt);
          }
          else {
            const switchCpt = $(`<div class="switch" value="${cellValue}" inpId="${input.id}"><div></div></div>`);
            if (!this._tfp.isDesigning) switchCpt.attr('onclick', `${this.id}.switchOnClick(this)`);
            itemright.append(switchCpt);
            const enable = cellValue == true || cellValue == 'true' || (input.options && cellValue == input.options[1]);
            if (enable) switchCpt.find('div').css({ 'float': 'right', 'background-color': '#0099ff' });
            itemright.append(switchCpt);
          }
          break;
        case 'select':
          const selectCpt = $(`<input type="text" readonly inpId="${input.id}">`);
          if (input.style) selectCpt.attr('style', input.style);
          if (!this._tfp.isDesigning) selectCpt.attr('onclick', `${this.id}.selectOnClick(this)`);
          if (cellValue) {
            selectCpt.attr('value', cellValue).attr('data-value', cellValue);
            if (input.options) {
              for (let i = 0; i < input.options.length; i++) {
                const option = input.options[i];
                if (option.value == cellValue) {
                  selectCpt.attr('value', option.text).attr('data-value', option.value);
                  break;
                }
              }
            }
          }
          itemright.append(selectCpt);
          break;
        case 'text':
        case 'password':
          let iptType = input.type.toLowerCase();
          if(input.dataType=="int"||input.dataType=="float"||input.dataType=="money") iptType = "number";
          const textCpt = $(`<input type="${iptType}" inpId="${input.id}" value="${cellValue}">`);
          if (input.style) textCpt.attr('style', input.style);
          if (this._tfp.isDesigning || input.readonly) textCpt.attr('readonly', '');
          if (cellValue) textCpt.val(cellValue);
          itemright.append(textCpt);
          break;
        case 'textarea':
          const textareaCpt = $(`<textarea inpId="${input.id}"></textarea>`);
          if (input.style) textareaCpt.attr('style', input.style);
          if (this._tfp.isDesigning || input.readonly) textareaCpt.attr('readonly', '');
          if (cellValue) textareaCpt.html(cellValue);
          itemright.append(textareaCpt);
          break;
        case 'radio':
          const radioCpt = $(`<div class="radio" inpId="${input.id}"></div>`);
          if (input.options) {
            input.options.forEach(option => {
              const radio = $('<div class="radioitem"><div style="display: none"></div></div>');
              const label = $('<label></label>');
              if (!option.value) return true;
              radio.attr('data-option', option.value);
              if (!this._tfp.isDesigning) radio.attr('onclick', `${this.id}.radioOnClick(this)`);
              if (cellValue.split(",").contains(option.value)) radio.find('div').css('display', 'inline-block');
              label.html(option.text || option.value);
              radioCpt.append(radio).append(label);
            });
            itemright.append(radioCpt);
          }
          else {
            const radio = $('<div class="radioitem"><div style="display: none" data-option="1"></div></div>');
            if (!this._tfp.isDesigning) radio.attr('onclick', `${this.id}.radioOnClick(this)`);
            radioCpt.append(radio).append(label);
            itemright.append(radioCpt);
          }
          break;
        case 'checkbox':
          const checkboxCpt = $(`<div class="checkbox" inpId="${input.id}"></div>`);
          if (input.options) {
            input.options.forEach(option => {
              const checkbox = $('<div class="checkboxitem"><div style="display: none"></div></div>');
              const label = $('<label></label>');
              if (!option.value) return true;
              checkbox.attr('data-option', option.value);
              if (!this._tfp.isDesigning) checkbox.attr('onclick', `${this.id}.checkboxOnClick(this)`);
              if (cellValue.split(",").contains(option.value)) checkbox.find('div').css('display', 'inline-block');
              label.html(option.text || option.value);
              checkboxCpt.append(checkbox).append(label);
            });
            itemright.append(checkboxCpt);
          }
          else {
            const checkbox = $('<div class="checkboxitem"><div style="display: none" data-option="1"></div></div>');
            if (!this._tfp.isDesigning) checkbox.attr('onclick', `${this.id}.checkboxOnClick(this)`);
            checkboxCpt.append(checkbox).append(label);
            itemright.append(checkboxCpt);
          }
          break;
        default:
          break;
      }
      html.append(item);
    });
    return html.prop("outerHTML");
  }

  /**
   * 点击单选时
   * @param  {[type]} divRadio [description]
   * @return {[type]}           [description]
   */
  radioOnClick(divRadio) {
    var that = this;
    $(divRadio).siblings(".radioitem").find('div').css('display', 'none');
    $(divRadio).find('div').css('display', 'inline-block');
    that.setRowsData();
  }

  /**
   * 点击多选时
   * @param  {[type]} divCheckbox [description]
   * @return {[type]}           [description]
   */
  checkboxOnClick(divCheckbox) {
    var that = this;
    let divCheckboxItem = $(divCheckbox).find('div');
    if (divCheckboxItem.css('display') == 'inline-block') divCheckboxItem.css('display', 'none');
    else divCheckboxItem.css('display', 'inline-block');
    that.setRowsData();
  }

  /**
   * 点击开关时
   * @param  {[type]} divSwitch [description]
   * @return {[type]}           [description]
   */
  switchOnClick(divSwitch) {
    var that = this;

    let dateItem = this.dataModel.columns[$(divSwitch).closest(".tfp-dataset-item").index() - 1];
    if ($(divSwitch).find("div").css("float") == "left") {
      $(divSwitch).find("div").css("float", "right");
      $(divSwitch).find("div").css("background-color", "#0099ff");
      $(divSwitch).attr("value", dateItem.options ? dateItem.options[1] : "true");
    } else {
      $(divSwitch).find("div").css("float", "left");
      if (this._tfp.curPage.bgColorMode == "dark") {
        $(divSwitch).find("div").css("background-color", "#666666");
      } else {
        $(divSwitch).find("div").css("background-color", "#999999");
      }
      $(divSwitch).attr("value", dateItem.options ? dateItem.options[0] : "false");
    }
    this.setRowsData();

    let rowIndex = $(divSwitch).closest(".tfp-dataset-row").index() - 1;
    let colIndex = $(divSwitch).closest(".tfp-dataset-item").index() - 1;
    let cellData = $(divSwitch).attr("value");

    if (this.dataModel.onCellClick) {
      try {
        eval(that.dataModel.onCellClick);
      } catch (err) {
        console.log(err);
      }
    }

    if (this.dataModel.onCellDataChange) {
      try {
        eval(that.dataModel.onCellDataChange);
      } catch (err) {
        console.error(err);
      }
    }
  }

  /**
 * 点击日期、日期时间时
 * @param  {[type]} divDate [description]
 * @return {[type]}           [description]
 */
  dateOnClick(divDate) {
    let that = this;
    let dateItem = this.dataModel.columns[$(divDate).closest(".tfp-dataset-item").index() - 1];
    let dateValue = $(divDate).val();
    let optionsList = [];

    if (dateItem.type == "datetime") {
      that.getDateOptions(optionsList, dateItem, dateValue);
      that.getTimeOptions(optionsList, dateItem, dateValue);
    }
    else if (dateItem.type == "date") {
      that.getDateOptions(optionsList, dateItem, dateValue);
    }
    else if (dateItem.type == "time") {
      that.getTimeOptions(optionsList, dateItem, dateValue);
    }

    window.popupList.show(optionsList, function (vals) {
      let val = '';
      if (dateItem.type == "datetime") {
        val = vals[0] + "-" + vals[1] + "-" + vals[2] + " " + vals[3] + ":" + vals[4];
      }
      else if (dateItem.type == "date") {
        val = vals[0] + "-" + vals[1] + "-" + vals[2];
      }
      else if (dateItem.type == "time") {
        val = vals[0] + ":" + vals[1];
      }

      if (vals.length > 0) $(divDate).val(val); else $(divDate).val("");

      that.setRowsData();

      let rowIndex = $(divDate).closest(".tfp-dataset-row").index() - 1;
      let colIndex = $(divDate).closest(".tfp-dataset-item").index() - 1;
      let cellData = $(divDate).val();

      if (that.dataModel.onCellDataChange) {
        try {
          eval(that.dataModel.onCellDataChange);
        } catch (err) {
          console.error(err);
        }
      }
    });
  }

  getDateOptions(optionsList, dateItem, dateValue) {
    let dateVal = new Date();
    if (dateItem.default) dateVal = new Date(dateItem.default);

    let yearOptions = {
      options: [],
      width: "80px",
      value: dateVal.getFullYear() + ""
    };
    for (var i = 1973; i <= 2073; i++) {
      yearOptions.options.push(i + "");
    }

    let curMonth = dateVal.getMonth() + 1;
    curMonth = curMonth < 10 ? "0" + curMonth : curMonth + "";
    let monthOptions = {
      options: [],
      width: dateItem.type == "DateTime" ? "60px" : "80px",
      value: curMonth
    };
    for (var i = 1; i <= 12; i++) {
      let month = i < 10 ? "0" + i : i + "";
      monthOptions.options.push(month);
    }
    monthOptions.onChange = function () {
      let month = window.popupList.getColumnVal(1);
      let dayCol = $(".tfp-popuplist-content-column").get(2);
      let items = $(dayCol).find(".tfp-popuplist-content-item");
      if (month == "02") {
        items.eq(32).hide();
        items.eq(33).hide();
        let year = parseInt(window.popupList.getColumnVal(0));
        if (year % 4 == 0) {
          items.eq(31).show();
        } else {
          items.eq(31).hide();
        }
      } else if (["04", "06", "09", "11"].contains(month)) {
        items.eq(31).show();
        items.eq(32).show();
        items.eq(33).hide();
      } else {
        items.eq(31).show();
        items.eq(32).show();
        items.eq(33).show();
      }
    };

    let curDay = dateVal.getDate();
    curDay = curDay < 10 ? "0" + curDay : curDay + "";
    let dateOptions = {
      options: [],
      width: dateItem.type == "DateTime" ? "60px" : "80px",
      value: curDay
    };
    for (var i = 1; i <= 31; i++) {
      let day = i < 10 ? "0" + i : i + "";
      dateOptions.options.push(day);
    }
    if (dateValue && new Date(dateValue) != 'Invalid Date') {
      dateVal = new Date(dateValue);
      yearOptions.value = dateVal.getFullYear().toString();
      monthOptions.value = (dateVal.getMonth() + 1).toString().padStart(2, 0);
      dateOptions.value = dateVal.getDate().toString().padStart(2, 0);
    }
    optionsList.push(yearOptions);
    optionsList.push(monthOptions)
    optionsList.push(dateOptions);
  }

  getTimeOptions(optionsList, dateItem, dateValue) {
    let dateVal = new Date();
    if (dateItem.default) dateVal = new Date(dateItem.default);

    let curHour = dateVal.getHours();
    curHour = curHour < 10 ? "0" + curHour : curHour + "";
    let hourOptions = {
      options: [],
      width: "60px",
      value: curHour
    };
    for (var i = 0; i <= 23; i++) {
      let hour = i < 10 ? "0" + i : i + "";
      hourOptions.options.push(hour);
    }

    let curMinute = dateVal.getMinutes();
    curMinute = curMinute < 10 ? "0" + curMinute : curMinute + "";
    let minuteOptions = {
      options: [],
      width: "60px",
      value: curMinute
    };
    for (var i = 0; i <= 59; i++) {
      let day = i < 10 ? "0" + i : i + "";
      minuteOptions.options.push(day);
    }

    if (dateValue && /^\d{2}\:\d{2}$/.test(dateValue)) {
      dateVal = new Date('1970-01-01 ' + dateValue);
      hourOptions.value = dateVal.getHours().toString().padStart(2, 0);
      minuteOptions.value = dateVal.getMinutes().toString().padStart(2, 0);
    }

    optionsList.push(hourOptions);
    optionsList.push(minuteOptions);
  }

  /**
  * 点击下拉列表时
  * @param  {[type]} divSelect [description]
  * @return {[type]}           [description]
  */
  selectOnClick(divSelect) {
    if (!window.popupList) {
      this._tfp.use(["PopupList"], function () {
        var popupListClass = this._tfp.controllers["PopupList"];
        window.popupList = new popupListClass(this._tfp, {
          "id": "popupList",
          "type": "PopupList"
        });
        this.showPopupList(divSelect);
      });
      return;
    }
    this.showPopupList(divSelect);
  }

  showPopupList(divSelect) {
    var that = this;
    var selectVal = this.dataModel.columns[$(divSelect).closest(".tfp-dataset-item").index() - 1];
    if (selectVal.readonly || !selectVal.options) return;

    that.loadOptionData(selectVal, divSelect, function () {
      window.popupList.show([{
        options: selectVal.options,
        value: divSelect.dataset.value
      }], function (vals) {
        const value = vals && vals.length > 0 ? vals[0] : "";
        $(divSelect).val(value).attr('data-value', value);
        for (let i = 0; i < selectVal.options.length; i++) {
          const option = selectVal.options[i];
          if (option.value == value) {
            $(divSelect).val(option.text).attr('data-value', option.value);
            break;
          }
        }
        that.setRowsData();

        let rowIndex = $(divSelect).closest(".tfp-dataset-row").index() - 1;
        let colIndex = $(divSelect).closest(".tfp-dataset-item").index() - 1;
        let cellData = $(divSelect).attr("data-value");

        if (that.dataModel.onCellDataChange) {
          try {
            eval(that.dataModel.onCellDataChange);
          } catch (err) {
            console.error(err);
          }
        }

        that.formulaCell($(divSelect), selectVal);
      });
    });
  }

  loadOptionData(selectVal, divSelect, cb) {
    if (!selectVal.loadDataListService) {
      return cb();
    }
    let serviceCpt = this._tfp.get(selectVal.loadDataListService);
    if (!serviceCpt) {
      alert("ID为[" + selectVal.loadDataListService + "]的组件不存在！");
      return;
    }
    if (!selectVal.dataListBindingMember) {
      alert("请为[" + this.id + "]设置数据绑定成员！");
      return;
    }
    if (!selectVal.dataListValueFormat) {
      alert("请为[" + this.id + "]设置选项值字段格式！");
      return;
    }

    let that = this;
    serviceCpt.request(null, function (req, res) {
      var data = res[selectVal.dataListBindingMember];
      that.bindOptionData(data, selectVal, divSelect, cb);
    });
  }

  bindOptionData(data, selectVal, divSelect, cb) {
    if (isNull(data) || !Array.isArray(data)) return;
    var options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        option.value = this._tfp.replaceDataField(row, "" + selectVal.dataListValueFormat + "");
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      if (selectVal.dataListTextFormat) {
        try {
          option.text = this._tfp.replaceDataField(row, "" + selectVal.dataListTextFormat + "");
        } catch (e) {
          console.log(e);
          return;
        }
      }
      options.push(option);
      selectVal.options = options;
    }
    if (cb) cb();
  }

  // 初始化行样式，添加行
  initRowChange() {
    let that = this;
    changeRow();

    // 绑定添加按钮的点击事件
    this._jqObj.find(".tfp-dataset-button-add,.tfp-dataset-tool>.tfp-dataset-button-insert").off('click').click(function () {
      that._jqObj.find(".tfp-dataset-button").before(that.getRowHtml(that.value.length, {}));
      changeRow();
    });

    function changeRow() {
      // 删除外边框
      that._jqObj.find(".tfp-dataset-item,.tfp-dataset-item-left,.tfp-dataset-item-right").css("outline", "none");
      // 判断是否删除表格头
      if (that._jqObj.find(".tfp-dataset-row").length) that._jqObj.find('.tfp-dataset-toolbar').hide();
      else that._jqObj.find('.tfp-dataset-toolbar').show();
      // 遍历表格行
      that._jqObj.find(".tfp-dataset-row").each(function (rowIndex) {
        // 重置标题
        $(this).find('.tfp-dataset-row-header-title').text(`${that.dataModel.titleName || that.dataModel.id}(${rowIndex + 1})`);
        // 插入按钮
        $(this).find('.tfp-dataset-button-insert').off('click').on('click', function () {
          $(this).parents('.tfp-dataset-row').eq(0).after(that.getRowHtml(that.value.length, {}));
          changeRow();
          that.setRowsData();
        });
        // 上移按钮
        $(this).find('.tfp-dataset-button-moveUp').off('click').on('click', function () {
          if (rowIndex == 0) return;
          const thisRow = $(this).parents('.tfp-dataset-row').eq(0);
          const prevRow = thisRow.prev();
          prevRow.before(thisRow);
          changeRow();
          that.setRowsData();
        });
        // 下移按钮
        $(this).find('.tfp-dataset-button-moveDown').off('click').on('click', function () {
          if (rowIndex == that._jqObj.find(".tfp-dataset-row").length - 1) return;
          const thisRow = $(this).parents('.tfp-dataset-row').eq(0);
          const nextRow = thisRow.next();
          nextRow.after(thisRow);
          changeRow();
          that.setRowsData();
        });
        // 删除按钮
        $(this).find('.tfp-dataset-button-delete').off('click').on('click', function () {
          $(this).parents('.tfp-dataset-row').remove();
          changeRow();
          that.setRowsData();
        });
      });
      that._jqObj.find("input").change(function () {
        that.setRowsData($(this));
      });
      that.setRowsData();
      that.bindInpEvent();
    }
  }

  setRowsData(divInput) {
    let rowsData = [];
    this._jqObj.find(".tfp-dataset-row").each(function () {
      let that = $(this);
      let rowsDataItem = {};
      that.find(".tfp-dataset-item-right").children().each(function () {
        const inpId = $(this).attr("inpId");
        switch ($(this).attr('class')) {
          case 'switch':
            rowsDataItem[inpId] = $(this).attr("value");
            break;
          case 'radio':
            $(this).find('.radioitem div').each(function () {
              if ($(this).css('display') == 'inline-block') {
                rowsDataItem[inpId] = $(this).parent().attr("data-option");
              }
            });
            break;
          case 'checkbox':
            let temp = [];
            $(this).find('.checkboxitem div').each(function () {
              if ($(this).css('display') == 'inline-block') {
                temp.push($(this).parent().attr("data-option"));
              }
            });
            rowsDataItem[inpId] = temp.join();
            break;
          default:
            rowsDataItem[inpId] = this.dataset.value || $(this).val();
            break;
        }
      });
      rowsData.push(rowsDataItem);
    });
    this.value = rowsData;
    if (divInput) {
      let that = this;

      let rowIndex = $(divInput).closest(".tfp-dataset-row").index() - 1;
      let colIndex = $(divInput).closest(".tfp-dataset-item").index() - 1;
      let cellData = $(divInput).val();

      if (this.dataModel.onCellDataChange) {
        try {
          eval(that.dataModel.onCellDataChange);
        } catch (err) {
          console.error(err);
        }
      }
    }
  }

  bindInpEvent() {
    var that = this;

    this._jqObj.find("input").click(function () {
      let input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
      let rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
      let cellData = $(this).val();
      if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

      if (that.dataModel.onCellClick) {
        try {
          eval(that.dataModel.onCellClick);
        } catch (err) {
          console.error(err);
        }
      }
    });

    this._jqObj.find("input").dblclick(function () {
      let input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
      let rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
      let cellData = $(this).val();
      if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

      if (that.dataModel.onCellDblClick) {
        try {
          eval(that.dataModel.onCellDblClick);
        } catch (err) {
          console.error(err);
        }
      }
    });

    this._jqObj.find("input").focus(function () {
      let input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
      let rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
      let cellData = $(this).val();
      if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

      if (that.dataModel.onCellFocus) {
        try {
          eval(that.dataModel.onCellFocus);
        } catch (err) {
          console.error(err);
        }
      }
    });

    this._jqObj.find("input").blur(function () {
      let input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
      let rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
      let cellData = $(this).val();
      if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

      if (that.dataModel.onCellBlur) {
        try {
          eval(that.dataModel.onCellBlur);
        } catch (err) {
          console.error(err);
        }
      }

      that.formulaCell($(this), that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1]);
    });

    this._jqObj.find("input").keypress(function () {
      let input = that.dataModel.columns[$(this).closest(".tfp-dataset-item").index() - 1];
      let rowIndex = $(this).closest(".tfp-dataset-row").index() - 1;
      let cellData = $(this).val();
      if (input.type.toLowerCase() == 'select') cellData = $(this).attr("data-value") || '';

      if (that.dataModel.onCellKeyPress) {
        try {
          eval(that.dataModel.onCellKeyPress);
        } catch (err) {
          console.error(err);
        }
      }
    });
  }

  formulaCell(ipt, input) {
    if (this.calcRows && this.calcRows[input.id]) {
      //获得当前行的数据
      let curRowDiv = $(ipt).parent().parent().parent();
      let rowData = this.value[$(ipt).parent().parent().parent().index()];
      let rowDataTmp = {};
      for (var k in rowData) {
        if (rowData[k] != "") {
          rowDataTmp[k] = rowData[k];
        }
      }
      var arr = this.calcRows[input.id];
      for (var j = 0; j < arr.length; j++) {
        for (var k = 0; k < this.dataModel.columns.length; k++) {
          var rowR = this.dataModel.columns[k];
          if (arr[j] == rowR.id && rowR.formula) {
            this.exeFormula(rowR, rowDataTmp, curRowDiv, k);
            break;
          }
        }
      }
    }
  }

  /**
   * 执行计算表达式
   * @param  {[type]} rowR      [description]
   * @param  {[type]} rowData   [description]
   * @param  {[type]} curRowDiv [description]
   * @param  {[type]} rowIndex  [description]
   * @return {[type]}           [description]
   */
  exeFormula(rowR, rowData, curRowDiv, rowIndex) {
    let rowRFormula = this._tfp.replaceDataField(rowData, rowR.formula, 0);
    var formulaVal = null;
    try {
      formulaVal = eval(rowRFormula);
    } catch (error) {
      console.error(error.message);
      return;
    }
    if (rowR.type == "text" && (rowR.dataType == "int" || rowR.dataType == "float" || rowR.dataType == "money")) {
      if (rowR.dataType == "int") {
        formulaVal = parseInt(formulaVal);
      } else if (rowR.dataType == "float") {
        formulaVal = parseFloat(formulaVal);
      } else if (rowR.dataType == "money") {
        formulaVal = this._tfp.formatMoney(formulaVal);
      }
    }
    var rowRDivIndex = rowIndex;
    curRowDiv.children().eq(rowRDivIndex).find("input").val(formulaVal);
    this.setRowsData();
  }

  /**
  * form表单提交校验
  * @param  {[type]}   options [description]
  * @return {[type]}           [description]
  */
  getRowsData(options, cb) {
    const values = [];
    this.setRowsData();
    this.value.forEach(item => {
      for (const key in item) {
        values.push({ [key]: item[key] });
      }
    });
    for (var i = 0; i < this.dataModel.columns.length; i++) {
      if (i < values.length) {
        let input = this.dataModel.columns[i];
        let obj = values[i];
        if (input.required == true && obj[input.id] == "") {
          let rowType = input.type;
          let rowName = input.id;
          if (input.name) rowName = input.name;
          if (options && options.checkRequired) {
            this._tfp.showMsg(rowName + "不能为空！");
            if (rowType == "text" || rowType == "select" || rowType == "password" || rowType == "date" || rowType == "datetime") {
              this._jqObj.find(".tfp-dataset-row").children().eq(i).find("input").focus();
            }
            return null;
          }
        }
      }
    }
    if (cb) {
      cb(this.value);
    } else {
      return this.value;
    }
  }

  /**
   * 绑定数据
   * @param  {[type]} data [description]
   * @return {[type]}      [description]
   */
  bindData(data) {
    this.rows = data;
  }

  onLoadData(req, res) {
    let dataMember = this.dataModel.dataBindingMember;
    if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      dataMember = this.dataModel.dataQuerySetting.dataMember;
    }
    var data = res[dataMember];
    if (!data) return;
    if (data.pageSize && data.rows) {
      this.bindData(data.rows);
    } else {
      this.bindData(data);
    }
    this.initRowChange();
  }

  submit(options) {
    if (!this.dataModel.submitService && !this.dataModel.dataSubmitSetting) {
      this._tfp.showMsg("请为[" + this.id + "]设置数据提交有关参数！");
      return;
    }

    this.exeEventHandler("onBeforeSubmit");

    let that = this;
    let args = {};
    args[that.id] = this.getRowsData(options);
    if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.servicePath) {
      let optionsReq = {
        servicePath: this.dataModel.dataSubmitSetting.servicePath,
        autoShowError: true,
        showLoading: true,
        args: args
      };
      if (that.dataModel.dataSubmitSetting.requestArgs && that.dataModel.dataSubmitSetting.requestArgs.length > 0) {
        optionsReq.argSettings = that.dataModel.dataSubmitSetting.requestArgs;
      }
      if(that.dataModel.dataSubmitSetting.encryptRequestArgs) optionsReq.encryptRequestArgs = that.dataModel.dataSubmitSetting.encryptRequestArgs;
      if(that.dataModel.dataSubmitSetting.encryptResponseArgs) optionsReq.encryptResponseArgs = that.dataModel.dataSubmitSetting.encryptResponseArgs;

      that._tfp.request(optionsReq, function (req, res) {
        that.exeEventHandler("onAfterSubmit", res);
      });
      return;
    }

    let serviceId = this.dataModel.submitService;
    if (this.dataModel.dataSubmitSetting && this.dataModel.dataSubmitSetting.serviceCpt) {
      serviceId = this.dataModel.dataSubmitSetting.serviceCpt;
    }
    let serviceCpt = that._tfp.get(serviceId);
    if (!serviceCpt) {
      that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
      return;
    }
    serviceCpt.request(args, function (req, res) {
      that.exeEventHandler("onAfterSubmit", res);
    });
  }

  setColOptions(col, cb) {
    if (col.type.toLowerCase() != "select" && col.type.toLowerCase() != "popuplist") {
      if (cb) cb();
      return;
    }

    if (col.jsonDataSet) {
      col.loadDataListService = col.jsonDataSet.loadDataListService;
      col.dataListBindingMember = col.jsonDataSet.dataListBindingMember;
      col.valueField = col.jsonDataSet.valueField;
      col.textField = col.jsonDataSet.textField;
      col.parentIdField = col.jsonDataSet.parentIdField;
      col.options = col.jsonDataSet.options;
      // this.dataModel.defaultValue = this.dataModel.jsonDataSet.defaultValue;
    }

    //如果设置了数据加载服务，则从后台加载数据
    if (col.loadDataListService && col.dataListBindingMember) {
      let serviceCpt = this._tfp.get(col.loadDataListService);
      if (!serviceCpt) {
        alert("ID为[" + col.loadDataListService + "]的组件不存在！");
        return;
      }
      if (!col.dataListBindingMember) {
        alert("请为[" + this.id + "]设置数据绑定成员！");
        return;
      }

      let that = this;
      serviceCpt.status = 0;

      serviceCpt.request(null, function (req, res) {
        var data = res[col.dataListBindingMember];
        if (!data) return;
        //let options = [];
        if (data.pageSize && data.rows) {
          data = data.rows;
        }

        if (col.valueField) {
          let optionsTmp = [];
          for (var i = 0; i < data.length; i++) {
            let rowTmp = data[i];
            let optionTmp = {};
            try {
              optionTmp.value = that._tfp.replaceDataField(rowTmp, "{" + col.valueField + "}");
            } catch (e) {
            }
            if (isNull(optionTmp.value)) continue;
            if (col.textField) {
              try {
                optionTmp.text = that._tfp.replaceDataField(rowTmp, "{" + col.textField + "}");
              } catch (e) {
              }
            }
            optionsTmp.push(optionTmp);
          }
          col.options = optionsTmp;
        }
        else {
          col.options = data;
        }

        if (cb) cb();
      });
    }
    else if (col.options) {  //否则，如果该列设置了固定的可选项
      let options = [];
      try {
        col.options = JSON.parse(col.options);
      } catch (error) { }
      if (Array.isArray(col.options)) {
        for (var j = 0; j < col.options.length; j++) {
          let option = col.options[j];
          if (typeof (option) == "string") {
            options.push({ value: option, text: option });
          } else if (Object.prototype.toString.call(option) === '[object Object]') {
            if (!option.text && option.text != 0) option.text = option.value;
            options.push(option);
          }
        }
      } else if (typeof (col.options) == "string") {
        let arr = (col.options + '').split(",");
        for (var j = 0; j < arr.length; j++) {
          options.push({ value: arr[j], text: arr[j] });
        }
      }
      col.options = options;

      if (cb) cb();
    }
    else {
      col.options = [];
      if (cb) cb();
    }
  }

  setColOptionsLoop(cb) {
    var that = this;
    if (that.tmp_index >= this.dataModel.columns.length) {
      cb();
    }
    else {
      //加载下拉列表列和弹出列表列的可选项
      this.setColOptions(this.dataModel.columns[that.tmp_index], function () {
        that.tmp_index++;
        that.setColOptionsLoop(cb);
      });
    }
  }

  initRuntime() {
    let that = this;
    if (this.dataModel.columns) {
      this.tmp_index = 0;
      this.setColOptionsLoop(function () {
        that.initRuntimeGoon();
      })
    }
    else {
      that.initRuntimeGoon();
    }
  }

  getRowData(index) {
    if (this.value.length > 0 && this.value.length > index)
      return this.value[index];
    else return '';
  }

  getCellData(rowIndex, colIndex) {
    if (this.value.length > 0 && this.value.length > rowIndex) {
      let obj = this.value[rowIndex];
      let objArray = Object.values(obj);
      let thirdElement = '';
      if (objArray.length > 0 && objArray.length > colIndex) thirdElement = objArray[colIndex];
      return thirdElement;
    } else {
      return '';
    }
  }

  initRuntimeGoon() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    } else {
      this.bindData([]);
      this.initRowChange();
    }

    //设置计算行关联的行，以便当关联行的数据发生变化时，自动执行计算行的值
    if (this.dataModel.columns) {
      //存在关联计算的行
      this.calcRows = {};
      for (var i = 0; i < this.dataModel.columns.length; i++) {
        let input = this.dataModel.columns[i];
        // 如果是计算行
        if (input.formula) {
          let arr = input.formula.match(/\{[\w]+\}/g);
          if (arr.length > 0) {
            for (var j = 0; j < arr.length; j++) {
              for (var k = 0; k < this.dataModel.columns.length; k++) {
                let rowR = this.dataModel.columns[k];
                //如果当前行与计算行有关联，则标示为计算关联行
                if (("{" + rowR.id + "}") == arr[j]) {
                  if (!this.calcRows[rowR.id]) {
                    this.calcRows[rowR.id] = [];
                  }
                  if (!this.calcRows[rowR.id].contains(input.id))
                    this.calcRows[rowR.id].push(input.id);
                }
              }
            }
          }
        }
      }
    }
  }
}