import Select from "../select/controller.phone.js";

/**
 * 数据字典
 * @param {[type]} dataModel [description]
 */
export default class DataDic extends Select {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "DataDic");
  }

  get typeCode() { return this.dataModel.typeCode }
  set typeCode(value) { this.dataModel.typeCode = value }

  get value() { return this.dataModel.value }
  set value(value) { this.dataModel.value = value }

  initRuntime() {

    this.dataModel.valueField = "code";
    this.dataModel.textField = "name";

    super.initRuntime();

    //需要设置类别编码
    if (!this.dataModel.typeCode) {
      console.log("请设置类别编码！");
      return;
    }
    let that = this;
    this._tfp.use("Service", function () {
      let service = that._tfp.new("Service");
      service.path = "sys/service/data_dic/getList.tbs";
      service.request({ typeCode: that.dataModel.typeCode }, function (req, res) {
        that.bindData(res.data);
      });
    });
  }
}