import { FormInput } from "../controller.js";

/**
 * 数据字典组件
 * @param {[type]} dataModel [description]
 */
export default class DataDic extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "DataDic", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    let val = value;
    if (isNull(value)) {
      val = "";
      this.dataModel.value = null;
      if (this.dataModel.multiCheck) this.showOptions();
    } else {
      if (!this.dataModel.multiCheck) {
        let obj = {};
        let text = '';
        if (this.dataModel.options) {
          for (var i = 0; i < this.dataModel.options.length; i++) {
            let option = this.dataModel.options[i];
            if ((option.value + "") == (val + "")) {
              obj = option;
              if (option.text) text = option.text;
              break;
            }
          }
        }

        if (this.dataModel.valueType == "name") {
          this.dataModel.value = text;
        } else if (this.dataModel.valueType == "obj") {
          this.dataModel.value = obj;
        } else {
          this.dataModel.value = val;
        }
      }
      else this.dataModel.value = val;
    }
    if (this._jqObj) {
      if (isNull(value)) {
        this._jqObj.find("input").val("");
      } else {
        //如果已经绑定了选项列表
        if (this.dataModel.options) {
          if(!this.dataModel.multiCheck) {
            for (var i = 0; i < this.dataModel.options.length; i++) {
              var option = this.dataModel.options[i];
              if ((option.value + "") == (val + "")) {
                this._jqObj.find("input").val(option.text);
                break;
              }
            }
          } else {
            let text = "";
            let vals = (val + "").split(",");
            var divDataList = $("#" + this.id + "_datadicDiv");
            for (var i = 0; i < this.dataModel.options.length; i++) {
              var option = this.dataModel.options[i];
              if (vals.contains(option.value + "")) {
                let optionDiv = divDataList.find("div[data-value="+option.value+"]");
                if(optionDiv.length>0) optionDiv.find("input").get(0).checked = true;
                text += (text=="") ? "" : ",";
                text += option.text;
              }
            }
            this._jqObj.find("input").val(text);
          }
        }
      }
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", val);
    }
  }

  get text() {
    if (!this.dataModel.value) return "";
    let item = this.dataModel.options.find(v => v.value == this.dataModel.value);
    if (!item) return "";
    return item.text;
  }
  set text(txt) {
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) {
    this.dataModel.multiCheck = value ? true : false;
  }

  get options() { return this.dataModel.options }
  set options(value) {
    this.dataModel.options = value;
    return;
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get placeHolders() { return this.dataModel.placeHolders }
  set placeHolders(value) {
    this.dataModel.placeHolders = value;
    if (this._jqObj) this._jqObj.find("input").attr("placeholder", value);
  }

  get typeCode() { return this.dataModel.typeCode }
  set typeCode(value) { this.dataModel.typeCode = value }

  get dataListValueFormat() { return this.dataModel.dataListValueFormat }
  set dataListValueFormat(value) {
    this.dataModel.dataListValueFormat = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    this.options = [];
    this.nodes = {};

    let iptText = "";
    let iptVals = [];
    if(!isNull(this.value) && this.dataModel.multiCheck) {
      iptVals = (this.value+'').split(",");
    }

    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let valueFormat = this.dataModel.dataListValueFormat;
        if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
        option.value = this._tfp.replaceDataField(row, valueFormat);
        if (option.value) option.value = this._tfp.exeExpress(option.value);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      option.text = option.value;
      if (this.dataModel.dataListTextFormat) {
        try {
          let textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (isNull(option.text)) continue;
      if(!isNull(this.value)  && this._jqObj) {
        if(!this.dataModel.multiCheck) {
          if ((this.value + "") == (option.value + "")) iptText = option.text;
        } else {
          if(iptVals.contains((option.value + ""))) {
            iptText += (iptText=="") ? "" : ",";
            iptText += option.text;
          }
        }
      }
      
      this.options.push(option);

      this.nodes[option.value] = {
        option: option
      }
    }
    if (this.options.length == 0) return;
    if(iptText!="") this._jqObj.find("input").val(iptText);
  }

  addOptionDiv(divDataList, option, iptVal, nodePrefix) {
    let text = option.text;
    let ipt = '';
    if (this.dataModel.multiCheck) {
      let iptVals = [];
      if(!isNull(this.value) && this.dataModel.multiCheck) {
        iptVals = (this.value+'').split(",");
      }
      ipt = '<input type=\"checkbox\"';
      if(iptVals.contains(option.value+'')) ipt += " checked";
      ipt += ">";
    }
    divDataList.append("<div data-value=\"" + option.value + "\">" + ipt + "" + text + "</div>");
  }

  showOptions() {
    if (!this.options || this.options.length == 0) return;
    var divDataList = $("#" + this.id + "_datadicDiv");
    var iptVal = this._jqObj.find("input").val().trim();
    let leg = divDataList.find("div").length;
    if (!this.dataModel.multiCheck || (this.dataModel.multiCheck && leg == 0) || iptVal == '') {
      divDataList.empty();
      if (!this.dataModel.required) {
        divDataList.append("<div data-value=\"\"></div>");
      }
      for (var i = 0; i < this.options.length; i++) {
        var option = this.options[i];
        this.addOptionDiv(divDataList, option, iptVal);
      }
    }
    var that = this;

    if (this.dataModel.multiCheck) {
      divDataList.find("input").click(function () {
        event.stopPropagation();

        let value = [];
        let text = [];
        let obj = []
        for (var j = 0; j < divDataList.find("input").length; j++) {
          let ipt = divDataList.find("input").eq(j);
          let dataVal = ipt.parent("div").attr("data-value");
          if (ipt.prevObject[j].checked) {
            for (var i = 0; i < that.dataModel.options.length; i++) {
              let option = that.dataModel.options[i];
              if ((option.value + "") == (dataVal + "")) {
                obj.push(option)
                value.push(option.value);
                if (option.text) text.push(option.text);
              }
            }
          } else {
            continue;
          }
        }
        if (value.length == 0 || text.length == 0) {
          that.value = '';
        } else {

          if (that.dataModel.valueType == "code") that.value = value;
          if (that.dataModel.valueType == "name") that.value = text;
          if (that.dataModel.valueType == "obj") that.value = obj;
        }
        that._jqObj.find("input").val(text.join(','));
      });
    } else {
      divDataList.find("div").click(function () {
        event.stopPropagation();

        let val = $(this).attr("data-value");
        //if (val == '-1') val = '';

        that.value = val;
        divDataList.empty();
        divDataList.hide();
        that._jqObj.find("input").focus();
      });
    }
    divDataList.css("left", that._jqObj.offset().left + "px");
    divDataList.css("top", (that._jqObj.offset().top + 31) + "px");
    $(".tfp-datadic-datalist").hide();
    divDataList.show();

    document.addEventListener("click", function () {
      if (!$(event.target).is($('.tfp-datadic-datalist'))) $(".tfp-datadic-datalist").hide();
    });
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.css("padding-left", "0px");
      this._jqObj.find("img").css("display", "none");
      this._jqObj.find("input").css("padding-left", "0px");
    }

    this.dataModel.dataListValueFormat = "code";
    this.dataModel.dataListTextFormat = "name";

    //需要设置类别编码
    if (!this.dataModel.typeCode) {
      console.log("请设置类别编码！");
      return;
    }
    this._tfp.use("Service", function () {
      let service = that._tfp.new("Service");
      service.path = "sys/service/data_dic/getList.tbs";
      service.request({ typeCode: that.dataModel.typeCode }, function (req, res) {
        that.bindData(res.data);
      });
    });

    this._jqObj.blur(function () {
      if (that.readonly || that.disabled) return;

      let val = $(this).val().trim();
      that.dataModel.value = val;
      that.valueOnChange();
      that.exeEventHandler("onChange", val);
    });

    this._jqObj.find("input").click(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onClick) eval(that.dataModel.onClick);
      } catch (err) {
        console.log(err.message);
      }
      if (that.readonly) return;
      that.showOptions();
      event.stopPropagation();
    });

    this._jqObj.find("img").click(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onClick) eval(that.dataModel.onClick);
      } catch (err) {
        console.log(err.message);
      }
      if (that.readonly) return;

      if (that._jqObj.children("img").attr("src").slice(-14).slice(0, 5) != 'close') that.showOptions();
      event.stopPropagation();
    });

    this._jqObj.hover(function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("background-color", "#F6F6F6");
        that._jqObj.find("input").css("background-color", "#F6F6F6");
      }
      if (that._jqObj.children("input").val() != '') {
        that._jqObj.children("img").attr('src', '' + that._tfp.rootPath
          + '/src/components/select/images/close-'
          + that._tfp.curPage.contentColorMode + '.png');
      }
      that._jqObj.children("img").on('click', function (e) {
        if (that._jqObj.children("input").val() != '') {
          e.stopPropagation();
          that._jqObj.children("input").val('');
          that.dataModel.value = '';
          that.showOptions();
          that.valueOnChange();
          that.exeEventHandler("onChange", '');
        }
      })
    }, function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that._jqObj.find("input").is(":focus")) {
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
      that._jqObj.children("img").attr('src', '' + that._tfp.rootPath
        + '/src/components/select/images/arrow-down-'
        + that._tfp.curPage.contentColorMode + '.png');
    })

    this._jqObj.find("input").focus(function () {
      if (that.disabled) return;
      if(that._tfp.curPage.bgColorMode=="light") 
        that._jqObj.css("outline", "1px solid var(--sys-theme-color)");
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find("input").blur(function () {
      if (that.disabled) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("outline", "0");
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    })

    let dataListDivWidth = this._jqObj.width() + 6;
    //添加数据列表层
    $("body").append("<div id=\"" + this.id + "_datadicDiv\" "
      + "class=\"tfp-datadic-datalist\" style=\"width:" + dataListDivWidth
      + "px;\"></div>");
  }
}