import TFPComponentRender from '../render.js'

export default class DataCardRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getCustomStyleHtml() {
    //如果不是设计时，要隐藏模板信息
    if (!this._tfp.isDesigning) return "display:none;";
    return "";
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    var indent = this.cpt.getHtmlIndent();
    if (this.dataModel.components && getComponentsHtml) {
      //let cdm = this.dataModel.components[0];
      //this.cpt.setCptDataFormat(cdm);
      bodyHtml += this.getComponentsHtml(true, indent, true);
    }
    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, true);
  }
}