import { ContainerComponent } from "../controller.js";

/**
 * 数据卡片组件
 * @param {[type]} dataModel [description]
 */
export default class DataCard extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "DataCard", dataModel, parent);

    this.dataList = [];
    this.cards = [];
    this.curPage = 1;
    this.pageCount = 0;
    this.rowsCount = 0;
  }

  //属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) { this.dataModel.loadDataService = value }

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) { this.dataModel.dataBindingMember = value }

  get allowPaging() { return this.dataModel.allowPaging ? this.dataModel.allowPaging : false }
  set allowPaging(value) {
    this.dataModel.allowPaging = value ? true : false;
    if(this._tfp.isDesigning && this._jqObj) {
      if(this.dataModel.allowPaging) {
        if(this._jqObj.parent().find(".tfp-datacard-footer").length>0) return;
        this.setFooter();
      } else {
        this._jqObj.parent().find(".tfp-datacard-footer").remove();
      }
    }
  }

  get pageSize() {
    return this.dataModel.pageSize ? this.dataModel.pageSize : 20
  }
  set pageSize(value) {
    this.dataModel.pageSize = value ? value : 20
  }

  get containerEl() {
    return this._jqObj.get(0);
  }

  setCptDataFormat(cdm) {
    if (!cdm) return;
    if (cdm.dataBindingFormat) {
      cdm.value = cdm.dataBindingFormat;
    }
    if (cdm.components && cdm.components.length > 0) {
      for (var i = 0; i < cdm.components.length; i++) {
        this.setCptDataFormat(cdm.components[i]);
      }
    }
  }

  /**
   * 动态创建子组件
   * @param  {[type]} cdm [description]
   * @return {[type]}     [description]
   */
  createChildCpt(parent, cdm, cardIndex, data) {
    let newId = this.id + "_" + cdm.id + "_" + cardIndex;
    $("#" + cdm.id).attr("id", newId);
    cdm.id = newId;
    var cptClass = this._tfp.controllers[cdm.type];

    if (!cptClass) {
      console.log("未找到名为[" + cdm.type + "]的组件控制器！");
      return;
    }

    var cpt = new cptClass(this._tfp, cdm, parent);
    window[cpt.id] = cpt;
    cpt._jqObj = $("#" + cpt.id);
    if (cpt._jqObj.length > 0) cpt.el = cpt._jqObj[0];

    this._tfp.bindCptData(cpt, data);
    this._tfp.initCptRuntime(cpt);

    if (!cdm.components || cdm.components.length == 0) return;

    for (var i = 0; i < cdm.components.length; i++) {
      this.createChildCpt(cpt, cdm.components[i], cardIndex, data);
    }
    return cpt;
  }

  /**
   * 添加卡片
   * @param {*} cardData 
   * @param {*} cardIndex 
   * @returns 
   */
  addCard(cardData, cardIndex) {
    if (!cardIndex && cardIndex != 0) {
      this.dataList.push(cardData);
      cardIndex = this.dataList.length;
    }
    if (this.dataModel.onBeforeAddCard) {
      try {
        let ret = eval(this.dataModel.onBeforeAddCard);
        if (ret) cardData = ret;
      } catch (err) {
        console.log(err);
      }
    }

    var dataCardHtml = this.templateHtml + "";
    dataCardHtml = dataCardHtml.replace(" id=\"" + this.id + "\"", "");
    try {
      dataCardHtml = this._tfp.replaceDataField(cardData, dataCardHtml);
      dataCardHtml = this._tfp.exeExpress(dataCardHtml);
    } catch (e) {
      console.log(e);
      return;
    }
    this.parentEl.append(dataCardHtml);

    let newCard = {
      index: cardIndex,
      components: []
    };

    let cdmNew = JSON.parse(JSON.stringify(this.templateCdm));
    for (var j = 0; j < cdmNew.components.length; j++) {
      let cdmChild = cdmNew.components[j];
      let cptChild = this.createChildCpt(this, cdmChild, cardIndex, cardData);
      newCard.components.push(cptChild);
    }

    var newCardEl = this.parentEl.find(".tfp-datacard").last();
    newCardEl.show();
    newCard._jqObj = newCardEl;
    this.cards.push(newCard);

    var that = this;

    if (this.templateCdm.onDblClick) {
      newCardEl.dblclick(function () {
        let cardIndex = $(this).index();
        let cardData = that.dataList[cardIndex];
        try {
          eval(that.templateCdm.onDblClick);
        } catch (err) {
          console.log(err);
        }
      });
    } else if (this.templateCdm.onClick) {
      newCardEl.click(function () {
        let cardIndex = $(this).index();
        let cardData = that.dataList[cardIndex];
        try {
          eval(that.templateCdm.onClick);
        } catch (err) {
          console.log(err);
        }
      });
    }

    if (this.templateCdm.onMouseOver) {
      newCardEl.mouseover(function () {
        let cardIndex = $(this).index();
        let cardData = that.dataList[cardIndex];
        try {
          eval(that.templateCdm.onMouseOver);
        } catch (err) {
          console.log(err);
        }
      });
    }

    if (this.templateCdm.onMouseOut) {
      newCardEl.mouseout(function () {
        let cardIndex = $(this).index();
        let cardData = that.dataList[cardIndex];
        try {
          eval(that.templateCdm.onMouseOut);
        } catch (err) {
          console.log(err);
        }
      });
    }

    if (this.templateCdm.onAfterAddCard) {
      try {
        eval(this.templateCdm.onAfterAddCard);
      } catch (err) {
        console.log(err);
      }
    }
  }

  updateCardCptData(cpt, cardData) {
    this._tfp.bindCptData(cpt, cardData);
    if(cpt.components && cpt.components.length>0) {
      for(let i=0;i<cpt.components.length;i++) {
        this.updateCardCptData(cpt.components[i], cardData);
      }
    }
  }

  /**
   * 修改卡片
   * @param {*} cardIndex 
   * @param {*} cardData 
   * @returns 
   */
  updateCard(cardIndex, cardData) {
    if (this.templateCdm.onBeforeUpdateCard) {
      try {
        eval(this.templateCdm.onBeforeUpdateCard);
      } catch (err) {
        console.log(err);
      }
    }

    if(cardIndex>=this.dataList.length) return;
    this.dataList[cardIndex] = cardData;
    let card = this.cards[cardIndex];
    for(let i=0;i<card.components.length;i++) {
      this.updateCardCptData(card.components[i], cardData);
    }

    if (this.templateCdm.onAfterUpdateCard) {
      try {
        eval(this.templateCdm.onAfterUpdateCard);
      } catch (err) {
        console.log(err);
      }
    }
  }

  /**
   * 移除卡片
   * @param {*} cardIndex 
   * @returns 
   */
  removeCard(cardIndex) {
    if (this.templateCdm.onBeforeRemoveCard) {
      try {
        eval(this.templateCdm.onBeforeRemoveCard);
      } catch (err) {
        console.log(err);
      }
    }

    if(cardIndex>=this.dataList.length) return;
    this.dataList.splice(cardIndex, 1);
    this.cards.splice(cardIndex, 1);
    this.parentEl.find(".tfp-datacard").eq(cardIndex).remove();

    if (this.templateCdm.onAfterRemoveCard) {
      try {
        eval(this.templateCdm.onAfterRemoveCard);
      } catch (err) {
        console.log(err);
      }
    }
  }

  /**
   * 获得卡片内指定id的组件
   * @param {*} cardIndex 
   * @param {*} cptDesignId 
   * @returns 
   */
  getCptInCard(cardIndex, cptDesignId) {
    let cptNewId = this.id + "_" + cptDesignId + "_" + cardIndex;
    return this._tfp.get(cptNewId);
  }

  /**
   * 绑定数据
   * @param {*} data 
   * @returns 
   */
  bindData(data) {
    if (!data || !Array.isArray(data)) return;
    this.dataList = data;
    this.parentEl.find('.tfp-datacard').remove();

    if (this.dataModel.onBeforeBindData) {
      try {
        eval(this.dataModel.onBeforeBindData);
      } catch (err) {
        console.log(err);
      }
    }

    for (var i = 0; i < data.length; i++) {
      let cardData = data[i];
      cardData._index = i;
      this.addCard(cardData, i);
    }

    this.parentEl.get(0).scrollTop = 0;

    if (this.dataModel.onAfterBindData) {
      try {
        eval(this.dataModel.onAfterBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  setPageButton() {
    if(!this.dataModel.allowPaging) return;
    let footerDiv = this.parentEl.parent().children(".tfp-datacard-footer");
    let arr = [];
    let index = parseInt(this.curPage);
    while (index > 0 && arr.length < 3) {
      arr.unshift(index);
      index--;
    }
    index = parseInt(this.curPage) + 1;
    while (arr.length < 5 && index <= this.pageCount) {
      arr.push(index);
      index++;
    }
    for (let i = 0; i < arr.length; i++) {
      let btn = footerDiv.find(".tfp-datacard-footer-page").eq(i);
      btn.html(arr[i]);
      btn.attr("title", "跳转到第" + arr[i] + "页");
      if (arr[i] == parseInt(this.curPage)) {
        btn.css("background-color", "#4E6EF2");
        btn.css("color", "#FFFFFF");
      } else {
        btn.css("background-color", "");
        btn.css("color", "");
      }
      btn.show();
    }
    for (let i = arr.length; i < 5; i++) {
      let btn = footerDiv.find(".tfp-datacard-footer-page").eq(i);
      btn.html("");
      btn.attr("title", "");
      btn.hide();
    }
  }

  /**
   * 跳转到指定页面
   * @param {*} toPage 
   */
  gotoPage(toPage) {
    this.loadData(toPage);
  }

  /**
   * 加载数据
   * @param {*} toPage 
   * @returns 
   */
  loadData(toPage) {
    var args = {};
    if (this.allowPaging) {
      args = {
        pageSize: this.pageSize,
        toPage: toPage ? toPage : 1
      };
    }
    super.loadData(args);
  }

  onLoadData(req, res) {
    var data = [];
    if (this.dataModel.dataBindingMember) {
      data = res[this.dataModel.dataBindingMember];
    } else if(this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      data = res[this.dataModel.dataQuerySetting.dataMember];
    }
    if (!data) return;
    if (data.rows) {
      this.curPage = data.toPage;
      this.rowsCount = data.rowsCount;
      this.pageCount = data.pageCount;
      this.pageSize = data.pageSize;
      this.setPageButton();
      this.bindData(data.rows);
    } else {
      if (!Array.isArray(data)) data = [data];
      this.curPage = 1;
      this.rowsCount = data.length;
      this.pageCount = 1;
      this.pageSize = data.length;
      this.bindData(data);
    }
  }

  setFooter() {
    this._jqObj.parent().append("<div class=\"tfp-datacard-footer\">\r\n"
        + "<div class=\"tfp-datacard-footer-first\" title=\"首页\">&lt;&lt;</div>"
        + "<div class=\"tfp-datacard-footer-prev\" class=\"tfp-datacard-footer-first\" title=\"上一页\">&lt;</div>"
        + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>"
        + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>"
        + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>"
        + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>"
        + "<div class=\"tfp-datacard-footer-page\" title=\"\"></div>"
        + "<div class=\"tfp-datacard-footer-next\" title=\"下一页\">&gt;</div>"
        + "<div class=\"tfp-datacard-footer-last\" title=\"最后一页\">&gt;&gt;</div></div>");
  }

  initDesigning() {
    if(this.dataModel.allowPaging) this.setFooter();
  }

  initRuntime() {
    let that = this;
    this.parentEl = this._jqObj.parent();
    if(this.dataModel.allowPaging) {
      this._jqObj.parent().append("<div class=\"tfp-datacard-container\"></div>");
      this.parentEl = this._jqObj.parent().children(".tfp-datacard-container");
      let position = this._jqObj.parent().css("position");
      if(!position) this._jqObj.parent().css("position", "relative");
      this.setFooter();

      let divFooter = this._jqObj.parent().children(".tfp-datacard-footer");
      divFooter.find(".tfp-datacard-footer-first").click(function () {
        that.gotoPage(1);
      });
      divFooter.find(".tfp-datacard-footer-prev").click(function () {
        var prevPage = that.curPage - 1;
        if (prevPage < 1) prevPage = 1;
        that.gotoPage(prevPage);
      });
      divFooter.find(".tfp-datacard-footer-next").click(function () {
        var nextPage = that.curPage + 1;
        if (nextPage > that.pageCount) nextPage = that.pageCount;
        that.gotoPage(nextPage);
      });
      divFooter.find(".tfp-datacard-footer-last").click(function () {
        that.gotoPage(that.pageCount);
      });
      divFooter.find(".tfp-datacard-footer-page").click(function () {
        let toPage = parseInt($(this).html());
        if (toPage == that.curPage) return;
        divFooter.find(".tfp-datacard-footer-page").css("background-color", "");
        divFooter.find(".tfp-datacard-footer-page").css("color", "");
        $(this).css("background-color", "#4E6EF2");
        $(this).css("color", "#FFFFFF");
        that.gotoPage(toPage);
      });
    }
    if(this._jqObj.length>0) this.templateHtml = this._jqObj.get(0).outerHTML;
    this.templateCdm = JSON.parse(JSON.stringify(this.dataModel));
    this.dataModel.components = [];

    this._jqObj.remove();
    this.parentEl.children(".tfp-datacard").remove();
    
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService 
      || (this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData();
    } else if(this.dataModel.dataList) {
      this.bindData(this.dataModel.dataList);
    }
  }
}