import { FormInput } from "../controller.js";

/**
 * 颜色选择组件
 * @param {[type]} dataModel [description]
 */
export default class ColorPicker extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "ColorPicker", dataModel, parent);
  }

  get value() { return this.dataModel.value ? this.dataModel.value : "" }
  set value(value) {
    this.dataModel.value = value;

    if (this._jqObj) this._jqObj.css("backgroundColor", value);

    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  colorPicker() {
    var that = this;
    var ColorHex = new Array('00', '33', '66', '99', 'CC', 'FF');
    var SpColorHex = new Array('FF0000', '00FF00', '0000FF', 'FFFF00', '00FFFF', 'FF00FF');
    var imgDirClear = this._tfp.rootPath + "/src/components/colorpicker/images/clear.png";
    var imgDirClose = this._tfp.rootPath + "/src/components/colorpicker/images/close.png";
    if (this._tfp.curPage.bgColorMode == 'dark') {
      imgDirClear = this._tfp.rootPath + "/src/components/colorpicker/images/clear_dark.png";
      imgDirClose = this._tfp.rootPath + "/src/components/colorpicker/images/close_dark.png";
    }
    this.popDiv = null;
    this.cptEl = null;
    this.cbSetVal = null;

    $("body").append("<div id=\"" + this.id + "-colorPickerDiv\" class=\"color-picker-pop-div\" "
      + "style=\"position: absolute;z-index: 10000;top: 0;left: 0;padding: 10px;"
      + "border: 1px solid #999999;width: 252px;height: 175px;padding: 0;border-radius: 0;"
      + "background-color: #333333;display: none;box-shadow: 1px 1px 1px #000000;\">"
      + "<div style=\"width: 100%;height: 30px;line-height: 30px;color: #ffffff;clear: both;"
      + "font-size: 14px;\"><label style=\"float: left; margin-left:5px;\">当前颜色：</label>"
      + "<div class=\"color-panel\" title=\"颜色值\" data-value=\"#000000\" style=\"float: left; "
      + "width:50px; height: 18px; margin-top: 5px; border: 1px solid #999999; "
      + "background-color:#000000;\"></div><input class=\"color-value\" data-type=\"h\" "
      + "type=\"text\" maxlength=\"7\" style=\"width: 70px; margin-left:5px; background-color: "
      + "#222222;outline:0;height: 20px;margin-top: 5px;border: 1px solid #999999; color:#FFFFFF;\" />"
      + "<img src=\"" + imgDirClear + "\" style=\"cursor: pointer; vertical-align:middle; "
      + "margin-left:10px;\" title=\"清空\"/>"
      + "<img src=\"" + imgDirClose + "\" title=\"关闭\" style=\"cursor: pointer; "
      + "vertical-align:middle; margin-left:5px;\"/>"
      + "</div><div class=\"color-table\" style=\"height:150px; width:253px;\"></div></div>");

    this.popDiv = $("#" + this.id + "-colorPickerDiv");
    var htmlStr = '<table border="1" cellspacing="0" cellpadding="0" '
      + 'style="border-collapse: collapse;cursor:pointer;border:1px solid #999999;">';
    var colorValue = '';

    for (var i = 0; i < 2; i++) {
      for (var j = 0; j < 6; j++) {
        htmlStr = htmlStr + '<tr height=12>';
        htmlStr = htmlStr + '<td width=12 data-color="#000000" style="background-color:#000000">';
        colorValue = i == 0 ? ColorHex[j] + ColorHex[j] + ColorHex[j] : SpColorHex[j];
        htmlStr = htmlStr + '<td width=12 data-color="#' + colorValue + '" style="background-color:#' + colorValue + '">';
        htmlStr = htmlStr + '<td width=12 data-color="#000000" style="background-color:#000000">';

        for (var k = 0; k < 3; k++) {
          for (var l = 0; l < 6; l++) {
            colorValue = ColorHex[k + i * 3] + ColorHex[l] + ColorHex[j];
            htmlStr = htmlStr + '<td width=12 data-color="#' + colorValue + '" style="background-color:#' + colorValue + '">';
          }
        }
      }
    }

    this.popDiv.find(".color-table").empty();
    this.popDiv.find(".color-table").append(htmlStr);
    this.popDiv.find(".color-value").click(function () {
      event.stopPropagation();
    });
    this.popDiv.find(".color-value").bind("keydown", function (e) {
      var theEvent = e || window.event;
      var code = theEvent.keyCode || theEvent.which || theEvent.charCode;
      var color = $(this).val().trim();
      var type = "^#[0-9a-fA-F]{6}$";
      var re = new RegExp(type);
      if (color.match(re) == null) return;

      if (code == 13) {
        that.setColor(color);
        that.close();
      } else {
        that.popDiv.find(".color-panel").css("background", color);
      }
    });
    this.popDiv.find("td").click(function () {
      var color = $(this).attr("data-color");
      that.popDiv.find(".color-panel").attr("data-value", "");
      that.popDiv.find(".color-panel").css("background", color);
      that.popDiv.find(".color-value").val($(this).attr("data-color"));
      that.setColor(color);
    });
    this.popDiv.find("td").mouseover(function () {
      var color = $(this).attr("data-color");
      that.popDiv.find(".color-panel").css("background", color);
      that.popDiv.find(".color-value").val($(this).attr("data-color"));
    });
    this.popDiv.find("img").eq(0).click(function () {
      that.clear()
      event.stopPropagation();
    })
    this.popDiv.find("img").eq(1).click(function () {
      that.close()
      event.stopPropagation();
    })

    this.setColor = function (color) {
      if (this.cptEl) {
        this.cptEl.css("background", color);
        this.cptEl.attr("style-setting-value", color);
        this.cptEl.attr("data-color", color);
        this.cptEl = null;
      }
      if (this.cbSetVal) this.cbSetVal(color);
    };

    this.clear = function () {
      this.setColor("");
      this.close();
    };

    this.close = function () {
      that.popDiv.hide();
      document.removeEventListener("click", this.close);
    };
  }

  show(cptEl, cb) {
    this.colorPicker();
    this.cptEl = cptEl;
    this.cbSetVal = cb;
    var top = this.cptEl.offset().top + this.cptEl.height() + 3;
    if (top + 165 > document.documentElement.clientHeight) top = document.documentElement.clientHeight - 185;
    var left = this.cptEl.offset().left;
    if (left + 242 > document.documentElement.clientWidth) left = document.documentElement.clientWidth - 262;
    this.popDiv.css("top", top + "px");
    this.popDiv.css("left", left + "px");
    this.popDiv.show();
    document.addEventListener("click", this.close);
    event.stopPropagation();
  };

  initRuntime() {
    let that = this;
    if (this.dataModel.value) this._jqObj.css("backgroundColor", this.dataModel.value);

    this._jqObj.click(function () {
      if (that.dataModel.readonly || that.dataModel.disabled) return;
      that.show($(this), function (color) {
        this.value = color;
      });
    })
  }

  initDesigning() {
    if (this.dataModel.value) this._jqObj.css("backgroundColor", this.dataModel.value);
  }
}