import TFPComponentRender from "../render.js";

export default class CollapseItemRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let bodyHtml = indent + "<div class='tfp-collapseitem-title'><label>" + (this.dataModel.title ? this.dataModel.title : '') + "</label>";
    if (this._tfp.isDesigning) bodyHtml += "<div class='tfp-collapseitem-arrow-down' id='tfp-collapseitem-arrow'></div>";
    else bodyHtml += "<div class='tfp-collapseitem-arrow-right' id='tfp-collapseitem-arrow'></div>";
    bodyHtml += "</div>\r\n";
    bodyHtml += indent + "<div class='tfp-collapseitem-panel'>";
    if (this.dataModel.components && getComponentsHtml) {
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t</div>\r\n";
    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}