import { ContainerComponent } from "../controller.js";

/**
 * 选项面板组件
 * @param {[type]} dataModel [description]
 */
export default class CollapseItem extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "CollapseItem", dataModel, parent);
  }

  get title() { return this.dataModel.title ? this.dataModel.title : "" }
  set title(value) {
    this.dataModel.title = value;
    if (this._jqObj) {
      this._jqObj.children(".tfp-collapseitem-title").find("label").text(value);
    }
  }

  get containerEl() {
    return this._jqObj.children(".tfp-collapseitem-panel").get(0);
  }

  get hasAttachedChilds() {
    return true
  }
}