export default {
  "name": "Collapse",
  "comment": "折叠面板",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "列表设置",
      "type": "group",
      "items": [
        {
          "name": "options",
          "comment": "选项设置",
          "type": "Dataset",
          "columns": [
            {
              "id": "id",
              "name": "ID",
              "type": "String",
              "width": "150px",
              "readonly": true
            },
            {
              "id": "title",
              "name": "标题",
              "type": "String",
              "width": "370px",
              "required": true
            }
          ]
        },
        {
          "name": "organMode",
          "comment": "手风琴模式",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "580px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }
  ],
  "methods": [
      {
        "name": "unfoldItem",
        "comment": "展开元素",
        "args": [
          {
            "name": "index",
            "comment": "元素索引",
            "type": "Int",
            "required": true
          }
        ]
      },
      {
        "name": "unfoldAll",
        "comment": "展开所有元素"
      },
      {
        "name": "foldItem",
        "comment": "折叠元素",
        "args": [
          {
            "name": "index",
            "comment": "元素索引",
            "type": "Int",
            "required": true
          }
        ]
      },
      {
        "name": "foldAll",
        "comment": "折叠所有元素"
      }
    ]
}