import { ContainerComponent } from "../controller.js";

/**
 * 折叠面板组件
 * @param {[type]} dataModel [description]
 */
export default class Collapse extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Collapse", dataModel, parent);

    if (!this.dataModel.components || this.dataModel.components.length == 0) {
      this.dataModel.components = [{
        id: this.id + "_item1",
        title: "collapse1",
        type: "CollapseItem",
        isAttached: true,
        styles: {
          height: "150px"
        }
      }, {
        id: this.id + "_item2",
        title: "collapse2",
        type: "CollapseItem",
        isAttached: true,
        styles: {
          height: "150px"
        }
      }];
    }
  }

  // 选项
  get options() {
    var options = [];
    for (var i = 0; i < this.dataModel.components.length; i++) {
      let collapseItemlDM = this.dataModel.components[i];
      options.push({ id: collapseItemlDM.id, type: "CollapseItem", title: collapseItemlDM.title });
    }
    return options;
  }
  set options(value) {
    let items = [];
    if (value) items = value;
    let collapseItemls = [];
    for (var i = 0; i < items.length; i++) {
      let item = items[i];
      let cdm = null;
      if (item.id) {
        let collapseIteml = this._tfp.components[item.id];
        cdm = collapseIteml.dataModel;
        cdm.title = item.title;
        delete this._tfp.components[collapseIteml.id];
      } else {
        cdm = {
          type: "CollapseItem",
          isAttached: true,
          title: item.title,
          styles: {
            height: "150px"
          }
        };
      }
      collapseItemls.push(cdm);
    }
    this.dataModel.components = collapseItemls;
    this._jqObj.remove();
    this.render();
  }

  //手风琴模式
  get organMode() { return this.dataModel.organMode }
  set organMode(value) {
    this.dataModel.organMode = value ? true : false;
  }

  get containerEl() {
    return this._jqObj.get(0);
  }

  get hasAttachedChilds() {
    return true
  }

  /**
   * 展开元素
   * @param {} index 
   */
  unfoldItem(index) {
    let item = this._jqObj.children(".tfp-collapseitem").eq(index);
    let title = item.children(".tfp-collapseitem-title");
    let n = title.data('n');
    if (n % 2 == 1) return;
    item.removeClass("tfp-collapseitem-hide");
    title.children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-down');
    title.data({ n: n + 1 });
    if (this.dataModel.organMode) {
      item.siblings(".tfp-collapseitem").addClass("tfp-collapseitem-hide");
      item.siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
      item.siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").data({ n: 0 });
    }
  }

  /**
   * 展开所有元素
   */
  unfoldAll() {
    if (this.dataModel.organMode) return;
    for(let i=0; i<this._jqObj.children(".tfp-collapseitem").length; i++) {
      this.unfoldItem(i);
    }
  }

  /**
   * 折叠元素
   * @param {} index 
   */
  foldItem(index) {
    let item = this._jqObj.children(".tfp-collapseitem").eq(index);
    let title = item.children(".tfp-collapseitem-title");
    let n = title.data('n');
    if (n % 2 == 0) return;
    item.addClass("tfp-collapseitem-hide");
    title.children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
    title.data({ n: n + 1 });
    if (this.dataModel.organMode) item.siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").data({ n: 0 });
  }

  /**
   * 折叠所有元素
   */
  foldAll() {
    if (this.dataModel.organMode) return;
    for(let i=0; i<this._jqObj.children(".tfp-collapseitem").length; i++) {
      this.foldItem(i);
    }
  }

  collapseOnChange() {
    let that = this;
    this._jqObj.find(".tfp-collapseitem").addClass("tfp-collapseitem-hide");
    this._jqObj.find('.tfp-collapseitem-title').data({ n: 0 });
    this._jqObj.find('.tfp-collapseitem-title').click(function () {
      let n = $(this).data('n');
      if (n % 2 == 1) {
        $(this).parent().addClass("tfp-collapseitem-hide");
        $(this).children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
      } else {
        $(this).parent().removeClass("tfp-collapseitem-hide");
        $(this).children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-down');
        if (that.dataModel.organMode) {
          $(this).parent().siblings(".tfp-collapseitem").addClass("tfp-collapseitem-hide");
          $(this).parent().siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").children("#tfp-collapseitem-arrow").attr('class', 'tfp-collapseitem-arrow-right');
        }
      }
      $(this).data({ n: n + 1 });
      if (that.dataModel.organMode) $(this).parent().siblings(".tfp-collapseitem").children(".tfp-collapseitem-title").data({ n: 0 });
    });
  }

  initRuntime() {
    this.collapseOnChange();
  }
}