import TFPComponentRender from '../render.js'

export default class ColRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    if (getComponentsHtml) {
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent, retainStyleAttr);
    }
    return bodyHtml + indent;
  }


  getAttrClass() {
    let c = "";
    if (this.dataModel.colWidth) c += "tfp-col-" + this.dataModel.colWidth;
    if (this.dataModel.colOffset) c += ' tfp-col-offset-' + this.dataModel.colOffset + ' ';
    if (this.dataModel.colPull) c += ' tfp-col-pull-' + this.dataModel.colPull + ' ';
    if (this.dataModel.colPush) c += ' tfp-col-push-' + this.dataModel.colPush + ' ';
    return c;
  }


  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}