import { ContainerComponent } from "../controller.js";

/**
 * 栅格列组件
 * @param {[type]} dataModel [description]
 */
export default class Col extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Col", dataModel, parent);
  }

  get colWidth() { return this.dataModel.colWidth }

  set colWidth(value) {
    this.dataModel.colWidth = value;
    if (this._jqObj) {
      this._jqObj.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-col-') >= 0) return ss[s];
        }
        return "";
      });
      if (value) this._jqObj.addClass("tfp-col-" + value);
    }
  }

  get colOffset() { return this.dataModel.colOffset }

  set colOffset(value) {
    this.dataModel.colOffset = value;
    if (this._jqObj) {
      this._jqObj.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-coloffset-') >= 0) return ss[s];
        }
        return "";
      });
      if (value) this._jqObj.addClass("tfp-coloffset-" + value);
    }
  }

  get colPull() { return this.dataModel.colPull }

  set colPull(value) {
    this.dataModel.colPull = value;
    if (this._jqObj) {
      this._jqObj.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-colpull-') >= 0) return ss[s];
        }
        return "";
      });
      if (value) this._jqObj.addClass("tfp-colpull-" + value);
    }
  }

  get colPush() { return this.dataModel.colPush }

  set colPush(value) {
    this.dataModel.colPush = value;
    if (this._jqObj) {
      this._jqObj.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-colpush-') >= 0) return ss[s];
        }
        return "";
      });
      if (value) this._jqObj.addClass("tfp-colpush-" + value);
    }
  }

}