export default {
  "name": "CKEditor",
  "comment": "富文本",
  "cssFiles": [
    "style.css"
  ],
  "jsFiles": [
    {
      "src": "/inc/ckeditor5/build/ckeditor_37.1.0.js",
      "onlyRuntime": true
    }
  ],
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "文本内容",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "showMode",
          "comment": "显示模式",
          "type": "Select",
          "default": "default",
          "options": [
            {
              "value": "default",
              "text": "默认模式"
            },
            {
              "value": "compact",
              "text": "简洁模式"
            }
          ]
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "compressImage",
          "comment": "压缩图片",
          "type": "Switch",
          "default": true
        },
        {
          "name": "imageMaxSize",
          "comment": "图片最大尺寸",
          "type": "Number",
          "required": true,
          "default": "960"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "320px",
    "position": "relative"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onFocus",
      "comment": "获得焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onBlur",
      "comment": "失去焦点时",
      "isNotHtmlEvent": true
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}