import { FormInput } from "../controller.js";

/*
class CKEditorUploadAdapter {
  constructor(loader, cptModel) {
    // CKEditor 5's FileLoader instance.
    this.loader = loader;
    this.cptModel = cptModel;

    // URL where to send files.
    this.url = '/Upload?appCode=CKEditor';

    this.loader.file.then((file) => {
      if (file.type.indexOf("image/") == 0) {
        if (cptModel.compressImage) this.url += "&compressImage=true";
        if (cptModel.imageMaxSize) this.url += "&maxSize=" + cptModel.imageMaxSize;
      }
    });
  }

  // Starts the upload process.
  upload() {
    return new Promise((resolve, reject) => {
      this._initRequest();
      this._initListeners(resolve, reject);
      this._sendRequest();
    });
  }

  // Aborts the upload process.
  abort() {
    if (this.xhr) {
      this.xhr.abort();
    }
  }

  // Example implementation using XMLHttpRequest.
  _initRequest() {
    const xhr = this.xhr = new XMLHttpRequest();

    let uploadUrl = this.url;
    try {
      if (top.taskMsgAuthObj) uploadUrl = tfp.setUrlAuthData(uploadUrl);
    } catch (err) {
      try {
        if (window.parent.taskMsgAuthObj) uploadUrl = tfp.setUrlAuthData(uploadUrl);
      } catch (err2) {
        //
      }
    }
    this.url = uploadUrl;

    xhr.open('POST', this.url, true);
    xhr.responseType = 'json';
  }

  // Initializes XMLHttpRequest listeners.
  _initListeners(resolve, reject) {
    const xhr = this.xhr;
    const loader = this.loader;
    const genericErrorText = '文件上传失败：' + ` ${loader.file.name}。`;

    xhr.addEventListener('error', () => reject(genericErrorText));
    xhr.addEventListener('abort', () => reject());
    xhr.addEventListener('load', () => {
      const response = xhr.response;

      if (!response || response.error) {
        return reject(response && response.error ? response.error.message : genericErrorText);
      }

      // If the upload is successful, resolve the upload promise with an object containing
      // at least the "default" URL, pointing to the image on the server.
      resolve({
        default: response.url
      });
    });

    if (xhr.upload) {
      xhr.upload.addEventListener('progress', evt => {
        if (evt.lengthComputable) {
          loader.uploadTotal = evt.total;
          loader.uploaded = evt.loaded;
        }
      });
    }
  }

  // Prepares the data and sends the request.
  _sendRequest() {
    const data = new FormData();
    this.loader.file.then((file) => {
      data.append('file', file);
      this.xhr.send(data);
    });
  }
}*/

/**
 * 富文本组件
 * @param {[type]} dataModel [description]
 */
export default class CKEditor extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "CKEditor", dataModel, parent);
  }

  //属性
  get value() {
    if (!this._tfp.isDesigning && this.editor) this.dataModel.value = this.editor.getData();
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj && !this._tfp.isDesigning && this.editor) {
      this.editor.setData(value);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) {
    this.dataModel.dataBindingFormat = value;
  }

  get showMode() { return this.dataModel.showMode ? this.dataModel.showMode : "default" }
  set showMode(value) {
    this.dataModel.showMode = value == "compact" ? "compact" : "default";
    if (this._jqObj && this._tfp.isDesigning) {
      this._jqObj.empty();
      this._jqObj.html(this.getDesigningHtml());
    }
  }

  //是否只读
  get readonly() { return this.dataModel.readonly ? true : false }
  set readonly(value) {
    this.dataModel.readonly = value ? true : false;
    if (!this.dataModel.readonly) delete this.dataModel.readonly;
    if (this._jqObj && this._tfp.isDesigning) {
      this._jqObj.empty();
      this._jqObj.html(this.getDesigningHtml());
    }
  }

  //是否压缩图片
  get compressImage() { return this.dataModel.compressImage ? true : false }
  set compressImage(value) {
    this.dataModel.compressImage = value ? true : false;
  }

  get imageMaxSize() { return this.dataModel.imageMaxSize }
  set imageMaxSize(value) {
    this.dataModel.imageMaxSize = value;
  }

  /*getUploadAdapterPlugin(editor) {
    editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
      let cptId = editor.sourceElement.id;
      cptId = cptId.substring(0, cptId.lastIndexOf("_editor"));
      let cptModel = tfp.components[cptId].dataModel;
      return new CKEditorUploadAdapter(loader, cptModel);
    };
  }*/

  getDesigningHtml() {
    let showMode = this.showMode;
    if (this._tfp.curPage.bgColorMode == 'dark') {
      showMode == "compact" ? showMode = "compact-dark" : showMode = "default-dark";
    }
    if (this.dataModel.readonly) return "";
    let bgImg = this._tfp.rootPath + "/src/components/"
      + this.dataModel.type.toLowerCase() + "/images/"
      + showMode + ".png";
    let toolbarHeight = 76;
    if (this.dataModel.showMode == "compact") toolbarHeight = 38;
    let html = "<div style=\"width:100%;height:" + toolbarHeight + "px;background-repeat:no-repeat;background-image:url("
      + bgImg + ");position:absolute;z-index:1;top:0;border-bottom:1px solid #cccccc;\"></div>";
    html += "<div style=\"position:absolute;z-index:1;width:100%;top:" + toolbarHeight + "px;bottom:0;\"></div>";
    return html;
  }

  initRuntime() {
    var that = this;

    //如果是只读或者禁用
    if (this.dataModel.readonly || that.dataModel.disabled) {
      CKEditorCreater.createReadonly(this._jqObj.children("div").get(0), function (editor) {
        that.editor = editor;

        if (that.dataModel.value) editor.setData(that.dataModel.value);
        editor.enableReadOnlyMode('feature-id');
        that._jqObj.find(".ck.ck-editor__editable_inline").css("border", "0");
      });
      /*CKSource.Editor.create(this._jqObj.children("div").get(0), {
        removePlugins: [ 'Title', 'Toolbar'],
        toolbar: {
          items: []
        }
      }).then(editor => {
        that.editor = editor;
  
        if (that.dataModel.value) editor.setData(that.dataModel.value);
        editor.enableReadOnlyMode('feature-id');
        that._jqObj.find(".ck.ck-editor__editable_inline").css("border", "0");
      }).catch(error => {
        console.log(error);
      });*/
      return;
    }

    var toolbar = [];

    if (this.dataModel.showMode == "compact" || this.dataModel.showMode == "compact-dark") {
      CKEditorCreater.createCompact(this._jqObj.children("div").get(0), function (editor) {
        that.onCreateEditor(editor);
      });
      /*toolbar = ['undo', 'redo', '|', 'alignment',
      '|', 'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor',
      '|', 'bold', 'italic', 'underline', 'strikethrough',
      '|', 'bulletedList', 'numberedList', 'outdent', 'indent']; */
    } else {
      CKEditorCreater.create(this._jqObj.children("div").get(0), function (editor) {
        that.onCreateEditor(editor);
      });
      /*toolbar = ['undo', 'redo', '|', 'heading', '|', 'alignment',
      'fontSize', 'fontFamily', 'fontColor', 'fontBackgroundColor', '|', 
      'bold', 'italic', 'underline', 'strikethrough', '|','findAndReplace', 'selectAll','removeFormat',   '-',  
      'outdent', 'indent','bulletedList', 'numberedList', 
      '|', 'subscript', 'superscript', 'code', 
      '|', 'specialCharacters', 'horizontalLine', '|', 
      'link', 'imageInsert', 'insertTable', 'highlight', 'blockQuote', 
      'mediaEmbed', 'codeBlock', 'htmlEmbed', 'sourceEditing'];*/
    }

    //工具栏可配置项
    /*['alignment:left', 'alignment:right', 'alignment:center', 'alignment:justify', 'alignment', 'undo', 'redo', 
    'blockQuote', 'bold', 'code', 'codeBlock', 'selectAll', 'findAndReplace', 'fontBackgroundColor', 'fontColor', 
    'fontFamily', 'fontSize', 'heading', 'highlight:yellowMarker', 'highlight:greenMarker', 'highlight:pinkMarker', 
    'highlight:blueMarker', 'highlight:redPen', 'highlight:greenPen', 'removeHighlight', 'highlight', 'horizontalLine', 
    'htmlEmbed', 'imageTextAlternative', 'toggleImageCaption', 'uploadImage', 'imageUpload', 'insertImage', 'imageInsert', 
    'resizeImage:original', 'resizeImage:25', 'resizeImage:50', 'resizeImage:75', 'resizeImage', 'imageResize', 
    'imageStyle:inline', 'imageStyle:alignLeft', 'imageStyle:alignRight', 'imageStyle:alignCenter', 
    'imageStyle:alignBlockLeft', 'imageStyle:alignBlockRight', 'imageStyle:block', 'imageStyle:side', 
    'imageStyle:wrapText', 'imageStyle:breakText', 'indent', 'outdent', 'italic', 'link', 'linkImage', 
    'numberedList', 'bulletedList', 'mediaEmbed', 'pageBreak', 'removeFormat', 'sourceEditing', 'specialCharacters', 
    'restrictedEditingException', 'strikethrough', 'style', 'subscript', 'superscript', 'insertTable', 'tableColumn', 
    'tableRow', 'mergeTableCells', 'toggleTableCaption', 'tableCellProperties', 'tableProperties', 'textPartLanguage', 
    'todoList', 'underline']*/

    /*CKSource.Editor.create(this._jqObj.children("div").get(0), {
      removePlugins: [ 'Title' ],
      toolbar: {
        items: toolbar,
        shouldNotGroupWhenFull: true
      },
      extraPlugins: [this.getUploadAdapterPlugin]
    }).then(editor => {
      
    }).catch(error => {
      console.log(error);
    });*/
  }

  onCreateEditor(editor) {
    this.editor = editor;
    var that = this;

    if (that.dataModel.value) editor.setData(that.dataModel.value);
    if (that.dataModel.readonly || that.dataModel.disabled) editor.enableReadOnlyMode('feature-id');

    that._jqObj.find(".ck-sticky-panel").show();

    editor.editing.view.change(function (writer) {
      let contentHeight = that._jqObj.height();
      if(that.dataModel.showMode=="default") {
        contentHeight -= 79;
      } else if(that.dataModel.showMode=="compact") {
        contentHeight -= 39;
      }
      writer.setStyle('height', contentHeight+'px', editor.editing.view.document.getRoot());
    });

    editor.model.document.on('change:data', () => {
      that.valueOnChange();
      that.exeEventHandler("onChange", editor.getData());
    });

    editor.editing.view.document.on('change:isFocused', (evt, name, value) => {
      if (value) {
        eval(that.dataModel.onFocus)
      } else {
        eval(that.dataModel.onBlur)
      }
    });
  }

  initDesigning() {
    this._jqObj.css("border", "1px solid #cccccc");
  }
}