import TFPComponentRender from '../render.js'

export default class CheckBoxRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);

    if (!this._tfp.isDesigning) {
      // var vid = escape(this.dataModel.id).replaceAll("%", "");
      if (otherOptions && otherOptions.gridContainer)
        attrHtml += " name=\"" + this.dataModel.id + "_{{index}}\"";
      else
        attrHtml += " name=\"" + this.dataModel.id + "\"";
      attrHtml += " bindchange=\"bindchange_controller\"";
    }
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    if (!this.dataModel.options) return bodyHtml;
    let indent = this.getHtmlIndent();
    for (var i = 0; i < this.dataModel.options.length; i++) {
      var option = this.dataModel.options[i];
      bodyHtml += this.cpt.getOptionHtml(indent, option);
    }
    return bodyHtml + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    if (!this.dataModel.options) return cpt_wx;

    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    for (var i = 0; i < this.dataModel.options.length; i++) {
      var option = this.dataModel.options[i];
      bodyHtml += this.cpt.getOptionWx(indent, option, i);
    }
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("checkbox-group", false, parentIndent, retainStyleAttr, otherOptions);
  }
}