import TFPComponentRender from '../render.js'

export default class CheckBoxRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";

    if (this.dataModel.jsonDataSet) {
      this.dataModel.options = this.dataModel.jsonDataSet.options;
    }

    if (!this.dataModel.options) return bodyHtml;

    let indent = this.getHtmlIndent();
    if (this.dataModel.readonly) {
      let optionReadonlyHtml = this.cpt.addReadonlyOption();
      bodyHtml += optionReadonlyHtml;
    } else {
      if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') bodyHtml += indent + "\t<div class=\"tfp-checkbox-button\">\r\n";
      for (var i = 0; i < this.dataModel.options.length; i++) {
        var option = this.dataModel.options[i];

        // 按钮模式
        if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
          let optionButtonHtml = this.cpt.getButtonOptionHtml(indent + "\t", option, i);
          bodyHtml += optionButtonHtml;
          continue;
        }

        if (this.dataModel.portrait) bodyHtml += indent + "\t<div class=\"tfp-checkbox-item\">\r\n";
        let optionHtml = this.cpt.getOptionHtml(indent + "\t", option);
        if (this.dataModel.portrait) {
          optionHtml = optionHtml.replaceAll("tfp-checkbox-box", "tfp-checkbox-box tfp-checkbox-box-portrait");
          optionHtml = optionHtml.replaceAll("tfp-checkbox-label", "tfp-checkbox-label tfp-checkbox-label-portrait");
        } else {
          optionHtml = optionHtml.replaceAll("tfp-checkbox-box", "tfp-checkbox-box tfp-checkbox-box-lateral");
          optionHtml = optionHtml.replaceAll("tfp-checkbox-label", "tfp-checkbox-label tfp-checkbox-label-lateral");
        }
        bodyHtml += optionHtml;
        if (this.dataModel.portrait) bodyHtml += indent + "\t</div>\r\n";
      }

      if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') bodyHtml += indent + "\t</div>\r\n";
    }

    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}