export default {
  "name": "CheckBox",
  "comment": "多选框",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "formula",
          "comment": "自动计算表达式",
          "type": "Formula"
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Dataset",
          "default": [
            { "value": 1, "text": "选项1" },
            { "value": 2, "text": "选项2" }
          ]
        },
        {
          "name": "controlColor",
          "comment": "组件颜色",
          "type": "text", 
          "default": "#04BE02"
        },
        {
          "name": "portrait",
          "comment": "竖向显示",
          "type": "Switch",
          "special": true
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
  },
  "events": [
    {
      "name": "bindchange",
      "args": [{ 'name': 'e' }],
      "eventArgs": "",
      "comment": "值发生变化时"
    }
  ],
  "methods": [{
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }, {
    "name": "addOption",
    "comment": "添加选项",
    "args": [{
      "name": "option",
      "comment": "选项",
      "type": "Object"
    }]
  }]
}