export default {
  "name": "CheckBox",
  "comment": "多选框",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "comment",
          "comment": "组件备注",
          "type": "String"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "typeCode",
          "comment": "字典类别编码",
          "type": "Dialog",
          "inputType": "text",
          "title": "数据字典列表",
          "path": "taskbuilder-proj-manager/dataDicList.tfp",
          "width": "320px",
          "height": "480px"
        },
        {
          "name": "options",
          "comment": "选项",
          "type": "Dataset",
          "default": [
            { "value": 1, "text": "选项1" },
            { "value": 2, "text": "选项2" }
          ]
        },
        {
          "name": "showStyle",
          "comment": "显示样式",
          "type": "Select",
          "default": "defaultMode",
          "options": [
            {
              "value": "defaultMode",
              "text": "点选（默认）"
            },
            {
              "value": "checkMode",
              "text": "勾选（显示一个√）"
            },
            {
              "value": "buttonMode",
              "text": "联排方形按钮"
            },
            {
              "value": "disperseMode",
              "text": "分散椭圆按钮"
            }
          ]
        },
        {
          "name": "portrait",
          "comment": "竖向显示",
          "type": "Switch",
          "special": true
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "disabled",
          "comment": "禁用",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "encrypted",
          "comment": "加密发送",
          "type": "Switch"
        }
      ]
    },
    {
      "name": "dataSourceSetting",
      "comment": "数据源设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "valueField",
          "comment": "选项值字段",
          "type": "String",
          "showModelFieldList": true
        },
        {
          "name": "textField",
          "comment": "选项文本字段",
          "type": "String",
          "showModelFieldList": true
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "margin", "border", "other"],
  "defaultStyles": {
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }, {
      "name": "onAfterLoadData",
      "comment": "加载数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "req",
        "type": "Object",
        "comment": "请求对象"
      }, {
        "name": "res",
        "type": "Object",
        "comment": "响应对象"
      }]
    }, {
      "name": "onBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定的数据"
      }]
    }],
  "methods": [{
    "name": "addOption",
    "comment": "添加选项",
    "args": [{
      "name": "option",
      "comment": "选项",
      "type": "Object"
    }]
  }, {
    "name": "bindData",
    "comment": "绑定数据",
    "args": [{
      "name": "data",
      "comment": "数据",
      "type": "Array"
    }]
  }, {
    "name": "getOption",
    "comment": "获得指定索引的选项",
    "args": [{
      "name": "index",
      "comment": "选项索引",
      "type": "Int"
    }]
  }, {
    "name": "getOptionByValue",
    "comment": "获得指定值的选项",
    "args": [{
      "name": "val",
      "comment": "选项值",
      "type": "String"
    }]
  }, {
    "name": "getSelectedOptions",
    "comment": "获得选中的选项列表",
    "args": []
  }, {
    "name": "loadData",
    "comment": "加载数据",
    "args": []
  }, {
    "name": "setOptions",
    "comment": "设置可选项",
    "args": [{
      "name": "options",
      "comment": "可选项",
      "type": "String"
    }]
  }]
}