import { FormInput } from "../controller.js";

/**
 * 多选框组件
 * @param {[type]} dataModel [description]
 */
export default class CheckBox extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "CheckBox", dataModel, parent);
  }

  //属性
  get value() { return this.dataModel.value; }
  set value(value) {
    var self = this;
    this.dataModel.value = value;
    var vv = this.dataModel.value.split(',');

    if (this._jqObj) {
      this._jqObj.find(".wx-checkbox-input").each(function () {
        if (vv.contains($(this).attr("data-option"))) {
          $(this).attr("checked", "checked");
          $(this).css("color", self.dataModel.controlColor);

        } else {
          $(this).removeAttr("checked");
          $(this).css("color", "#ffffff");
        }
      });
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }
  get options() { return this.dataModel.options; }
  set options(value) {
    if (!value) return;
    this.setOptions(value);
    if (this._jqObj) {
      this._jqObj.empty();
      for (var i = 0; i < value.length; i++) {
        this.addOption(value[i], true);
      }
    }
  }

  get controlColor() { return this.dataModel.controlColor }
  set controlColor(value) {
    this.dataModel.controlColor = value;
  }

  // get flex () {
  //   return this.dataModel.flex;
  // }
  // set flex (value) {

  //   this.dataModel.flex = value;
  //   this._jqObj.children().each(function () {
  //     $(this).removeClass()
  //   })
  //   this._jqObj.children().addClass("checkbox-" + value + "-" + this.dataModel.alignType);
  // }
  // get alignType () {
  //   return this.dataModel.alignType;
  // }
  // set alignType (value) {
  //   this.dataModel.alignType = value;
  //   this._jqObj.children().each(function () {
  //     $(this).removeClass()
  //   })

  //   this._jqObj.children().addClass("checkbox-" + this.dataModel.flex + "-" + value);
  // }

  get portrait() { return this.dataModel.portrait }
  set portrait(value) {
    this.dataModel.portrait = value ? true : false;

    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".wx-checkbox-box").removeClass("wx-inlineblock").addClass("wx-inline");
      } else {
        this._jqObj.find(".wx-checkbox-box").removeClass("wx-inline").addClass("wx-inlineblock");
      }
    }
  }

  getOptionHtml(indent, option) {
    let optionHtml = "";
    optionHtml += indent;
    optionHtml += "\t<div class=\"wx-checkbox-box";
    if (this.dataModel.portrait) optionHtml += " wx-inline";
    else optionHtml += " wx-inlineblock";
    optionHtml += "\">";
    optionHtml += "<div class=\"wx-checkbox-input\" ";
    optionHtml += " data-option=\"" + option.value + "\"";
    if (this.dataModel.value && (this.dataModel.value + "").split(',').contains(option.value + "")) {
      optionHtml += " checked";
      optionHtml += " style=\"color:" + this.dataModel.controlColor + "\"";
    }
    else {
      optionHtml += " style=\"background-color:#ffffff;\"";
    }
    // optionHtml += ">";
    // optionHtml += "<div class=\"wx-checkbox-item\"";
    optionHtml += ">√</div>";
    // optionHtml += "</div>";
    if (option.text) {
      optionHtml += "<div class=\"wx-checkbox-label\">" + option.text + "</div>";
    } else {
      optionHtml += "<div class=\"wx-checkbox-label\">" + option.value + "</div>";
    }
    optionHtml += "</div>\r\n";
    return optionHtml;
  }


  getOptionWx(indent, option, index) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    let optionHtml = "";
    optionHtml += indent;
    optionHtml += "\t<view class=\"wx-checkbox-box";
    if (this.dataModel.portrait) optionHtml += " wx-inline";
    else optionHtml += " wx-inlineblock";
    optionHtml += "\">";
    optionHtml += "<checkbox";
    optionHtml += " value=\"" + option.value + "\"";
    optionHtml += " checked=\"{{" + vid + "_" + index + "}}\"";
    optionHtml += ">";

    if (option.text) {
      optionHtml += "<text class=\"wx-checkbox-text\">" + option.text + "</text>";
    } else {
      optionHtml += "<text class=\"wx-checkbox-text\">" + option.value + "</text>";
    }
    optionHtml += "</checkbox>";
    optionHtml += "</view>\r\n";
    return optionHtml;
  }

  addOption(option, isInit) {
    let indent = this.getHtmlIndent();
    let str = "";
    if (this.portrait && this._jqObj.children().length > 0)
      str += indent + "\t<br>\r\n";
    str += this.getOptionHtml(indent, option);
    if (str != "") {
      this._jqObj.append(str);
      this.bindOptionEvent(this._jqObj.find(".wx-checkbox-box").last().get(0));
      if (!isInit) {
        this.dataModel.options.push(option);
      }
    }
  }

  bindOptionEvent(el) {
    let that = this;
    $(el).click(function () {
      if (that.dataModel.disabled || that.dataModel.readonly) return;
      if ($(this).find("div").css("display") == "inline-block") {
        $(this).find("div").css("display", "none");
      } else {
        $(this).find("div").css("display", "inline-block");
      }
      let val = "";
      that._jqObj.find(".wx-checkbox-box").each(function () {
        if ($(this).find("div").css("display") == "inline-block") {
          if (val != "") val += ",";
          val += $(this).attr("data-option");
        }
      });
      that.dataModel.value = val;
      that.valueOnChange();
      that.exeEventHandler("onChange", val);
    });
  }

  initRuntime() {
    let that = this;
    this._jqObj.find(".wx-checkbox-box").each(function () {
      that.bindOptionEvent(this);
    });
  }
}