import { FormInput } from "../controller.js";

/**
 * 多选框组件
 * @param {[type]} dataModel [description]
 */
export default class CheckBox extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "CheckBox", dataModel, parent);
  }

  get value() { return this.dataModel.value; }
  set value(value) {
    this.dataModel.value = value;
    if (this.dataModel.readonly) {
      this._jqObj.empty();
      this._jqObj.append(this.addReadonlyOption());
    } else {
      this.checkOptionByValue();
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  get text() {
    if (!this.dataModel.value) return "";
    let vals = (this.dataModel.value + "").split(',');
    let txts = [];
    for (let i = 0; i < vals.length; i++) {
      let val = vals[i];
      if (val == null || val == undefined || val == "") continue;
      let option = this.dataModel.options.find(v => v.value == val);
      if (!option) continue;
      txts.push(option.text);
    }
    if (txts.length == 0) return "";
    return txts.join(",");
  }
  set text(txt) {
  }

  get options() { return this.dataModel.options }
  set options(value) {
    if (!value) return;
    this.setOptions(value);
    if (this._jqObj) {
      this._jqObj.empty();
      if (this.dataModel.readonly) {
        this._jqObj.append(this.addReadonlyOption());
      } else {
        if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') this._jqObj.append("\t<div class=\"tfp-checkbox-button\">\r\n");
        for (var i = 0; i < value.length; i++) {
          if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
            this.addButtonOption(value[i], i);
          } else {
            this.addOption(value[i], true);
          }
        }
      }
    }
  }

  get valueField() { return this.dataModel.valueField }
  set valueField(value) { this.dataModel.valueField = value }

  get textField() { return this.dataModel.textField }
  set textField(value) { this.dataModel.textField = value }

  get showStyle() { return this.dataModel.showStyle }
  set showStyle(value) {
    this.dataModel.showStyle = value;
    if (this._jqObj) {
      this._jqObj.empty();
      if (this.dataModel.readonly) {
        this._jqObj.append(this.addReadonlyOption());
      } else {
        if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') this._jqObj.append("\t<div class=\"tfp-checkbox-button\">\r\n");
        for (var i = 0; i < this.dataModel.options.length; i++) {
          if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
            this.addButtonOption(this.dataModel.options[i], i);
          } else {
            this.addOption(this.dataModel.options[i], true);
          }
        }
      }
    }
  }

  get jsonDataSet() { return this.dataModel.jsonDataSet }
  set jsonDataSet(value) {
    this.dataModel.jsonDataSet = value;
  }

  get typeCode() { return this.dataModel.typeCode }
  set typeCode(value) { this.dataModel.typeCode = value }

  get portrait() { return this.dataModel.portrait }
  set portrait(value) {
    this.dataModel.portrait = value ? true : false;
    if (this._jqObj) {
      if (value) {
        let that = this;
        this._jqObj.find("label").each(function (index) {
          if (index < (that._jqObj.find("label").length - 1)) {
            $("<br/>").insertAfter($(this));
          }
        });
      } else {
        this._jqObj.find("br").remove();
      }
    }
  }

  checkOptionByValue() {
    //不能返回，因为如果值为空，要清除已选择的选项
    //if(!this.dataModel.value) return;
    if (this._jqObj) {
      let arrVal = (this.dataModel.value + "").split(",");
      if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
        this._jqObj.find(".tfp-checkbox-button .tfp-checkbox-button-item").each(function () {
          $(this).removeClass('tfp-checkbox-button-false');
          $(this).removeClass('tfp-checkbox-button-true');
          if (arrVal.contains($(this).attr("data-option"))) {
            $(this).addClass('tfp-checkbox-button-true');
          } else {
            $(this).addClass('tfp-checkbox-button-false');
          }
        });
      } else {
        this._jqObj.find(".tfp-checkbox-box").each(function () {
          if (arrVal.contains($(this).attr("data-option"))) {
            $(this).children().css("display", "block");
          } else {
            $(this).children().css("display", "none");
          }
        });
      }
    }
  }

  getOption(index) {
    return this.dataModel.options[index];
  }

  getOptionByValue(val) {
    return this.dataModel.options.find(v => v.value == val);
  }

  getSelectedOptions() {
    if (!this.dataModel.value) return [];
    let vals = (this.dataModel.value + "").split(',');
    let options = [];
    for (let i = 0; i < vals.length; i++) {
      let val = vals[i];
      if (val == null || val == undefined || val == "") continue;
      let option = this.dataModel.options.find(v => v.value == val);
      if (!option) continue;
      options.push(option);
    }
    return options;
  }

  getOptionHtml(indent, option) {
    let optionHtml = "";
    let optionDisplay = "none";
    if (this.value && (this.value + "").split(",").contains(option.value))
      optionDisplay = "block";
    let disabledStyle = "";
    if (this.dataModel.disabled) disabledStyle = " style=\"background-color:#eeeeee;\"";
    optionHtml += indent + "\t<div class=\"tfp-checkbox-box\" "
      + disabledStyle + " data-option=\"" + option.value + "\">";
    if (this.dataModel.showStyle == 'checkMode') {
      optionHtml += "<span class=\"tfp-checkbox-button-true\" style=\"font-size:10px;height:100%;display:" + optionDisplay + ";\">✔</span>";
    } else {
      optionHtml += "<div style=\"display:" + optionDisplay + ";\"></div>";
    }
    optionHtml += "</div> ";
    if (option.text) {
      optionHtml += "<label class=\"tfp-checkbox-label\">" + option.text + "</label>\r\n";
    } else {
      optionHtml += "<label class=\"tfp-checkbox-label\">" + option.value + "</label>\r\n";
    }
    return optionHtml;
  }

  addReadonlyOption() {
    let labelHtml = "";
    let text = [];
    for (var i = 0; i < this.dataModel.options.length; i++) {
      let option = this.dataModel.options[i];
      if (this.value && (this.value + "").split(",").contains(option.value + '')) {
        if (option.text) {
          text.push(option.text);
        } else {
          text.push(option.value);
        }
      }
    }
    labelHtml += "<label class=\"tfp-checkbox-label\" style=\"margin-left:0px;\">" + text.join(',') + "</label>\r\n";
    return labelHtml;
  }

  addOption(option, isInit) {
    let indent = this.getHtmlIndent();
    let str = "";
    if (this.portrait && this._jqObj.children().length > 0)
      str += indent + "\t<br>\r\n";
    str += this.getOptionHtml(indent, option);
    if (str != "") {
      if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
        this._jqObj.find(".tfp-checkbox-button").append(str);
        this.bindButtonOptionEvent(this._jqObj.find(".tfp-checkbox-button").children(':last-child'));
      } else {
        this._jqObj.append(str);
        this.bindOptionEvent(this._jqObj.find(".tfp-checkbox-box").last().get(0));
        this.bindOptionEvent(this._jqObj.find(".tfp-checkbox-label").last().get(0));
      }
      if (!isInit) {
        this.dataModel.options.push(option);
      }
    }
  }

  bindOptionEvent(el) {
    let that = this;
    $(el).click(function () {
      if (that.dataModel.disabled || that.dataModel.readonly) return;
      let elHtml = $(this);
      if ($(this).hasClass("tfp-checkbox-label")) elHtml = $(this).prev();

      if (elHtml.children().css("display") == "block") {
        elHtml.children().css("display", "none");
      } else {
        elHtml.children().css("display", "block");
      }
      let val = "";
      that._jqObj.find(".tfp-checkbox-box").each(function () {
        if ($(this).children().css("display") == "block") {
          if (val != "") val += ",";
          val += $(this).attr("data-option");
        }
      });
      that.dataModel.value = val;
      that.valueOnChange();
      that.exeEventHandler("onChange", val);
      that._tfp.runRules(that);
    });
  }

  addButtonOption(option, i) {
    let indent = this.getHtmlIndent();
    let str = "";
    str += this.getButtonOptionHtml(indent, option, i);
    if (str != "") {
      this._jqObj.find(".tfp-checkbox-button").append(str);
      this.bindButtonOptionEvent(this._jqObj.find(".tfp-checkbox-button").children(':last-child'));
    }
  }

  getButtonOptionHtml(indent, option, index) {
    let optionHtml = "";
    let optionDisplay = "tfp-checkbox-button-false";
    if (this.value && (this.value + "").split(",").contains(option.value))
      optionDisplay = "tfp-checkbox-button-true";

    optionHtml += "<div class=\"tfp-checkbox-button-item " + optionDisplay + "\" data-option=\"" + option.value + "\" style=\""
    if (this.dataModel.showStyle == "disperseMode") optionHtml += "margin-right: 10px;border-radius: 15px;border:0px;";
    if (this.dataModel.showStyle == "buttonMode" && index == 0) optionHtml += "border-radius: 4px 0 0 4px;";
    if (this.dataModel.showStyle == "buttonMode" && index == this.dataModel.options.length - 1) optionHtml += "border-radius: 0 4px 4px 0;";
    optionHtml += "\">"

    if (option.text) {
      optionHtml += option.text;
    } else {
      optionHtml += option.value;
    }
    optionHtml += "</div>\r\n";

    return optionHtml;
  }

  bindButtonOptionEvent(el) {
    let that = this;
    $(el).click(function () {
      if (that.dataModel.disabled || that.dataModel.readonly) return;
      if ($(this).hasClass("tfp-checkbox-button-true")) {
        $(this).removeClass("tfp-checkbox-button-true");
        $(this).addClass("tfp-checkbox-button-false");
      } else {
        $(this).removeClass("tfp-checkbox-button-false");
        $(this).addClass("tfp-checkbox-button-true");
      }
      let val = "";
      that._jqObj.find(".tfp-checkbox-button-item").each(function () {
        if ($(this).hasClass("tfp-checkbox-button-true")) {
          if (val != "") val += ",";
          val += $(this).attr("data-option");
        }
      });
      that.dataModel.value = val;
      that.valueOnChange();
      that.exeEventHandler("onChange", val);
      that._tfp.runRules(that);
    });
  }

  bindOptionsEvent() {
    var that = this;
    if (this.dataModel.showStyle == 'buttonMode' || this.dataModel.showStyle == 'disperseMode') {
      this._jqObj.find(".tfp-checkbox-button-item").each(function () {
        that.bindButtonOptionEvent(this);
      });
    } else {
      this._jqObj.find(".tfp-checkbox-box,.tfp-checkbox-label").each(function () {
        that.bindOptionEvent(this);
      });
    }
  }

  bindData(data) {
    if (data.rows && data.rowsCount) {
      data = data.rows;
    }
    if (!Array.isArray(data)) return;
    let options = [];
    for (let i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {
        value: row[this.dataModel.valueField]
      };
      if (this.dataModel.textField) {
        option.text = row[this.dataModel.textField];
      } else {
        option.text = option.value;
      }
      options.push(option);
    }
    this.options = options;
    //根据组件值选中对应的选项
    this.checkOptionByValue();
    if (this.dataModel.onBindData) {
      try {
        eval(this.dataModel.onBindData);
      } catch (err) {
        console.log(err);
      }
    }
  }

  initRuntime() {
    let that = this;

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    } else if (this.dataModel.typeCode) {
      this.dataModel.valueField = "code";
      this.dataModel.textField = "name";

      this._tfp.use("Service", function () {
        let service = that._tfp.new("Service");
        service.path = "sys/service/data_dic/getList.tbs";
        service.request({ typeCode: that.dataModel.typeCode }, function (req, res) {
          that.bindData(res.data);
        });
      });
    } else if (this.options && this.options.length > 0) {
      this.bindOptionsEvent();
    }
  }
}